/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import com.intellij.xml.breadcrumbs.BreadcrumbsPanel;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreadcrumbsXmlWrapper
extends BreadcrumbsPanel {
    private final VirtualFile myFile;

    public BreadcrumbsXmlWrapper(@NotNull Editor editor) {
        super(editor);
        this.myFile = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    @Override
    @Nullable
    protected Iterable<? extends Crumb> computeCrumbs(int offset) {
        FileBreadcrumbsCollector breadcrumbsCollector = BreadcrumbsXmlWrapper.findCollectorFor(this.myProject, this.myFile, this);
        if (breadcrumbsCollector == null) {
            return null;
        }
        Document document = this.myEditor.getDocument();
        Boolean forcedShown = BreadcrumbsForceShownSettings.getForcedShown(this.myEditor);
        return breadcrumbsCollector.computeCrumbs(this.myFile, document, offset, forcedShown);
    }

    public void navigate(NavigatableCrumb crumb, boolean withSelection) {
        this.myUserCaretChange = false;
        crumb.navigate(this.myEditor, withSelection);
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbsWrapper(@NotNull Editor editor) {
        return (BreadcrumbsXmlWrapper)ObjectUtils.tryCast((Object)BreadcrumbsPanel.getBreadcrumbsComponent(editor), BreadcrumbsXmlWrapper.class);
    }
}

