/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.utils;

import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.frame.XSuspendContext;
import org.jetbrains.annotations.NotNull;

public class SingleAlarmWithMutableDelay {
    private final Alarm myAlarm;
    private final Task myTask;
    private volatile int myDelayMillis;

    public SingleAlarmWithMutableDelay(@NotNull Task task2, @NotNull Disposable parentDisposable) {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        this.myTask = task2;
    }

    public void setDelay(int millis) {
        this.myDelayMillis = millis;
    }

    public void cancelAndRequest(@NotNull XSuspendContext suspendContext) {
        this.cancelAndAddRequest(suspendContext, this.myDelayMillis);
    }

    public void cancelAndRequestImmediate(@NotNull XSuspendContext suspendContext) {
        this.cancelAndAddRequest(suspendContext, 0);
    }

    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    private void cancelAndAddRequest(@NotNull XSuspendContext suspendContext, int delayMillis) {
        if (!this.myAlarm.isDisposed()) {
            this.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.myTask.run(suspendContext), delayMillis);
        }
    }

    @FunctionalInterface
    public static interface Task {
        public void run(@NotNull XSuspendContext var1);
    }
}

