/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.pinned.items.PinToTopParentValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchesRootNode
extends XValueContainerNode<XValueContainer> {
    private final XWatchesView myWatchesView;
    private final List<WatchNodeImpl> myChildren;

    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, XExpression @NotNull [] expressions) {
        this(tree, watchesView, Arrays.asList(expressions), null, false);
    }

    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull List<? extends XExpression> expressions, @Nullable XStackFrame stackFrame, boolean watchesInVariables) {
        super(tree, null, false, new RootContainerNode(stackFrame, watchesInVariables));
        this.myWatchesView = watchesView;
        this.myChildren = new ArrayList<WatchNodeImpl>();
        for (XExpression xExpression : expressions) {
            this.myChildren.add(new WatchNodeImpl(this.myTree, this, xExpression, stackFrame));
        }
    }

    @Override
    @NotNull
    public List<? extends XValueContainerNode<?>> getLoadedChildren() {
        return ContainerUtil.concat(this.myChildren, super.getLoadedChildren());
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        List<TreeNode> children2 = super.getChildren();
        return ContainerUtil.concat(this.myChildren, children2);
    }

    @Deprecated
    @NotNull
    public List<? extends WatchNode> getAllChildren() {
        return this.getWatchChildren();
    }

    @NotNull
    public List<? extends WatchNode> getWatchChildren() {
        return this.myChildren;
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.myChildren.clear();
    }

    public void computeWatches() {
        this.myChildren.forEach(WatchNodeImpl::computePresentationIfNeeded);
    }

    @Deprecated
    public void addWatchExpression(@Nullable XDebuggerEvaluator evaluator, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        this.addWatchExpression((XStackFrame)null, expression, index, navigateToWatchNode);
    }

    public void addWatchExpression(@Nullable XStackFrame stackFrame, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        WatchNodeImpl message = new WatchNodeImpl(this.myTree, this, expression, stackFrame);
        if (index == -1) {
            this.myChildren.add(message);
            index = this.myChildren.size() - 1;
        } else {
            this.myChildren.add(index, message);
        }
        this.fireNodeInserted(index);
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)message);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message.getPath());
        }
    }

    private void fireNodeInserted(int index) {
        this.myTree.getTreeModel().nodesWereInserted(this, new int[]{index});
    }

    public int removeChildNode(XDebuggerTreeNode node) {
        return this.removeChildNode(this.myChildren, node);
    }

    public void removeChildren(Collection<? extends XDebuggerTreeNode> nodes) {
        int[] indices = this.getNodesIndices(nodes);
        TreeNode[] removed = this.getChildNodes(indices);
        this.myChildren.removeAll(nodes);
        this.fireNodesRemoved(indices, removed);
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.fireNodeStructureChanged();
    }

    public void moveUp(WatchNode node) {
        int index = this.getIndex(node);
        if (index > 0) {
            ContainerUtil.swapElements(this.myChildren, (int)index, (int)(index - 1));
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index - 1);
    }

    public void moveDown(WatchNode node) {
        int index = this.getIndex(node);
        if (index < this.myChildren.size() - 1) {
            ContainerUtil.swapElements(this.myChildren, (int)index, (int)(index + 1));
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index + 1);
    }

    public void addNewWatch() {
        this.editWatch(null);
    }

    public void editWatch(@Nullable WatchNodeImpl node) {
        WatchNodeImpl messageNode;
        int index;
        int n = index = node != null ? this.myChildren.indexOf(node) : -1;
        if (index == -1) {
            int selectedIndex = this.myChildren.indexOf(ArrayUtil.getFirstElement((Object[])this.myTree.getSelectedNodes(WatchNodeImpl.class, null)));
            int targetIndex = selectedIndex == -1 ? this.myChildren.size() : selectedIndex + 1;
            messageNode = new WatchNodeImpl(this.myTree, this, XExpressionImpl.EMPTY_EXPRESSION, null);
            this.myChildren.add(targetIndex, messageNode);
            this.fireNodeInserted(targetIndex);
            this.getTree().setSelectionRows(ArrayUtilRt.EMPTY_INT_ARRAY);
        } else {
            messageNode = node;
        }
        new WatchInplaceEditor(this, this.myWatchesView, messageNode, node).show();
    }

    static class RootContainerNode
    extends XValueContainer
    implements PinToTopParentValue {
        private final XStackFrame stackFrame;
        private final boolean watchesInVariables;

        public RootContainerNode(@Nullable XStackFrame stackFrame, boolean watchesInVariables) {
            this.stackFrame = stackFrame;
            this.watchesInVariables = watchesInVariables;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (this.stackFrame != null && this.watchesInVariables) {
                this.stackFrame.computeChildren(node);
            } else {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
        }

        @Override
        @Nullable
        public String getTag() {
            if (this.stackFrame instanceof PinToTopParentValue) {
                return ((PinToTopParentValue)this.stackFrame).getTag();
            }
            return null;
        }
    }
}

