/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import org.jetbrains.annotations.NotNull;

public class EvaluatingExpressionRootNode
extends XValueContainerNode<EvaluatingResultContainer> {
    public EvaluatingExpressionRootNode(XDebuggerEvaluationDialog evaluationDialog, XDebuggerTree tree) {
        super(tree, null, false, new EvaluatingResultContainer(evaluationDialog));
    }

    @Override
    protected MessageTreeNode createLoadingMessageNode() {
        return MessageTreeNode.createEvaluatingMessage(this.myTree, this);
    }

    public static class EvaluatingResultContainer
    extends XValueContainer {
        private final XDebuggerEvaluationDialog myDialog;

        public EvaluatingResultContainer(XDebuggerEvaluationDialog dialog2) {
            this.myDialog = dialog2;
        }

        public void computeChildren(final @NotNull XCompositeNode node) {
            this.myDialog.startEvaluation(new XEvaluationCallbackBase(){

                public void evaluated(@NotNull XValue result2) {
                    String name = UIUtil.removeMnemonic((String)XDebuggerBundle.message((String)"xdebugger.evaluate.result", (Object[])new Object[0]));
                    node.addChildren(XValueChildrenList.singleton((String)name, (XValue)result2), true);
                    myDialog.evaluationDone();
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    node.setErrorMessage(errorMessage);
                    myDialog.evaluationDone();
                }
            });
        }
    }
}

