/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import icons.PlatformDebuggerImplIcons;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private final MyColoredTreeCellRenderer myLink = new MyColoredTreeCellRenderer();
    private boolean myHaveLink;
    private int myLinkOffset;
    private int myLinkWidth;
    private Object myIconTag;
    private final MyLongTextHyperlink myLongTextLink = new MyLongTextHyperlink();

    XDebuggerTreeRenderer() {
        this.getIpad().right = 0;
        this.myLink.getIpad().left = 0;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myHaveLink = false;
        this.myLink.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
        XDebuggerTreeNode node = (XDebuggerTreeNode)value2;
        node.appendToComponent((ColoredTextContainer)this);
        this.updateIcon(node);
        this.myIconTag = node.getIconTag();
        Rectangle treeVisibleRect = tree.getParent() instanceof JViewport ? ((JViewport)tree.getParent()).getViewRect() : tree.getVisibleRect();
        int rowX = TreeUtil.getNodeRowX((JTree)tree, (int)row);
        if (this.myHaveLink) {
            this.setupLinkDimensions(treeVisibleRect, rowX);
        } else {
            String rawValue;
            int visibleRectRightX = treeVisibleRect.x + treeVisibleRect.width;
            int notFittingWidth = rowX + super.getPreferredSize().width - visibleRectRightX;
            if (node instanceof XValueNodeImpl && notFittingWidth > 0 && !StringUtil.isEmpty((String)(rawValue = DebuggerUIUtil.getNodeRawValue((XValueNodeImpl)node))) && tree.isShowing()) {
                Point treeRightSideOnScreen = new Point(visibleRectRightX, treeVisibleRect.y);
                SwingUtilities.convertPointToScreen(treeRightSideOnScreen, tree);
                Rectangle screen = ScreenUtil.getScreenRectangle((Point)treeRightSideOnScreen);
                if (screen.x + screen.width < treeRightSideOnScreen.x + notFittingWidth) {
                    this.myLongTextLink.setupComponent(rawValue, ((XDebuggerTree)((Object)tree)).getProject());
                    this.append(this.myLongTextLink.getLinkText(), this.myLongTextLink.getTextAttributes(), (Object)this.myLongTextLink);
                    this.setupLinkDimensions(treeVisibleRect, rowX);
                    this.myLinkWidth = 0;
                }
            }
        }
        this.putClientProperty(ExpandableItemsHandler.RENDERER_DISABLED, this.myHaveLink);
    }

    private void updateIcon(XDebuggerTreeNode node) {
        Icon icon2 = node instanceof XValueNodeImpl && node.getTree().getPinToTopManager().isEnabled() && node.getTree().getPinToTopManager().isItemPinned((XValueNodeImpl)node) ? PlatformDebuggerImplIcons.PinToTop.PinnedItem : node.getIcon();
        this.setIcon(icon2);
    }

    private void setupLinkDimensions(Rectangle treeVisibleRect, int rowX) {
        Dimension linkSize = this.myLink.getPreferredSize();
        this.myLinkWidth = linkSize.width;
        this.myLinkOffset = Math.min(super.getPreferredSize().width, treeVisibleRect.x + treeVisibleRect.width - this.myLinkWidth - rowX);
        this.myLink.setSize(this.myLinkWidth, this.getHeight());
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag2) {
        if (tag2 instanceof XDebuggerTreeNodeHyperlink && ((XDebuggerTreeNodeHyperlink)tag2).alwaysOnScreen()) {
            this.myHaveLink = true;
            this.myLink.append(fragment, attributes, tag2);
        } else {
            super.append(fragment, attributes, tag2);
        }
    }

    protected void doPaint(Graphics2D g) {
        if (this.myHaveLink) {
            Graphics2D textGraphics = (Graphics2D)g.create(0, 0, this.myLinkOffset, this.getHeight());
            try {
                super.doPaint(textGraphics);
            }
            finally {
                textGraphics.dispose();
            }
            g.translate(this.myLinkOffset, 0);
            this.myLink.setSize(this.myLink.getWidth(), this.getHeight());
            this.myLink.doPaint(g);
            g.translate(-this.myLinkOffset, 0);
        } else {
            super.doPaint(g);
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myHaveLink) {
            size.width += this.myLinkWidth;
        }
        return size;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        Object linkTag;
        if (this.myHaveLink && (linkTag = this.myLink.getFragmentTagAt(x - this.myLinkOffset)) != null) {
            return linkTag;
        }
        Object baseFragment = super.getFragmentTagAt(x);
        if (baseFragment != null) {
            return baseFragment;
        }
        if (this.myIconTag != null && this.findFragmentAt(x) == -2) {
            return this.myIconTag;
        }
        return null;
    }

    private static class MyLongTextHyperlink
    extends XDebuggerTreeNodeHyperlink {
        private String myText;
        private Project myProject;

        MyLongTextHyperlink() {
            super(XDebuggerBundle.message((String)"node.test.show.full.value", (Object[])new Object[0]));
        }

        public void setupComponent(String text, Project project) {
            this.myText = text;
            this.myProject = project;
        }

        public boolean alwaysOnScreen() {
            return true;
        }

        public void onClick(MouseEvent event) {
            DebuggerUIUtil.showValuePopup((XFullValueEvaluator)new ImmediateFullValueEvaluator(this.myText), event, this.myProject, null);
            event.consume();
        }
    }

    private static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
        }
    }
}

