/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeInplaceEditor
implements AWTEventListener {
    private static final Logger LOG = Logger.getInstance(TreeInplaceEditor.class);
    private JComponent myInplaceEditorComponent;
    private final List<Runnable> myRemoveActions = new ArrayList<Runnable>();
    protected final Disposable myDisposable = Disposer.newDisposable();

    protected abstract JComponent createInplaceEditorComponent();

    protected abstract JComponent getPreferredFocusedComponent();

    public abstract Editor getEditor();

    public abstract JComponent getEditorComponent();

    protected abstract TreePath getNodePath();

    protected abstract JTree getTree();

    protected void doPopupOKAction() {
        this.doOKAction();
    }

    public void doOKAction() {
        this.hide();
    }

    public void cancelEditing() {
        this.hide();
    }

    private void hide() {
        if (!this.isShown()) {
            return;
        }
        this.myInplaceEditorComponent = null;
        this.onHidden();
        this.myRemoveActions.forEach(Runnable::run);
        this.myRemoveActions.clear();
        Disposer.dispose((Disposable)this.myDisposable);
        JTree tree = this.getTree();
        tree.repaint();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)tree, true));
    }

    protected void onHidden() {
    }

    protected abstract Project getProject();

    private static void setInplaceEditorBounds(JComponent component2, int x, int y, int width, int height) {
        int h = Math.max(height, component2.getPreferredSize().height);
        component2.setBounds(x, y - (h - height) / 2, width, h);
    }

    public final void show() {
        JComponent inplaceEditorComponent;
        LOG.assertTrue(this.myInplaceEditorComponent == null, (Object)"editor is not released");
        JTree tree = this.getTree();
        tree.scrollPathToVisible(this.getNodePath());
        JRootPane rootPane = tree.getRootPane();
        if (rootPane == null) {
            return;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Rectangle bounds2 = this.getEditorBounds();
        if (bounds2 == null) {
            return;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint(tree, bounds2.x, bounds2.y, layeredPane);
        this.myInplaceEditorComponent = inplaceEditorComponent = this.createInplaceEditorComponent();
        LOG.assertTrue(inplaceEditorComponent != null);
        TreeInplaceEditor.setInplaceEditorBounds(inplaceEditorComponent, layeredPanePoint.x, layeredPanePoint.y, bounds2.width, bounds2.height);
        layeredPane.add((Component)inplaceEditorComponent, new Integer(250));
        this.myRemoveActions.add(() -> layeredPane.remove(inplaceEditorComponent));
        inplaceEditorComponent.validate();
        inplaceEditorComponent.paintImmediately(0, 0, inplaceEditorComponent.getWidth(), inplaceEditorComponent.getHeight());
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getPreferredFocusedComponent(), true));
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                this.resetBounds();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.resetBounds();
            }

            private void resetBounds() {
                Project project = TreeInplaceEditor.this.getProject();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!TreeInplaceEditor.this.isShown() || project == null || project.isDisposed()) {
                        return;
                    }
                    JTree tree1 = TreeInplaceEditor.this.getTree();
                    JLayeredPane layeredPane1 = tree1.getRootPane().getLayeredPane();
                    Rectangle bounds1 = TreeInplaceEditor.this.getEditorBounds();
                    if (bounds1 == null) {
                        TreeInplaceEditor.this.doOKAction();
                        return;
                    }
                    Point layeredPanePoint1 = SwingUtilities.convertPoint(tree1, bounds1.x, bounds1.y, layeredPane1);
                    TreeInplaceEditor.setInplaceEditorBounds(inplaceEditorComponent, layeredPanePoint1.x, layeredPanePoint1.y, bounds1.width, bounds1.height);
                    inplaceEditorComponent.revalidate();
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TreeInplaceEditor.this.cancelEditing();
            }
        };
        HierarchyListener hierarchyListener = e -> {
            if (!tree.isShowing()) {
                this.cancelEditing();
            }
        };
        tree.addHierarchyListener(hierarchyListener);
        tree.addComponentListener(componentListener);
        rootPane.addComponentListener(componentListener);
        this.myRemoveActions.add(() -> {
            tree.removeHierarchyListener(hierarchyListener);
            tree.removeComponentListener(componentListener);
            rootPane.removeComponentListener(componentListener);
        });
        this.getProject().getMessageBus().connect(this.myDisposable).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                TreeInplaceEditor.this.cancelEditing();
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                TreeInplaceEditor.this.cancelEditing();
            }
        });
        JComponent editorComponent = this.getEditorComponent();
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterStroke");
        editorComponent.getActionMap().put("enterStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeInplaceEditor.this.doOKAction();
            }
        });
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escapeStroke");
        editorComponent.getActionMap().put("escapeStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeInplaceEditor.this.cancelEditing();
            }
        });
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        SwingUtilities.invokeLater(() -> {
            if (!this.isShown()) {
                return;
            }
            defaultToolkit.addAWTEventListener(this, 16L);
        });
        this.myRemoveActions.add(() -> defaultToolkit.removeAWTEventListener(this));
        this.onShown();
    }

    protected void onShown() {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Component componentAtPoint;
        Point point;
        LookupImpl activeLookup;
        if (!this.isShown()) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        if (mouseEvent.getClickCount() == 0) {
            return;
        }
        int id2 = mouseEvent.getID();
        if (id2 != 501 && id2 != 502 && id2 != 500) {
            return;
        }
        Component sourceComponent = mouseEvent.getComponent();
        Point originalPoint = mouseEvent.getPoint();
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        List popups = JBPopupFactory.getInstance().getChildPopups((Component)this.myInplaceEditorComponent);
        for (JBPopup popup2 : popups) {
            if (popup2.isDisposed() || !SwingUtilities.isDescendingFrom(sourceComponent, ComponentUtil.getWindow((Component)popup2.getContent()))) continue;
            return;
        }
        Project project = editor.getProject();
        LookupImpl lookupImpl = activeLookup = project != null ? (LookupImpl)LookupManager.getInstance(project).getActiveLookup() : null;
        if (activeLookup != null) {
            Point lookupPoint = SwingUtilities.convertPoint(sourceComponent, originalPoint, activeLookup.getComponent());
            if (activeLookup.getComponent().getBounds().contains(lookupPoint)) {
                return;
            }
            activeLookup.hide();
        }
        if (this.myInplaceEditorComponent.contains(point = SwingUtilities.convertPoint(sourceComponent, originalPoint, this.myInplaceEditorComponent))) {
            return;
        }
        for (Component comp = componentAtPoint = SwingUtilities.getDeepestComponentAt(sourceComponent, originalPoint.x, originalPoint.y); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof ComboPopup)) continue;
            this.doPopupOKAction();
            return;
        }
        if (ComponentUtil.getWindow((Component)sourceComponent) == ComponentUtil.getWindow((Component)this.myInplaceEditorComponent) && id2 == 501) {
            this.doOKAction();
        }
    }

    @Nullable
    protected Rectangle getEditorBounds() {
        JTree tree = this.getTree();
        Rectangle bounds2 = tree.getVisibleRect();
        Rectangle nodeBounds = tree.getPathBounds(this.getNodePath());
        if (bounds2 == null || nodeBounds == null) {
            return null;
        }
        if (bounds2.y > nodeBounds.y || bounds2.y + bounds2.height < nodeBounds.y + nodeBounds.height) {
            return null;
        }
        bounds2.y = nodeBounds.y;
        bounds2.height = nodeBounds.height;
        if (nodeBounds.x > bounds2.x) {
            bounds2.width = bounds2.width - nodeBounds.x + bounds2.x;
            bounds2.x = nodeBounds.x;
        }
        return bounds2;
    }

    public boolean isShown() {
        return this.myInplaceEditorComponent != null;
    }
}

