/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;

public class BreakpointEditor {
    private JPanel myMainPanel;
    private JButton myDoneButton;
    private JPanel myPropertiesPlaceholder;
    private LinkLabel myShowMoreOptionsLink;
    private Delegate myDelegate;

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        AnAction action2 = ActionManager.getInstance().getAction("ViewBreakpoints");
        String shortcutText = action2 != null ? KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2) : null;
        String text = XDebuggerBundle.message((String)"xbreakpoints.popup.more.label", (Object[])new Object[0]);
        if (shortcutText != null) {
            text = text + " (" + shortcutText + ")";
        }
        this.myShowMoreOptionsLink = LinkLabel.create((String)text, () -> {
            if (this.myDelegate != null) {
                this.myDelegate.more();
            }
        });
    }

    public void setShowMoreOptionsLink(boolean b) {
        this.myShowMoreOptionsLink.setVisible(b);
    }

    public BreakpointEditor() {
        this.$$$setupUI$$$();
        this.myDoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointEditor.this.done();
            }
        });
        DumbAwareAction doneAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                JComboBox comboBox2;
                super.update(e);
                Project project = 2.getEventProject((AnActionEvent)e);
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                boolean disabled = project != null && (LookupManager.getInstance(project).getActiveLookup() != null || editor != null && TemplateManager.getInstance(project).getActiveTemplate(editor) != null);
                Component owner = IdeFocusManager.findInstance().getFocusOwner();
                if (owner != null && (comboBox2 = (JComboBox)ComponentUtil.getParentOfType(JComboBox.class, (Component)owner)) != null && comboBox2.isPopupVisible()) {
                    disabled = true;
                }
                e.getPresentation().setEnabled(!disabled && (editor == null || StringUtil.isEmpty((String)editor.getSelectionModel().getSelectedText())));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                BreakpointEditor.this.done();
            }
        };
        doneAction.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.ESCAPE, CommonShortcuts.ENTER, CommonShortcuts.CTRL_ENTER}), (JComponent)this.myMainPanel);
        this.myMainPanel.setFocusCycleRoot(true);
        this.myMainPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    private void done() {
        if (this.myDelegate != null) {
            this.myDelegate.done();
        }
    }

    public void setPropertiesPanel(JComponent p) {
        this.myPropertiesPlaceholder.removeAll();
        this.myPropertiesPlaceholder.add((Component)p, "Center");
    }

    public void setDelegate(Delegate d) {
        this.myDelegate = d;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        this.myPropertiesPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDoneButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", BreakpointEditor.class).getString("done.action.text"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        LinkLabel linkLabel = this.myShowMoreOptionsLink;
        jPanel4.add((Component)linkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void done();

        public void more();
    }
}

