/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.settings.GeneralConfigurableUi;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class XDebuggerConfigurableProvider
extends DebuggerConfigurableProvider {
    XDebuggerConfigurableProvider() {
    }

    @NotNull
    public Collection<? extends Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        SmartList list2 = category == DebuggerSettingsCategory.GENERAL ? new SmartList((Object)SimpleConfigurable.create((String)"debugger.general", (String)"", GeneralConfigurableUi.class, () -> XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings())) : null;
        for (XDebuggerSettings settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            Collection configurables = settings.createConfigurables(category);
            if (configurables.isEmpty()) continue;
            if (list2 == null) {
                list2 = new SmartList();
            }
            list2.addAll(configurables);
        }
        if (category == DebuggerSettingsCategory.ROOT) {
            for (XDebuggerSettings settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
                Configurable configurable2 = settings.createConfigurable();
                if (configurable2 == null) continue;
                if (list2 == null) {
                    list2 = new SmartList();
                }
                list2.add(configurable2);
            }
        }
        return ContainerUtil.notNullize((List)list2);
    }

    public void generalApplied(@NotNull DebuggerSettingsCategory category) {
        for (XDebuggerSettings settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            settings.generalApplied(category);
        }
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable2) {
        for (XDebuggerSettings settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            if (!settings.isTargetedToProduct(configurable2)) continue;
            return true;
        }
        return super.isTargetedToProduct(configurable2);
    }
}

