/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryContainer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DebuggerTreeWithHistoryPanel<D>
extends DebuggerTreeWithHistoryContainer<D> {
    private final BorderLayoutPanel myMainPanel;
    private final Disposable myDisposable;
    private XDebuggerTree myTree;

    public DebuggerTreeWithHistoryPanel(@NotNull D initialItem, @NotNull DebuggerTreeCreator<D> creator, @NotNull Project project, Disposable disposable2) {
        super(initialItem, creator, project);
        this.myDisposable = disposable2;
        this.myTree = (XDebuggerTree)this.myTreeCreator.createTree(initialItem);
        DebuggerTreeWithHistoryPanel.registerTreeDisposable(this.myDisposable, this.myTree);
        this.myMainPanel = this.createMainPanel(this.myTree);
    }

    @Override
    protected void updateContainer(Tree tree, String title) {
        this.myTree = (XDebuggerTree)tree;
        DebuggerTreeWithHistoryPanel.registerTreeDisposable(this.myDisposable, tree);
        this.myMainPanel.removeAll();
        this.fillMainPanel(this.myMainPanel, tree);
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void rebuild() {
        this.myTree.invokeLater(() -> this.myTree.rebuildAndRestore(XDebuggerTreeState.saveState(this.myTree)));
    }

    public XDebuggerTree getTree() {
        return this.myTree;
    }
}

