/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.evaluate.EvaluationInputComponent;
import com.intellij.xdebugger.impl.evaluate.ExpressionInputForm;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionInputComponent
extends EvaluationInputComponent {
    private final XDebuggerEditorBase myExpressionEditor;
    private final ExpressionInputForm myMainForm = new ExpressionInputForm();

    public ExpressionInputComponent(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable String historyId, @Nullable XSourcePosition sourcePosition, @Nullable XExpression expression, @NotNull Disposable parentDisposable, boolean showHelp) {
        super(XDebuggerBundle.message((String)"xdebugger.dialog.title.evaluate.expression", (Object[])new Object[0]));
        BorderLayoutPanel expressionPanel = JBUI.Panels.simplePanel();
        this.myExpressionEditor = new XDebuggerExpressionComboBox(project, editorsProvider, historyId, sourcePosition, true, false){

            @Override
            protected void prepareEditor(Editor editor) {
                Font font = EditorUtil.getEditorFont();
                editor.getColorsScheme().setEditorFontName(font.getFontName());
                editor.getColorsScheme().setEditorFontSize(font.getSize());
                editor.getSettings().setLineCursorWidth(EditorUtil.getDefaultCaretWidth());
            }
        };
        this.myExpressionEditor.setExpression(expression);
        expressionPanel.addToCenter((Component)this.myExpressionEditor.getComponent());
        JBLabel help = new JBLabel(XDebuggerBundle.message((String)"xdebugger.evaluate.addtowatches.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)XDebuggerEvaluationDialog.ADD_WATCH_KEYSTROKE)}), 4);
        help.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)6, (int)0));
        help.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        help.setFontColor(UIUtil.FontColor.BRIGHTER);
        expressionPanel.addToBottom((Component)help);
        help.setVisible(showHelp);
        this.myMainForm.addExpressionComponent((JComponent)expressionPanel);
        this.myMainForm.addLanguageComponent(this.myExpressionEditor.getLanguageChooser());
    }

    @Override
    public void addComponent(JPanel contentPanel2, JPanel resultPanel) {
        contentPanel2.add((Component)resultPanel, "Center");
        contentPanel2.add((Component)this.myMainForm.getMainPanel(), "North");
    }

    @Override
    public JPanel getMainComponent() {
        return this.myMainForm.getMainPanel();
    }

    @Override
    @NotNull
    public XDebuggerEditorBase getInputEditor() {
        return this.myExpressionEditor;
    }
}

