/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.AppTopics;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUrlChangeAdapter;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XLineBreakpointManager {
    private final BidirectionalMap<XLineBreakpointImpl, String> myBreakpoints = new BidirectionalMap();
    private final MergingUpdateQueue myBreakpointsUpdateQueue;
    private final Project myProject;
    private boolean myDragDetected = false;

    public XLineBreakpointManager(@NotNull Project project) {
        this.myProject = project;
        MessageBusConnection busConnection = project.getMessageBus().connect();
        if (!this.myProject.isDefault()) {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            editorEventMulticaster.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)project);
            editorEventMulticaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(), (Disposable)project);
            editorEventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)new MyEditorMouseMotionListener(), (Disposable)project);
            busConnection.subscribe(XDependentBreakpointListener.TOPIC, (Object)new MyDependentBreakpointListener());
            busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileUrlChangeAdapter(){

                @Override
                protected void fileUrlChanged(String oldUrl, String newUrl) {
                    XLineBreakpointManager.this.breakpoints().forEach(breakpoint -> {
                        String url = breakpoint.getFileUrl();
                        if (FileUtil.startsWith((String)url, (String)oldUrl)) {
                            breakpoint.setFileUrl(newUrl + url.substring(oldUrl.length()));
                        }
                    });
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    List breakpoints = XLineBreakpointManager.this.myBreakpoints.getKeysByValue((Object)event.getFile().getUrl());
                    XLineBreakpointManager.this.removeBreakpoints(breakpoints != null ? new ArrayList(breakpoints) : null);
                }
            }));
        }
        this.myBreakpointsUpdateQueue = new MergingUpdateQueue("XLine breakpoints", 300, true, null, (Disposable)project);
        busConnection.subscribe(EditorColorsManager.TOPIC, (Object)new MyEditorColorsListener());
        busConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
                List breakpoints = XLineBreakpointManager.this.myBreakpoints.getKeysByValue((Object)file2.getUrl());
                if (breakpoints != null) {
                    breakpoints.stream().filter(b -> b.getHighlighter() == null).forEach(XLineBreakpointManager.this::queueBreakpointUpdate);
                }
            }
        });
    }

    void updateBreakpointsUI() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
            for (XLineBreakpointImpl breakpoint : this.myBreakpoints.keySet()) {
                ApplicationManager.getApplication().invokeLater(() -> breakpoint.updateUI(), ModalityState.NON_MODAL, this.myProject.getDisposed());
            }
        });
    }

    public void registerBreakpoint(XLineBreakpointImpl breakpoint, boolean initUI) {
        if (initUI) {
            breakpoint.updateUI();
        }
        this.myBreakpoints.put((Object)breakpoint, (Object)breakpoint.getFileUrl());
    }

    public void unregisterBreakpoint(XLineBreakpointImpl breakpoint) {
        this.myBreakpoints.remove((Object)breakpoint);
    }

    @NotNull
    public Collection<XLineBreakpointImpl> getDocumentBreakpoints(Document document) {
        List breakpoints;
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && (breakpoints = this.myBreakpoints.getKeysByValue((Object)file2.getUrl())) != null) {
            return new ArrayList<XLineBreakpointImpl>(breakpoints);
        }
        return Collections.emptyList();
    }

    private Stream<XLineBreakpointImpl> breakpoints() {
        return this.myBreakpoints.keySet().stream();
    }

    private void updateBreakpoints(@NotNull Document document) {
        Collection<XLineBreakpointImpl> breakpoints = this.getDocumentBreakpoints(document);
        if (breakpoints.isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        IntOpenHashSet lines = new IntOpenHashSet();
        SmartList toRemove2 = new SmartList();
        for (XLineBreakpointImpl breakpoint : breakpoints) {
            breakpoint.updatePosition();
            if (breakpoint.isValid() && lines.add(breakpoint.getLine())) continue;
            toRemove2.add(breakpoint);
        }
        this.removeBreakpoints((List<? extends XLineBreakpoint>)toRemove2);
    }

    private void removeBreakpoints(@Nullable List<? extends XLineBreakpoint> toRemove2) {
        if (ContainerUtil.isEmpty(toRemove2)) {
            return;
        }
        XBreakpointManager manager = XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
        WriteAction.run(() -> toRemove2.forEach(arg_0 -> ((XBreakpointManager)manager).removeBreakpoint(arg_0)));
    }

    public void breakpointChanged(XLineBreakpointImpl breakpoint) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            breakpoint.updateUI();
        } else {
            this.queueBreakpointUpdate(breakpoint);
        }
    }

    public void queueBreakpointUpdate(XBreakpoint<?> slave) {
        if (slave instanceof XLineBreakpointImpl) {
            this.queueBreakpointUpdate((XLineBreakpointImpl)slave);
        }
    }

    public void queueBreakpointUpdate(final @NotNull XLineBreakpointImpl<?> breakpoint) {
        this.myBreakpointsUpdateQueue.queue(new Update(breakpoint){

            public void run() {
                breakpoint.updateUI();
            }
        });
    }

    public void queueAllBreakpointsUpdate() {
        this.myBreakpointsUpdateQueue.queue(new Update("all breakpoints"){

            public void run() {
                XLineBreakpointManager.this.breakpoints().forEach(XLineBreakpointImpl::updateUI);
            }
        });
    }

    private boolean isFromMyProject(@NotNull Editor editor) {
        if (this.myProject == editor.getProject()) {
            return true;
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            if (!(fileEditor instanceof TextEditor) || !((TextEditor)fileEditor).getEditor().equals(editor)) continue;
            return true;
        }
        return false;
    }

    private class MyEditorColorsListener
    implements EditorColorsListener {
        private MyEditorColorsListener() {
        }

        public void globalSchemeChange(EditorColorsScheme scheme) {
            XLineBreakpointManager.this.updateBreakpointsUI();
        }
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master) {
            XLineBreakpointManager.this.queueBreakpointUpdate(slave);
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            XLineBreakpointManager.this.queueBreakpointUpdate(breakpoint);
        }
    }

    private class MyEditorMouseListener
    implements EditorMouseListener {
        private MyEditorMouseListener() {
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            XLineBreakpointManager.this.myDragDetected = false;
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            Editor editor = e.getEditor();
            MouseEvent mouseEvent = e.getMouseEvent();
            if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown() || mouseEvent.isControlDown() || mouseEvent.getButton() != 1 || DiffUtil.isDiffEditor(editor) || !this.isInsideGutter(e, editor) || ConsoleViewUtil.isConsoleViewEditor(editor) || !XLineBreakpointManager.this.isFromMyProject(editor) || editor.getSelectionModel().hasSelection() && XLineBreakpointManager.this.myDragDetected) {
                return;
            }
            PsiDocumentManager.getInstance((Project)XLineBreakpointManager.this.myProject).commitAllDocuments();
            int line = EditorUtil.yToLogicalLineNoBlockInlays(editor, mouseEvent.getY());
            Document document = editor.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (line >= 0 && line < document.getLineCount() && file2 != null) {
                ActionManagerEx.getInstanceEx().fireBeforeActionPerformed("ToggleLineBreakpoint", (InputEvent)e.getMouseEvent());
                XBreakpointUtil.toggleLineBreakpoint(XLineBreakpointManager.this.myProject, XSourcePositionImpl.create(file2, line), editor, mouseEvent.isAltDown(), false, !mouseEvent.isShiftDown() && !Registry.is((String)"debugger.click.disable.breakpoints")).onSuccess(breakpoint -> {
                    if (!mouseEvent.isAltDown() && mouseEvent.isShiftDown() && breakpoint != null) {
                        breakpoint.setSuspendPolicy(SuspendPolicy.NONE);
                        String selection = editor.getSelectionModel().getSelectedText();
                        if (selection != null) {
                            breakpoint.setLogExpression(selection);
                        } else {
                            breakpoint.setLogMessage(true);
                        }
                        DebuggerUIUtil.showXBreakpointEditorBalloon(XLineBreakpointManager.this.myProject, mouseEvent.getPoint(), ((EditorEx)editor).getGutterComponentEx(), false, (XBreakpoint)breakpoint);
                    }
                });
            }
        }

        private boolean isInsideGutter(EditorMouseEvent e, Editor editor) {
            if (e.getArea() != EditorMouseEventArea.LINE_MARKERS_AREA && e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                return false;
            }
            return e.getMouseEvent().getX() <= ((EditorEx)editor).getGutterComponentEx().getWhitespaceSeparatorOffset();
        }
    }

    private class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        private MyEditorMouseMotionListener() {
        }

        public void mouseDragged(@NotNull EditorMouseEvent e) {
            XLineBreakpointManager.this.myDragDetected = true;
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            final Document document = e.getDocument();
            Collection<XLineBreakpointImpl> breakpoints = XLineBreakpointManager.this.getDocumentBreakpoints(document);
            if (!breakpoints.isEmpty()) {
                XLineBreakpointManager.this.myBreakpointsUpdateQueue.queue(new Update(document){

                    public void run() {
                        XLineBreakpointManager.this.updateBreakpoints(document);
                    }
                });
            }
        }
    }
}

