/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.popup.async.AsyncPopupStep;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.StatusText;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachHostProvider;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.intellij.xdebugger.impl.actions.LocalAttachHostPresentationGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttachToProcessActionBase
extends AnAction {
    private static final Key<Map<XAttachHost, LinkedHashSet<RecentItem>>> RECENT_ITEMS_KEY = Key.create((String)"AttachToProcessAction.RECENT_ITEMS_KEY");
    private static final Logger LOG = Logger.getInstance(AttachToProcessActionBase.class);
    @NotNull
    private final Supplier<? extends List<XAttachDebuggerProvider>> myAttachProvidersSupplier;
    @NotNull
    private final String myAttachActionsListTitle;
    @NotNull
    private final Supplier<? extends List<XAttachHostProvider>> myAttachHostProviderSupplier;

    public AttachToProcessActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon2, @NotNull Supplier<? extends List<XAttachDebuggerProvider>> attachProvidersSupplier, @NotNull Supplier<? extends List<XAttachHostProvider>> attachHostProviderSupplier, @NotNull String attachActionsListTitle) {
        super(text, description, icon2);
        this.myAttachProvidersSupplier = attachProvidersSupplier;
        this.myAttachActionsListTitle = attachActionsListTitle;
        this.myAttachHostProviderSupplier = attachHostProviderSupplier;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = AttachToProcessActionBase.getEventProject((AnActionEvent)e);
        int attachDebuggerProvidersNumber = this.myAttachProvidersSupplier.get().size();
        boolean enabled = project != null && attachDebuggerProvidersNumber > 0;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = AttachToProcessActionBase.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        new Task.Backgroundable(project, XDebuggerBundle.message((String)"xdebugger.attach.action.collectingItems", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                ImmutableList allItems = ContainerUtil.immutableList(AttachToProcessActionBase.this.getTopLevelItems(indicator, project));
                ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$1((List)allItems, project), project.getDisposed());
            }

            private /* synthetic */ void lambda$run$1(List allItems, Project project2) {
                AttachListStep step = new AttachListStep(allItems, XDebuggerBundle.message((String)"xdebugger.attach.popup.title.default", (Object[])new Object[0]), project2);
                ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
                JList mainList = ((ListPopupImpl)popup2).getList();
                ListSelectionListener listener2 = event -> {
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    Object item = ((JList)event.getSource()).getSelectedValue();
                    if (item == null) {
                        item = mainList.getSelectedValue();
                    }
                    if (item instanceof AttachToProcessItem) {
                        popup2.setCaption(((AttachToProcessItem)item).getSelectedDebugger().getDebuggerSelectedTitle());
                    }
                    if (item instanceof AttachHostItem) {
                        AttachHostItem hostItem = (AttachHostItem)item;
                        String attachHostName = hostItem.getText(project2);
                        attachHostName = StringUtil.shortenTextWithEllipsis((String)attachHostName, (int)50, (int)0);
                        popup2.setCaption(XDebuggerBundle.message((String)"xdebugger.attach.host.popup.title", (Object[])new Object[]{attachHostName}));
                    }
                };
                popup2.addListSelectionListener(listener2);
                listener2.valueChanged(new ListSelectionEvent(mainList, mainList.getMinSelectionIndex(), mainList.getMaxSelectionIndex(), false));
                popup2.showCenteredInCurrentWindow(project2);
            }
        }.queue();
    }

    @NotNull
    protected List<? extends AttachItem> getTopLevelItems(@NotNull ProgressIndicator indicator, @NotNull Project project) {
        List<AttachItem> attachHostItems = this.collectAttachHostsItems(project, indicator);
        if (!attachHostItems.isEmpty()) {
            AttachHostItem localHostGroupItem = new AttachHostItem(LocalAttachHostPresentationGroup.INSTANCE, false, LocalAttachHost.INSTANCE, project, (UserDataHolder)new UserDataHolderBase());
            attachHostItems.add(localHostGroupItem);
            AttachToProcessActionBase.doUpdateFirstInGroup(attachHostItems);
            return attachHostItems;
        }
        return this.collectAttachProcessItems(project, LocalAttachHost.INSTANCE, indicator);
    }

    private static void doUpdateFirstInGroup(@NotNull List<? extends AttachItem> items) {
        if (items.isEmpty()) {
            return;
        }
        items.get(0).makeFirstInGroup();
        for (int i2 = 1; i2 < items.size(); ++i2) {
            if (items.get(i2).getGroup() == items.get(i2 - 1).getGroup()) continue;
            items.get(i2).makeFirstInGroup();
        }
    }

    @NotNull
    public List<AttachItem> collectAttachHostsItems(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        ArrayList<AttachItem> currentItems = new ArrayList<AttachItem>();
        UserDataHolderBase dataHolder = new UserDataHolderBase();
        for (XAttachHostProvider hostProvider : this.myAttachHostProviderSupplier.get()) {
            indicator.checkCanceled();
            HashSet hosts = new HashSet(hostProvider.getAvailableHosts(project));
            for (XAttachHost host : hosts) {
                currentItems.add(new AttachHostItem(hostProvider.getPresentationGroup(), false, host, project, (UserDataHolder)dataHolder));
            }
        }
        Collections.sort(currentItems);
        AttachToProcessActionBase.doUpdateFirstInGroup(currentItems);
        return currentItems;
    }

    @NotNull
    private static List<AttachToProcessItem> getRecentItems(@NotNull List<? extends AttachToProcessItem> currentItems, @NotNull XAttachHost host, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
        ArrayList<AttachToProcessItem> result2 = new ArrayList<AttachToProcessItem>();
        List<RecentItem> recentItems = AttachToProcessActionBase.getRecentItems(host, project);
        for (int i2 = recentItems.size() - 1; i2 >= 0; --i2) {
            RecentItem recentItem = recentItems.get(i2);
            for (AttachToProcessItem attachToProcessItem : currentItems) {
                boolean isSuitableItem;
                boolean bl = isSuitableItem = recentItem.getGroup().equals(attachToProcessItem.getGroup()) && recentItem.getProcessInfo().getCommandLine().equals(attachToProcessItem.getProcessInfo().getCommandLine());
                if (!isSuitableItem) continue;
                List<XAttachDebugger> debuggers = attachToProcessItem.getDebuggers();
                int selectedDebugger = -1;
                for (int j = 0; j < debuggers.size(); ++j) {
                    XAttachDebugger debugger = debuggers.get(j);
                    if (!debugger.getDebuggerDisplayName().equals(recentItem.getDebuggerName())) continue;
                    selectedDebugger = j;
                    break;
                }
                if (selectedDebugger == -1) continue;
                result2.add(AttachToProcessItem.createRecentAttachItem(attachToProcessItem, result2.isEmpty(), debuggers, selectedDebugger, project, dataHolder));
            }
        }
        return result2;
    }

    @NotNull
    private static List<ProcessInfo> getProcessInfos(@NotNull XAttachHost host) {
        try {
            return host.getProcessList();
        }
        catch (ExecutionException e) {
            Notifications.Bus.notify((Notification)new Notification("Attach to Process action", XDebuggerBundle.message((String)"xdebugger.attach.action.items.error.title", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.attach.action.items.error.message", (Object[])new Object[0]), NotificationType.WARNING));
            LOG.warn("Error while getting attach items", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private List<XAttachDebuggerProvider> getProvidersApplicableForHost(@NotNull XAttachHost host) {
        return ContainerUtil.filter((Collection)this.myAttachProvidersSupplier.get(), provider -> provider.isAttachHostApplicable(host));
    }

    @NotNull
    public List<AttachToProcessItem> collectAttachProcessItems(@NotNull Project project, @NotNull XAttachHost host, @NotNull ProgressIndicator indicator) {
        return AttachToProcessActionBase.doCollectAttachProcessItems(project, host, AttachToProcessActionBase.getProcessInfos(host), indicator, this.getProvidersApplicableForHost(host));
    }

    @NotNull
    static List<AttachToProcessItem> doCollectAttachProcessItems(@NotNull Project project, @NotNull XAttachHost host, @NotNull List<? extends ProcessInfo> processInfos, @NotNull ProgressIndicator indicator, @NotNull List<? extends XAttachDebuggerProvider> providers) {
        UserDataHolderBase dataHolder = new UserDataHolderBase();
        ArrayList<AttachToProcessItem> currentItems = new ArrayList<AttachToProcessItem>();
        for (ProcessInfo processInfo : processInfos) {
            MultiMap groupsWithDebuggers = new MultiMap();
            for (XAttachDebuggerProvider xAttachDebuggerProvider : providers) {
                indicator.checkCanceled();
                groupsWithDebuggers.putValues(xAttachDebuggerProvider.getPresentationGroup(), xAttachDebuggerProvider.getAvailableDebuggers(project, host, processInfo, (UserDataHolder)dataHolder));
            }
            for (XAttachPresentationGroup xAttachPresentationGroup : groupsWithDebuggers.keySet()) {
                Collection debuggers = groupsWithDebuggers.get((Object)xAttachPresentationGroup);
                if (debuggers.isEmpty()) continue;
                currentItems.add(new AttachToProcessItem(xAttachPresentationGroup, false, host, processInfo, new ArrayList<XAttachDebugger>(debuggers), project, (UserDataHolder)dataHolder));
            }
        }
        Collections.sort(currentItems);
        AttachToProcessActionBase.doUpdateFirstInGroup(currentItems);
        List<AttachToProcessItem> result2 = AttachToProcessActionBase.getRecentItems(currentItems, host, project, (UserDataHolder)dataHolder);
        result2.addAll(currentItems);
        return result2;
    }

    public static void addToRecent(@NotNull Project project, @NotNull AttachToProcessItem item) {
        XAttachHost host;
        LinkedHashSet hostRecentItems;
        HashMap recentItems = (HashMap)project.getUserData(RECENT_ITEMS_KEY);
        if (recentItems == null) {
            recentItems = new HashMap();
            project.putUserData(RECENT_ITEMS_KEY, recentItems);
        }
        if ((hostRecentItems = (LinkedHashSet)recentItems.get(host = item.getHost())) == null) {
            recentItems.put(host, new LinkedHashSet());
            hostRecentItems = (LinkedHashSet)recentItems.get(host);
        }
        RecentItem newRecentItem = new RecentItem(host, item);
        hostRecentItems.remove(newRecentItem);
        hostRecentItems.add(newRecentItem);
        while (hostRecentItems.size() > 4) {
            hostRecentItems.remove(hostRecentItems.iterator().next());
        }
    }

    @NotNull
    public static List<RecentItem> getRecentItems(@NotNull XAttachHost host, @NotNull Project project) {
        Map recentItems = (Map)project.getUserData(RECENT_ITEMS_KEY);
        return recentItems == null || !recentItems.containsKey(host) ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList((Collection)recentItems.get(host)));
    }

    public class AttachListStep
    extends MyBasePopupStep<AttachItem>
    implements ListPopupStepEx<AttachItem> {
        public AttachListStep(@Nullable List<AttachItem> items, @NotNull String title, Project project) {
            super(project, title, items);
        }

        @Nullable
        public ListSeparator getSeparatorAbove(AttachItem value2) {
            String separatorTitle = value2.getSeparatorTitle();
            return separatorTitle == null ? null : new ListSeparator(separatorTitle);
        }

        public Icon getIconFor(AttachItem value2) {
            return value2.getIcon(this.myProject);
        }

        @NotNull
        public String getTextFor(AttachItem value2) {
            return value2.getText(this.myProject);
        }

        @Override
        public boolean hasSubstep(AttachItem selectedValue) {
            return selectedValue.hasSubStep();
        }

        @Nullable
        public String getTooltipTextFor(AttachItem value2) {
            return value2.getTooltipText(this.myProject);
        }

        public void setEmptyText(@NotNull StatusText emptyText) {
            emptyText.setText(XDebuggerBundle.message((String)"xdebugger.attach.popup.emptyText", (Object[])new Object[0]));
        }

        @Override
        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice) {
            if (selectedValue instanceof AttachToProcessItem) {
                AttachToProcessItem attachToProcessItem = (AttachToProcessItem)selectedValue;
                if (finalChoice) {
                    AttachToProcessActionBase.addToRecent(this.myProject, attachToProcessItem);
                    return this.doFinalStep(() -> attachToProcessItem.startDebugSession(this.myProject));
                }
                return new ActionListStep(attachToProcessItem.getSubItems(), attachToProcessItem.mySelectedDebugger);
            }
            if (selectedValue instanceof AttachHostItem) {
                final AttachHostItem attachHostItem = (AttachHostItem)selectedValue;
                return new AsyncPopupStep(){

                    @Override
                    public PopupStep call() {
                        ArrayList<AttachItem> attachItems = new ArrayList<AttachItem>(attachHostItem.getSubItems());
                        return new AttachListStep(attachItems, null, AttachListStep.this.myProject);
                    }
                };
            }
            return null;
        }

        public PopupStep onChosen(AttachItem selectedValue, boolean finalChoice, int eventModifiers) {
            return this.onChosen(selectedValue, finalChoice);
        }

        private class ActionListStep
        extends MyBasePopupStep<AttachToProcessItem> {
            ActionListStep(List<AttachToProcessItem> items, int selectedItem) {
                super(AttachListStep.this.myProject, AttachToProcessActionBase.this.myAttachActionsListTitle, items);
                this.setDefaultOptionIndex(selectedItem);
            }

            @NotNull
            public String getTextFor(AttachToProcessItem value2) {
                return value2.getSelectedDebugger().getDebuggerDisplayName();
            }

            @Override
            public PopupStep onChosen(AttachToProcessItem selectedValue, boolean finalChoice) {
                AttachToProcessActionBase.addToRecent(this.myProject, selectedValue);
                return this.doFinalStep(() -> selectedValue.startDebugSession(this.myProject));
            }
        }
    }

    private static class MyBasePopupStep<T extends AttachItem>
    extends BaseListPopupStep<T> {
        @NotNull
        final Project myProject;

        MyBasePopupStep(@NotNull Project project, @Nullable String title, List<T> values2) {
            super(title, values2);
            this.myProject = project;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public boolean hasSubstep(AttachItem selectedValue) {
            return !selectedValue.getSubItems().isEmpty();
        }

        public PopupStep onChosen(T selectedValue, boolean finalChoice) {
            return null;
        }
    }

    public static class AttachToProcessItem
    extends AttachItem<ProcessInfo> {
        @NotNull
        private final List<XAttachDebugger> myDebuggers;
        private final int mySelectedDebugger;
        @NotNull
        private final List<AttachToProcessItem> mySubItems;
        @NotNull
        private final XAttachHost myHost;

        public AttachToProcessItem(@NotNull XAttachPresentationGroup<ProcessInfo> group, boolean isFirstInGroup, @NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull List<XAttachDebugger> debuggers, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
            this(group, isFirstInGroup, group.getGroupName(), host, info, debuggers, 0, project, dataHolder);
        }

        public AttachToProcessItem(@NotNull XAttachPresentationGroup<ProcessInfo> group, boolean isFirstInGroup, @NotNull String groupName, @NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull List<XAttachDebugger> debuggers, int selectedDebugger, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
            super(group, isFirstInGroup, groupName, info, project, dataHolder);
            assert (!debuggers.isEmpty()) : "debugger list should not be empty";
            assert (selectedDebugger >= 0 && selectedDebugger < debuggers.size()) : "wrong selected debugger index";
            this.myDebuggers = debuggers;
            this.mySelectedDebugger = selectedDebugger;
            this.myHost = host;
            this.mySubItems = debuggers.size() > 1 ? ContainerUtil.map(debuggers, debugger -> new AttachToProcessItem(this.myGroup, false, this.myHost, (ProcessInfo)this.myInfo, Collections.singletonList(debugger), this.myProject, dataHolder)) : Collections.emptyList();
        }

        static AttachToProcessItem createRecentAttachItem(AttachToProcessItem item, boolean isFirstInGroup, List<XAttachDebugger> debuggers, int selectedDebugger, Project project, UserDataHolder dataHolder) {
            return new AttachToProcessItem(item.getGroup(), isFirstInGroup, XDebuggerBundle.message((String)"xdebugger.attach.toLocal.popup.recent", (Object[])new Object[0]), item.getHost(), item.getProcessInfo(), debuggers, selectedDebugger, project, dataHolder);
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            return (ProcessInfo)this.myInfo;
        }

        @NotNull
        public XAttachHost getHost() {
            return this.myHost;
        }

        @Override
        public boolean hasSubStep() {
            return !this.mySubItems.isEmpty();
        }

        @Override
        @Nullable
        public String getTooltipText(@NotNull Project project) {
            return this.myGroup.getItemDescription(project, this.myInfo, this.myDataHolder);
        }

        @Override
        @NotNull
        public String getText(@NotNull Project project) {
            String shortenedText = StringUtil.shortenTextWithEllipsis((String)this.myGroup.getItemDisplayText(project, this.myInfo, this.myDataHolder), (int)200, (int)0);
            int pid = ((ProcessInfo)this.myInfo).getPid();
            return (pid == -1 ? "" : pid + " ") + shortenedText;
        }

        @NotNull
        public List<XAttachDebugger> getDebuggers() {
            return this.myDebuggers;
        }

        @Override
        @NotNull
        public List<AttachToProcessItem> getSubItems() {
            return this.mySubItems;
        }

        @NotNull
        public XAttachDebugger getSelectedDebugger() {
            return this.myDebuggers.get(this.mySelectedDebugger);
        }

        public void startDebugSession(@NotNull Project project) {
            XAttachDebugger debugger = this.getSelectedDebugger();
            try {
                debugger.attachDebugSession(project, this.myHost, (ProcessInfo)this.myInfo);
            }
            catch (ExecutionException e) {
                String message = XDebuggerBundle.message((String)"xdebugger.attach.pid", (Object[])new Object[]{((ProcessInfo)this.myInfo).getPid()});
                ExecutionUtil.handleExecutionError((Project)project, (String)"Debug", (String)message, (Throwable)e);
            }
        }
    }

    private class AttachHostItem
    extends AttachItem<XAttachHost> {
        AttachHostItem(XAttachPresentationGroup<XAttachHost> group, @NotNull boolean isFirstInGroup, @NotNull XAttachHost host, @NotNull Project project, UserDataHolder dataHolder) {
            super(group, isFirstInGroup, group.getGroupName(), host, project, dataHolder);
        }

        @Override
        public boolean hasSubStep() {
            return true;
        }

        @Override
        @NotNull
        public String getText(@NotNull Project project) {
            return this.myGroup.getItemDisplayText(project, this.myInfo, this.myDataHolder);
        }

        @Override
        @Nullable
        public String getTooltipText(@NotNull Project project) {
            return this.myGroup.getItemDescription(project, this.myInfo, this.myDataHolder);
        }

        @Override
        public List<AttachToProcessItem> getSubItems() {
            return AttachToProcessActionBase.this.collectAttachProcessItems(this.myProject, (XAttachHost)this.myInfo, (ProgressIndicator)new EmptyProgressIndicator());
        }
    }

    public static abstract class AttachItem<T>
    implements Comparable<AttachItem<T>> {
        @NotNull
        XAttachPresentationGroup<T> myGroup;
        boolean myIsFirstInGroup;
        @NotNull
        String myGroupName;
        @NotNull
        Project myProject;
        @NotNull
        UserDataHolder myDataHolder;
        @NotNull
        T myInfo;

        public AttachItem(@NotNull XAttachPresentationGroup<T> group, boolean isFirstInGroup, @NotNull String groupName, @NotNull T info, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
            this.myGroup = group;
            this.myIsFirstInGroup = isFirstInGroup;
            this.myInfo = info;
            this.myProject = project;
            this.myDataHolder = dataHolder;
            this.myGroupName = groupName;
        }

        void makeFirstInGroup() {
            this.myIsFirstInGroup = true;
        }

        @NotNull
        XAttachPresentationGroup<T> getGroup() {
            return this.myGroup;
        }

        @Nullable
        String getSeparatorTitle() {
            return this.myIsFirstInGroup ? this.myGroupName : null;
        }

        @Nullable
        protected Icon getIcon(@NotNull Project project) {
            return this.myGroup.getItemIcon(project, this.myInfo, this.myDataHolder);
        }

        protected abstract boolean hasSubStep();

        protected abstract String getText(@NotNull Project var1);

        @Nullable
        protected abstract String getTooltipText(@NotNull Project var1);

        protected abstract List<AttachToProcessItem> getSubItems();

        @Override
        public int compareTo(AttachItem<T> compareItem) {
            int groupDifference = this.myGroup.getOrder() - compareItem.getGroup().getOrder();
            if (groupDifference != 0) {
                return groupDifference;
            }
            return this.myGroup.compare(this.myInfo, compareItem.myInfo);
        }
    }

    public static class RecentItem {
        @NotNull
        private final XAttachHost myHost;
        @NotNull
        private final ProcessInfo myProcessInfo;
        @NotNull
        private final XAttachPresentationGroup myGroup;
        @NotNull
        private final String myDebuggerName;

        public RecentItem(@NotNull XAttachHost host, @NotNull AttachToProcessItem item) {
            this(host, item.getProcessInfo(), item.getGroup(), item.getSelectedDebugger().getDebuggerDisplayName());
        }

        private RecentItem(@NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull XAttachPresentationGroup group, @NotNull String debuggerName) {
            this.myHost = host;
            this.myProcessInfo = info;
            this.myGroup = group;
            this.myDebuggerName = debuggerName;
        }

        public static RecentItem createRecentItem(@NotNull XAttachHost host, @NotNull ProcessInfo info, @NotNull XAttachPresentationGroup group, @NotNull String debuggerName) {
            return new RecentItem(host, info, group, debuggerName);
        }

        @NotNull
        public XAttachHost getHost() {
            return this.myHost;
        }

        @NotNull
        public ProcessInfo getProcessInfo() {
            return this.myProcessInfo;
        }

        @NotNull
        public XAttachPresentationGroup getGroup() {
            return this.myGroup;
        }

        @NotNull
        public String getDebuggerName() {
            return this.myDebuggerName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecentItem item = (RecentItem)o;
            return Objects.equals(this.myProcessInfo.getCommandLine(), item.myProcessInfo.getCommandLine());
        }

        public int hashCode() {
            return Objects.hash(this.myProcessInfo.getCommandLine());
        }
    }
}

