/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.AppTopics;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.ide.plugins.CannotUnloadPluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerState;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements PersistentStateComponent<XDebuggerState> {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Debugger messages", (String)"Debug", (boolean)false);
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDebuggerWatchesManager myWatchesManager;
    private final XDebuggerPinToTopManager myPinToTopManager;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions = Collections.synchronizedMap(new LinkedHashMap());
    private final AtomicReference<XDebugSessionImpl> myActiveSession = new AtomicReference();
    private XDebuggerState myState = new XDebuggerState();
    private static final TooltipGroup RUN_TO_CURSOR_TOOLTIP_GROUP = new TooltipGroup("RUN_TO_CURSOR_TOOLTIP_GROUP", 0);

    public XDebuggerManagerImpl(@NotNull Project project) {
        this.myProject = project;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        this.myBreakpointManager = new XBreakpointManagerImpl(project, this);
        this.myWatchesManager = new XDebuggerWatchesManager();
        this.myPinToTopManager = new XDebuggerPinToTopManager();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project);
        messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }
        });
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, false);
            }
        });
        messageBusConnection.subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2;
                if (!(breakpoint instanceof XLineBreakpoint) && (session2 = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint.equals(session2.getActiveNonLineBreakpoint())) {
                    XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
                    breakpointBase.clearIcon();
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(breakpointBase.createGutterIconRenderer());
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session2 = XDebuggerManagerImpl.this.getCurrentSession();
                if (session2 != null && breakpoint == session2.getActiveNonLineBreakpoint()) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(null);
                }
            }
        });
        messageBusConnection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (descriptor2 != null && "Debug".equals(executor.getToolWindowId())) {
                    XDebugSessionImpl session2 = (XDebugSessionImpl)XDebuggerManagerImpl.this.mySessions.get(descriptor2.getProcessHandler());
                    if (session2 != null) {
                        session2.activateSession();
                    } else {
                        XDebuggerManagerImpl.this.setCurrentSession(null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (descriptor2 != null && "Debug".equals(executor.getToolWindowId())) {
                    XDebuggerManagerImpl.this.mySessions.remove(descriptor2.getProcessHandler());
                }
            }
        });
        messageBusConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void checkUnloadPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                XDebugSession[] sessions;
                for (XDebugSession session2 : sessions = XDebuggerManagerImpl.this.getDebugSessions()) {
                    XDebugProcess process2 = session2.getDebugProcess();
                    if (!process2.dependsOnPlugin(pluginDescriptor)) continue;
                    throw new CannotUnloadPluginException("Plugin is not unload-safe because of the started debug session");
                }
            }
        });
        DebuggerEditorListener listener2 = new DebuggerEditorListener();
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)listener2, (Disposable)this.myProject);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)listener2, (Disposable)this.myProject);
    }

    public void initializeComponent() {
        this.myBreakpointManager.init();
    }

    private void updateExecutionPoint(@NotNull VirtualFile file2, boolean navigate2) {
        if (file2.equals(this.myExecutionPointHighlighter.getCurrentFile())) {
            this.myExecutionPointHighlighter.update(navigate2);
        }
    }

    void updateExecutionPoint(GutterIconRenderer renderer) {
        this.myExecutionPointHighlighter.updateGutterIcon(renderer);
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public XDebuggerWatchesManager getWatchesManager() {
        return this.myWatchesManager;
    }

    @NotNull
    public XDebuggerPinToTopManager getPinToTopManager() {
        return this.myPinToTopManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public XDebugSession startSession(@NotNull ExecutionEnvironment environment, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        return this.startSession(environment.getContentToReuse(), processStarter, new XDebugSessionImpl(environment, this));
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        return this.startSessionAndShowTab(sessionName, contentToReuse, false, starter2);
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        return this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter2);
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon2, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter2) throws ExecutionException {
        XDebugSessionImpl session2 = this.startSession(contentToReuse, starter2, new XDebugSessionImpl(null, this, sessionName, icon2, showToolWindowOnSuspendOnly, contentToReuse));
        if (!showToolWindowOnSuspendOnly) {
            session2.showSessionTab();
        }
        ProcessHandler handler2 = session2.getDebugProcess().getProcessHandler();
        handler2.startNotify();
        return session2;
    }

    private XDebugSessionImpl startSession(@Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter, @NotNull XDebugSessionImpl session2) throws ExecutionException {
        XDebugProcess process2 = processStarter.start((XDebugSession)session2);
        ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).processStarted(process2);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            session2.activateSession();
            ((XDebugProcessConfiguratorStarter)processStarter).configure(session2.getSessionData());
        }
        session2.init(process2, contentToReuse);
        this.mySessions.put(session2.getDebugProcess().getProcessHandler(), session2);
        return session2;
    }

    void removeSession(@NotNull XDebugSessionImpl session2) {
        XDebugSessionTab sessionTab = session2.getSessionTab();
        this.mySessions.remove(session2.getDebugProcess().getProcessHandler());
        if (sessionTab != null && !this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode() && XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) {
            RunContentManager.getInstance((Project)this.myProject).hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), sessionTab.getRunContentDescriptor());
        }
        if (this.myActiveSession.compareAndSet(session2, null)) {
            this.onActiveSessionChanged(session2, null);
        }
    }

    void updateExecutionPoint(@Nullable XSourcePosition position, boolean nonTopFrame, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, nonTopFrame, gutterIconRenderer);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
    }

    private void onActiveSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
        ApplicationManager.getApplication().invokeLater(() -> {
            ValueLookupManager.getInstance(this.myProject).hideHint();
            DebuggerUIUtil.repaintCurrentEditor(this.myProject);
        }, this.myProject.getDisposed());
        if (!this.myProject.isDisposed()) {
            ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).currentSessionChanged(previousSession, currentSession);
        }
    }

    public XDebugSession @NotNull [] getDebugSessions() {
        return this.mySessions.values().toArray(new XDebugSessionImpl[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        Map<ProcessHandler, XDebugSessionImpl> map2 = this.mySessions;
        synchronized (map2) {
            for (XDebugSessionImpl debuggerSession : this.mySessions.values()) {
                RunContentDescriptor contentDescriptor;
                XDebugSessionTab sessionTab = debuggerSession.getSessionTab();
                if (sessionTab == null || (contentDescriptor = sessionTab.getRunContentDescriptor()) == null || executionConsole != contentDescriptor.getExecutionConsole()) continue;
                return debuggerSession;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        Map<ProcessHandler, XDebugSessionImpl> map2 = this.mySessions;
        synchronized (map2) {
            return StreamEx.of(this.mySessions.values()).map(XDebugSessionImpl::getDebugProcess).select(processClass).toList();
        }
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return this.myActiveSession.get();
    }

    void setCurrentSession(@Nullable XDebugSessionImpl session2) {
        boolean sessionChanged;
        XDebugSessionImpl previousSession = this.myActiveSession.getAndSet(session2);
        boolean bl = sessionChanged = previousSession != session2;
        if (sessionChanged) {
            if (session2 != null) {
                XDebugSessionTab tab = session2.getSessionTab();
                if (tab != null) {
                    tab.select();
                }
            } else {
                this.myExecutionPointHighlighter.hide();
            }
            this.onActiveSessionChanged(previousSession, session2);
        }
    }

    public XDebuggerState getState() {
        XDebuggerState state = this.myState;
        this.myBreakpointManager.saveState(state.getBreakpointManagerState());
        this.myWatchesManager.saveState(state.getWatchesManagerState());
        this.myPinToTopManager.saveState(state.getPinToTopManagerState());
        return state;
    }

    public boolean isFullLineHighlighter() {
        return this.myExecutionPointHighlighter.isFullLineHighlighter();
    }

    public void loadState(@NotNull XDebuggerState state) {
        this.myState = state;
        this.myBreakpointManager.loadState(state.getBreakpointManagerState());
        this.myWatchesManager.loadState(state.getWatchesManagerState());
        this.myPinToTopManager.loadState(state.getPinToTopManagerState());
    }

    public void noStateLoaded() {
        this.myBreakpointManager.noStateLoaded();
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    private class DebuggerEditorListener
    implements EditorMouseMotionListener,
    EditorMouseListener {
        RangeHighlighter myCurrentHighlighter;

        private DebuggerEditorListener() {
        }

        boolean isEnabled(@NotNull EditorMouseEvent e) {
            Editor editor = e.getEditor();
            if (e.getArea() != EditorMouseEventArea.LINE_NUMBERS_AREA || editor.getProject() != XDebuggerManagerImpl.this.myProject || !EditorUtil.isRealFileEditor(editor) || !XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isRunToCursorGestureEnabled()) {
                return false;
            }
            XDebugSessionImpl session2 = XDebuggerManagerImpl.this.getCurrentSession();
            return session2 != null && session2.isPaused() && !session2.isReadOnly();
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (!this.isEnabled(e)) {
                this.removeHighlighter(e);
                return;
            }
            this.removeHighlighter(e);
            int lineNumber = this.getLineNumber(e);
            if (lineNumber < 0) {
                return;
            }
            Editor editor = e.getEditor();
            this.myCurrentHighlighter = editor.getMarkupModel().addLineHighlighter(DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES, lineNumber, 5999);
            HintHint hint = new HintHint(e.getMouseEvent()).setAwtTooltip(true).setPreferredPosition(Balloon.Position.above);
            String text = UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor"));
            TooltipController.getInstance().showTooltipByMouseMove(editor, new RelativePoint(e.getMouseEvent()), new LineTooltipRenderer(text, new Object[]{text}), false, RUN_TO_CURSOR_TOOLTIP_GROUP, hint);
            IdeGlassPaneUtil.find((Component)e.getMouseEvent().getComponent()).setCursor(Cursor.getPredefinedCursor(12), (Object)this);
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            this.removeHighlighter(e);
        }

        private void removeHighlighter(@NotNull EditorMouseEvent e) {
            if (this.myCurrentHighlighter != null) {
                this.myCurrentHighlighter.dispose();
                TooltipController.getInstance().cancelTooltip(RUN_TO_CURSOR_TOOLTIP_GROUP, e.getMouseEvent(), true);
                IdeGlassPaneUtil.find((Component)e.getMouseEvent().getComponent()).setCursor(null, (Object)this);
                this.myCurrentHighlighter = null;
            }
        }

        private int getLineNumber(EditorMouseEvent event) {
            Editor editor = event.getEditor();
            if (event.getVisualPosition().line >= ((EditorImpl)editor).getVisibleLineCount()) {
                return -1;
            }
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, event.getOffset());
            return editor.getDocument().getLineNumber(lineStartOffset);
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            if (e.getMouseEvent().getButton() == 1 && this.isEnabled(e)) {
                int lineNumber = this.getLineNumber(e);
                XDebugSessionImpl session2 = XDebuggerManagerImpl.this.getCurrentSession();
                if (session2 != null && lineNumber >= 0) {
                    session2.runToPosition(XSourcePositionImpl.create(((EditorEx)e.getEditor()).getVirtualFile(), lineNumber), false);
                    e.consume();
                }
            }
        }
    }
}

