/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityId;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.containers.ContainerExtensionsKt;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.workspaceModel.storage.impl.indices.VirtualFileIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 !2\u00020\u0001:\u0001!BG\b\u0016\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t\u00a2\u0006\u0002\u0010\fB]\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t\u0012\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000e\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000eX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R$\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "", "softLinks", "Lcom/intellij/util/containers/BidirectionalMultiMap;", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "virtualFileIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "persistentIdIndex", "(Lcom/intellij/util/containers/BidirectionalMultiMap;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;)V", "externalMappings", "", "", "Lcom/intellij/workspaceModel/storage/impl/external/ExternalEntityMappingImpl;", "(Lcom/intellij/util/containers/BidirectionalMultiMap;Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/EntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspaceModel_storage", "()Ljava/util/Map;", "getPersistentIdIndex$intellij_platform_workspaceModel_storage", "getSoftLinks$intellij_platform_workspaceModel_storage", "()Lcom/intellij/util/containers/BidirectionalMultiMap;", "getVirtualFileIndex$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/indices/VirtualFileIndex;", "assertConsistency", "", "storage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "toMutable", "Lcom/intellij/workspaceModel/storage/impl/MutableStorageIndexes;", "Companion", "intellij.platform.workspaceModel.storage"})
public class StorageIndexes {
    @NotNull
    private final BidirectionalMultiMap<PersistentEntityId<?>, EntityId> softLinks;
    @NotNull
    private final VirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final EntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex;
    @NotNull
    private final Map<String, ExternalEntityMappingImpl<?>> externalMappings;
    @NotNull
    private static final StorageIndexes EMPTY;
    public static final Companion Companion;

    @NotNull
    public final MutableStorageIndexes toMutable() {
        BidirectionalMultiMap<PersistentEntityId<?>, EntityId> copiedSoftLinks = ContainerExtensionsKt.copy(this.getSoftLinks$intellij_platform_workspaceModel_storage());
        VirtualFileIndex.MutableVirtualFileIndex copiedVirtualFileIndex = VirtualFileIndex.MutableVirtualFileIndex.Companion.from(this.getVirtualFileIndex$intellij_platform_workspaceModel_storage());
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> copiedEntitySourceIndex = EntityStorageInternalIndex.MutableEntityStorageInternalIndex.Companion.from(this.getEntitySourceIndex$intellij_platform_workspaceModel_storage());
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex<PersistentEntityId<?>> copiedPersistentIdIndex = EntityStorageInternalIndex.MutableEntityStorageInternalIndex.Companion.from(this.getPersistentIdIndex$intellij_platform_workspaceModel_storage());
        Map<String, MutableExternalEntityMappingImpl<?>> copiedExternalMappings = MutableExternalEntityMappingImpl.Companion.fromMap(this.getExternalMappings$intellij_platform_workspaceModel_storage());
        return new MutableStorageIndexes(copiedSoftLinks, copiedVirtualFileIndex, copiedEntitySourceIndex, copiedPersistentIdIndex, copiedExternalMappings);
    }

    public final void assertConsistency(@NotNull AbstractEntityStorage storage) {
        BidirectionalMap<EntityId, EntitySource> entitySourceIndexCopy = ContainerExtensionsKt.copy(this.getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage());
        Iterable $this$forEach$iv22 = CollectionsKt.filterNotNull((Iterable)storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv22) {
            EntityFamily family = (EntityFamily)element$iv;
            boolean bl = false;
            Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)family.getEntities$intellij_platform_workspaceModel_storage()));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                WorkspaceEntityData data2 = (WorkspaceEntityData)element$iv2;
                boolean bl2 = false;
                boolean removed = entitySourceIndexCopy.remove((Object)data2.createPid$intellij_platform_workspaceModel_storage(), (Object)data2.getEntitySource());
                boolean bl3 = false;
                if (!_Assertions.ENABLED || removed) continue;
                boolean $i$a$-assert-StorageIndexes$assertConsistency$1$1$22 = false;
                String $i$a$-assert-StorageIndexes$assertConsistency$1$1$22 = "Entity " + data2 + " isn't found in entity source index. Entity source: " + data2.getEntitySource() + ", Id: " + data2.createPid$intellij_platform_workspaceModel_storage();
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-StorageIndexes$assertConsistency$1$1$22));
            }
        }
        boolean $this$forEach$iv22 = entitySourceIndexCopy.isEmpty();
        $i$f$forEach = false;
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            boolean $i$a$-assert-StorageIndexes$assertConsistency$32 = false;
            String $i$a$-assert-StorageIndexes$assertConsistency$32 = "Entity source index has garbage: " + entitySourceIndexCopy;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-StorageIndexes$assertConsistency$32));
        }
        BidirectionalMap<EntityId, PersistentEntityId<?>> persistentIdIndexCopy = ContainerExtensionsKt.copy(this.getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage());
        Iterable $this$forEach$iv32 = CollectionsKt.filterNotNull((Iterable)storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage());
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv32) {
            EntityFamily family = (EntityFamily)element$iv;
            boolean bl = false;
            Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)family.getEntities$intellij_platform_workspaceModel_storage()));
            boolean $i$f$forEach4 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                WorkspaceEntityData data3 = (WorkspaceEntityData)element$iv3;
                boolean bl4 = false;
                PersistentEntityId<?> persistentId = EntitiesKt.persistentId(data3, storage);
                if (persistentId == null) continue;
                boolean removed = persistentIdIndexCopy.remove((Object)data3.createPid$intellij_platform_workspaceModel_storage(), persistentId);
                boolean bl5 = false;
                if (!_Assertions.ENABLED || removed) continue;
                boolean $i$a$-assert-StorageIndexes$assertConsistency$3$1$22 = false;
                String $i$a$-assert-StorageIndexes$assertConsistency$3$1$22 = "Entity " + data3 + " isn't found in persistent id index";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-StorageIndexes$assertConsistency$3$1$22));
            }
        }
        boolean $this$forEach$iv32 = persistentIdIndexCopy.isEmpty();
        $i$f$forEach3 = false;
        if (_Assertions.ENABLED && !$this$forEach$iv32) {
            boolean $i$a$-assert-StorageIndexes$assertConsistency$52 = false;
            String $i$a$-assert-StorageIndexes$assertConsistency$52 = "Persistent id index has garbage: " + persistentIdIndexCopy;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-StorageIndexes$assertConsistency$52));
        }
        BidirectionalMultiMap<PersistentEntityId<?>, EntityId> softLinksCopy = ContainerExtensionsKt.copy(this.getSoftLinks$intellij_platform_workspaceModel_storage());
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)storage.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage());
        boolean $i$f$forEach5 = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityFamily family = (EntityFamily)element$iv;
            boolean bl = false;
            Sequence $this$forEach$iv4 = SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)family.getEntities$intellij_platform_workspaceModel_storage()));
            boolean $i$f$forEach6 = false;
            for (Object element$iv4 : $this$forEach$iv4) {
                WorkspaceEntityData data4 = (WorkspaceEntityData)element$iv4;
                boolean bl6 = false;
                if (!(data4 instanceof SoftLinkable)) continue;
                Set<PersistentEntityId<?>> links = ((SoftLinkable)((Object)data4)).getLinks();
                for (PersistentEntityId<?> link : links) {
                    Set pids = softLinksCopy.getValues(link);
                    boolean bl7 = pids.contains(data4.createPid$intellij_platform_workspaceModel_storage());
                    boolean bl8 = false;
                    if (_Assertions.ENABLED && !bl7) {
                        boolean bl9 = false;
                        String string = "Entity " + data4 + " isn't found in soft links";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    softLinksCopy.remove(link, (Object)data4.createPid$intellij_platform_workspaceModel_storage());
                }
            }
        }
        boolean bl = softLinksCopy.isEmpty();
        boolean bl10 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl11 = false;
            String string = "Soft links have garbage: " + softLinksCopy;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public BidirectionalMultiMap<PersistentEntityId<?>, EntityId> getSoftLinks$intellij_platform_workspaceModel_storage() {
        return this.softLinks;
    }

    @NotNull
    public VirtualFileIndex getVirtualFileIndex$intellij_platform_workspaceModel_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspaceModel_storage() {
        return this.entitySourceIndex;
    }

    @NotNull
    public EntityStorageInternalIndex<PersistentEntityId<?>> getPersistentIdIndex$intellij_platform_workspaceModel_storage() {
        return this.persistentIdIndex;
    }

    @NotNull
    public Map<String, ExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspaceModel_storage() {
        return this.externalMappings;
    }

    public StorageIndexes(@NotNull BidirectionalMultiMap<PersistentEntityId<?>, EntityId> softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull EntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex, @NotNull Map<String, ? extends ExternalEntityMappingImpl<?>> externalMappings) {
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.persistentIdIndex = persistentIdIndex;
        this.externalMappings = externalMappings;
    }

    public StorageIndexes(@NotNull BidirectionalMultiMap<PersistentEntityId<?>, EntityId> softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull EntityStorageInternalIndex<PersistentEntityId<?>> persistentIdIndex) {
        this(softLinks, virtualFileIndex, entitySourceIndex, persistentIdIndex, MapsKt.emptyMap());
    }

    static {
        Companion = new Companion(null);
        EMPTY = new StorageIndexes(new BidirectionalMultiMap(), new VirtualFileIndex(), new EntityStorageInternalIndex<EntitySource>(), new EntityStorageInternalIndex(), new HashMap());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/workspaceModel/storage/impl/StorageIndexes$Companion;", "", "()V", "EMPTY", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "getEMPTY", "()Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final StorageIndexes getEMPTY() {
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

