/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.util.Disposer;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.UtilsKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryModifiableModelBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryStateSnapshot;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectModifiableLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.ProjectLibraryTableBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChanged;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0#H\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\b\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001fH\u0016J\u0018\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u001b\u00105\u001a\u00020\u00192\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001207H\u0001\u00a2\u0006\u0002\b8R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0013\u001a#\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00120\u00120\u0014\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ProjectLibraryTableBridge;", "Lcom/intellij/openapi/Disposable;", "parentProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "kotlin.jvm.PlatformType", "entityStorage", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "librariesMap", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridgeImpl;", "libraryNameMap", "Lcom/intellij/util/containers/MultiMap;", "", "newLibraryInstances", "", "addLibraryToMaps", "", "library", "addListener", "listener", "parentDisposable", "createLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "name", "dispose", "getLibraries", "", "()[Lcom/intellij/openapi/roots/libraries/Library;", "getLibraryByName", "getLibraryIterator", "", "getModifiableModel", "Lcom/intellij/openapi/roots/libraries/LibraryTable$ModifiableModel;", "diff", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "getPresentation", "Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "getProject", "getTableLevel", "removeLibrary", "removeLibraryFromMaps", "id", "libraryImpl", "removeListener", "setNewLibraryInstances", "addedInstances", "", "setNewLibraryInstances$intellij_platform_workspaceModel_ide", "Companion", "intellij.platform.workspaceModel.ide"})
public final class ProjectLibraryTableBridgeImpl
implements ProjectLibraryTableBridge,
Disposable {
    private final Logger LOG;
    private final ConcurrentMap<LibraryId, LibraryBridgeImpl> librariesMap;
    private final MultiMap<String, LibraryBridgeImpl> libraryNameMap;
    private final Map<LibraryId, LibraryBridgeImpl> newLibraryInstances;
    private final VersionedEntityStorage entityStorage;
    private final EventDispatcher<LibraryTable.Listener> dispatcher;
    private final Project parentProject;
    @NotNull
    private static final LibraryTablePresentation PROJECT_LIBRARY_TABLE_PRESENTATION;
    public static final Companion Companion;

    @ApiStatus.Internal
    public final void setNewLibraryInstances$intellij_platform_workspaceModel_ide(@NotNull List<LibraryBridgeImpl> addedInstances) {
        Object object = this.newLibraryInstances;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = "setNewLibraryInstances are not empty";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        for (LibraryBridgeImpl instance : addedInstances) {
            this.newLibraryInstances.put(instance.getLibraryId(), instance);
        }
    }

    private final void removeLibraryFromMaps(LibraryId id2, LibraryBridgeImpl libraryImpl) {
        this.librariesMap.remove(id2);
        boolean bl = false;
        List namesToRemove = new ArrayList();
        for (Map.Entry entry : this.libraryNameMap.entrySet()) {
            if (!((Collection)entry.getValue()).contains(libraryImpl)) continue;
            namesToRemove.add(entry.getKey());
        }
        for (String name : namesToRemove) {
            this.libraryNameMap.remove((Object)name, (Object)libraryImpl);
        }
    }

    private final void addLibraryToMaps(LibraryBridgeImpl library) {
        LibraryId entityId = library.getEntityId$intellij_platform_workspaceModel_ide();
        LibraryBridgeImpl existingLibrary = this.librariesMap.put(entityId, library);
        if (existingLibrary != null) {
            return;
        }
        this.libraryNameMap.putValue((Object)entityId.getName(), (Object)library);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.parentProject;
    }

    @NotNull
    public Library[] getLibraries() {
        Collection $this$toTypedArray$iv = this.librariesMap.values();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Library[] libraryArray = thisCollection$iv.toArray(new Library[0]);
        if (libraryArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return libraryArray;
    }

    @NotNull
    public Library createLibrary() {
        return this.createLibrary(null);
    }

    @NotNull
    public Library createLibrary(@Nullable String name) {
        if (name == null) {
            String string = "Creating unnamed project libraries is unsupported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.getLibraryByName(name) != null) {
            String string = "Project library named " + name + " already exists";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.createLibrary(name);
        modifiableModel.commit();
        Library newLibrary = this.getLibraryByName(name);
        if (newLibrary == null) {
            String string = "Library " + name + " was not created";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return newLibrary;
    }

    public void removeLibrary(@NotNull Library library) {
        LibraryTable.ModifiableModel modifiableModel = this.getModifiableModel();
        modifiableModel.removeLibrary(library);
        modifiableModel.commit();
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        return CollectionsKt.toMutableList(this.librariesMap.values()).iterator();
    }

    @Nullable
    public Library getLibraryByName(@NotNull String name) {
        return (Library)CollectionsKt.firstOrNull((Iterable)this.libraryNameMap.get((Object)name));
    }

    @NotNull
    public String getTableLevel() {
        return "project";
    }

    @NotNull
    public LibraryTablePresentation getPresentation() {
        return PROJECT_LIBRARY_TABLE_PRESENTATION;
    }

    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel() {
        WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder = null;
        WorkspaceEntityStorage workspaceEntityStorage = this.entityStorage.getCurrent();
        Project project = this.getProject();
        ProjectLibraryTableBridgeImpl projectLibraryTableBridgeImpl = this;
        return new ProjectModifiableLibraryTableBridgeImpl(workspaceEntityStorage, projectLibraryTableBridgeImpl, project, workspaceEntityStorageBuilder, 8, null);
    }

    @Override
    @NotNull
    public LibraryTable.ModifiableModel getModifiableModel(@NotNull WorkspaceEntityStorageBuilder diff) {
        WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder = diff;
        WorkspaceEntityStorage workspaceEntityStorage = this.entityStorage.getCurrent();
        Project project = this.getProject();
        ProjectLibraryTableBridgeImpl projectLibraryTableBridgeImpl = this;
        return new ProjectModifiableLibraryTableBridgeImpl(workspaceEntityStorage, projectLibraryTableBridgeImpl, project, workspaceEntityStorageBuilder);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2) {
        this.dispatcher.addListener((EventListener)listener2);
    }

    public void addListener(@NotNull LibraryTable.Listener listener2, @NotNull Disposable parentDisposable) {
        this.dispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeListener(@NotNull LibraryTable.Listener listener2) {
        this.dispatcher.removeListener((EventListener)listener2);
    }

    public void dispose() {
    }

    public ProjectLibraryTableBridgeImpl(@NotNull Project parentProject) {
        this.parentProject = parentProject;
        this.LOG = Logger.getInstance(this.getClass());
        this.librariesMap = new ConcurrentHashMap();
        this.libraryNameMap = MultiMap.createConcurrent();
        boolean bl = false;
        this.newLibraryInstances = new LinkedHashMap();
        this.entityStorage = WorkspaceModel.Companion.getInstance(this.parentProject).getEntityStorage();
        this.dispatcher = EventDispatcher.create(LibraryTable.Listener.class);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        WorkspaceModelTopics.Companion.getInstance(this.getProject()).subscribeAfterModuleLoading(messageBusConnection, new WorkspaceModelChangeListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void beforeChanged(@NotNull VersionedStorageChanged event) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = Companion.filterProjectLibraryChanges(event.getChanges(LibraryEntity.class));
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EntityChange.Removed)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List changes = (List)destination$iv$iv;
                if (changes.isEmpty()) {
                    return;
                }
                UtilsKt.executeOrQueueOnDispatchThread((Function0<Unit>)((Function0)new Function0<Unit>(this, changes){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ List $changes;

                    public final void invoke() {
                        UtilsKt.bracket(ProjectLibraryTableBridgeImpl.access$getLOG$p(this.this$0.this), "ProjectLibraryTable.beforeChanged", (Function0)new Function0<Unit>(this){
                            final /* synthetic */ beforeChanged.1 this$0;

                            public final void invoke() {
                                for (EntityChange.Removed change : this.this$0.$changes) {
                                    LibraryBridgeImpl libraryImpl = (LibraryBridgeImpl)MapsKt.getValue((Map)ProjectLibraryTableBridgeImpl.access$getLibrariesMap$p(this.this$0.this$0.this), (Object)((LibraryEntity)change.getEntity()).persistentId());
                                    ((LibraryTable.Listener)ProjectLibraryTableBridgeImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).beforeLibraryRemoved((Library)libraryImpl);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$changes = list2;
                        super(0);
                    }
                }));
            }

            @Override
            public void changed(@NotNull VersionedStorageChanged event) {
                List changes = Companion.filterProjectLibraryChanges(event.getChanges(LibraryEntity.class));
                if (changes.isEmpty()) {
                    return;
                }
                UtilsKt.executeOrQueueOnDispatchThread((Function0<Unit>)((Function0)new Function0<Unit>(this, changes){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ List $changes;

                    public final void invoke() {
                        UtilsKt.bracket(ProjectLibraryTableBridgeImpl.access$getLOG$p(this.this$0.this), "ProjectLibraryTable.EntityStoreChange", (Function0)new Function0<Unit>(this){
                            final /* synthetic */ changed.1 this$0;

                            public final void invoke() {
                                for (EntityChange change : this.this$0.$changes) {
                                    LibraryId idAfter;
                                    LibraryId idBefore;
                                    EntityChange entityChange = change;
                                    if (entityChange instanceof EntityChange.Added) {
                                        LibraryBridgeImpl libraryBridgeImpl;
                                        LibraryId addedLibraryId = ((LibraryEntity)((EntityChange.Added)change).getEntity()).persistentId();
                                        LibraryBridgeImpl alreadyCreatedLibrary = (LibraryBridgeImpl)ProjectLibraryTableBridgeImpl.access$getNewLibraryInstances$p(this.this$0.this$0.this).remove(addedLibraryId);
                                        if (alreadyCreatedLibrary != null) {
                                            alreadyCreatedLibrary.setEntityStorage$intellij_platform_workspaceModel_ide(ProjectLibraryTableBridgeImpl.access$getEntityStorage$p(this.this$0.this$0.this));
                                            alreadyCreatedLibrary.setModifiableModelFactory((Function2<? super LibraryStateSnapshot, ? super WorkspaceEntityStorageBuilder, LibraryModifiableModelBridgeImpl>)((Function2)null));
                                            libraryBridgeImpl = alreadyCreatedLibrary;
                                        } else {
                                            libraryBridgeImpl = new LibraryBridgeImpl(this.this$0.this$0.this, this.this$0.this$0.this.getProject(), addedLibraryId, ProjectLibraryTableBridgeImpl.access$getEntityStorage$p(this.this$0.this$0.this), this.this$0.this$0.this, null);
                                        }
                                        LibraryBridgeImpl libraryImpl = libraryBridgeImpl;
                                        ProjectLibraryTableBridgeImpl.access$addLibraryToMaps(this.this$0.this$0.this, libraryImpl);
                                        ((LibraryTable.Listener)ProjectLibraryTableBridgeImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).afterLibraryAdded((Library)libraryImpl);
                                        continue;
                                    }
                                    if (entityChange instanceof EntityChange.Removed) {
                                        LibraryId removedLibraryId = ((LibraryEntity)((EntityChange.Removed)change).getEntity()).persistentId();
                                        LibraryBridgeImpl libraryImpl = (LibraryBridgeImpl)MapsKt.getValue((Map)ProjectLibraryTableBridgeImpl.access$getLibrariesMap$p(this.this$0.this$0.this), (Object)removedLibraryId);
                                        ProjectLibraryTableBridgeImpl.access$removeLibraryFromMaps(this.this$0.this$0.this, removedLibraryId, libraryImpl);
                                        ((LibraryTable.Listener)ProjectLibraryTableBridgeImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).afterLibraryRemoved((Library)libraryImpl);
                                        Disposer.dispose((Disposable)((Disposable)libraryImpl));
                                        continue;
                                    }
                                    if (!(entityChange instanceof EntityChange.Replaced) || !(Intrinsics.areEqual((Object)(idBefore = ((LibraryEntity)((EntityChange.Replaced)change).getOldEntity()).persistentId()), (Object)(idAfter = ((LibraryEntity)((EntityChange.Replaced)change).getNewEntity()).persistentId())) ^ true)) continue;
                                    LibraryBridgeImpl library = (LibraryBridgeImpl)MapsKt.getValue((Map)ProjectLibraryTableBridgeImpl.access$getLibrariesMap$p(this.this$0.this$0.this), (Object)idBefore);
                                    ProjectLibraryTableBridgeImpl.access$removeLibraryFromMaps(this.this$0.this$0.this, idBefore, library);
                                    library.setEntityId$intellij_platform_workspaceModel_ide(idAfter);
                                    ProjectLibraryTableBridgeImpl.access$addLibraryToMaps(this.this$0.this$0.this, library);
                                    ((LibraryTable.Listener)ProjectLibraryTableBridgeImpl.access$getDispatcher$p(this.this$0.this$0.this).getMulticaster()).afterLibraryRenamed((Library)library, LibraryBridgeImpl.Companion.getLegacyLibraryName(idBefore));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        Map map2 = ProjectLibraryTableBridgeImpl.access$getNewLibraryInstances$p(this.this$0.this);
                        boolean bl = false;
                        if (!map2.isEmpty()) {
                            ProjectLibraryTableBridgeImpl.access$getLOG$p(this.this$0.this).error("Not all library instances were handled in change event. Leftovers:\n" + CollectionsKt.joinToString$default((Iterable)ProjectLibraryTableBridgeImpl.access$getNewLibraryInstances$p(this.this$0.this).keySet(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                            ProjectLibraryTableBridgeImpl.access$getNewLibraryInstances$p(this.this$0.this).clear();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$changes = list2;
                        super(0);
                    }
                }));
            }
        });
        UtilsKt.executeOrQueueOnDispatchThread((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                Sequence $this$forEach$iv = SequencesKt.filter(entityStorage.getCurrent().entities(LibraryEntity.class), (Function1)1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LibraryEntity libraryEntity = (LibraryEntity)element$iv;
                    boolean bl = false;
                    LibraryBridgeImpl library = new LibraryBridgeImpl(this, this.getProject(), libraryEntity.persistentId(), entityStorage, this, null);
                    this.addLibraryToMaps(library);
                    ((LibraryTable.Listener)dispatcher.getMulticaster()).afterLibraryAdded((Library)library);
                }
            }
        }));
    }

    static {
        Companion = new Companion(null);
        PROJECT_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

            @NotNull
            public String getDisplayName(boolean plural) {
                return ProjectModelBundle.message((String)"project.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
            }

            @NotNull
            public String getDescription() {
                return ProjectModelBundle.message((String)"libraries.node.text.project", (Object[])new Object[0]);
            }

            @NotNull
            public String getLibraryTableEditorTitle() {
                return ProjectModelBundle.message((String)"library.configure.project.title", (Object[])new Object[0]);
            }
        };
    }

    public static final /* synthetic */ Logger access$getLOG$p(ProjectLibraryTableBridgeImpl $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ ConcurrentMap access$getLibrariesMap$p(ProjectLibraryTableBridgeImpl $this) {
        return $this.librariesMap;
    }

    public static final /* synthetic */ Map access$getNewLibraryInstances$p(ProjectLibraryTableBridgeImpl $this) {
        return $this.newLibraryInstances;
    }

    public static final /* synthetic */ void access$removeLibraryFromMaps(ProjectLibraryTableBridgeImpl $this, LibraryId id2, LibraryBridgeImpl libraryImpl) {
        $this.removeLibraryFromMaps(id2, libraryImpl);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/ProjectLibraryTableBridgeImpl$Companion;", "", "()V", "PROJECT_LIBRARY_TABLE_PRESENTATION", "Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "getPROJECT_LIBRARY_TABLE_PRESENTATION$intellij_platform_workspaceModel_ide", "()Lcom/intellij/openapi/roots/libraries/LibraryTablePresentation;", "filterProjectLibraryChanges", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "intellij.platform.workspaceModel.ide"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<EntityChange<LibraryEntity>> filterProjectLibraryChanges(List<? extends EntityChange<LibraryEntity>> $this$filterProjectLibraryChanges) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$filterProjectLibraryChanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                EntityChange it = (EntityChange)element$iv$iv;
                boolean bl2 = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    bl = ((LibraryEntity)((EntityChange.Added)it).getEntity()).getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
                } else if (entityChange instanceof EntityChange.Removed) {
                    bl = ((LibraryEntity)((EntityChange.Removed)it).getEntity()).getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
                } else if (entityChange instanceof EntityChange.Replaced) {
                    bl = ((LibraryEntity)((EntityChange.Replaced)it).getOldEntity()).getTableId() instanceof LibraryTableId.ProjectLibraryTableId;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final LibraryTablePresentation getPROJECT_LIBRARY_TABLE_PRESENTATION$intellij_platform_workspaceModel_ide() {
            return PROJECT_LIBRARY_TABLE_PRESENTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

