/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheImpl;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeProjectLifecycleListener;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.VersionedEntityStorageImpl;
import com.intellij.workspaceModel.storage.VersionedStorageChanged;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J/\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;", "Lcom/intellij/workspaceModel/ide/WorkspaceModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl;", "cacheEnabled", "", "entityStorage", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorageImpl;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/VersionedEntityStorageImpl;", "projectEntities", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "dispose", "", "doUpdateProject", "R", "updater", "Lkotlin/Function1;", "notify", "(Lkotlin/jvm/functions/Function1;Z)Ljava/lang/Object;", "updateProjectModel", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateProjectModelSilent", "ProjectModelEntityStorage", "VersionedStorageChangedImpl", "intellij.platform.workspaceModel.ide"})
public final class WorkspaceModelImpl
implements WorkspaceModel,
Disposable {
    private final WorkspaceEntityStorageBuilder projectEntities;
    private final boolean cacheEnabled = !ApplicationManager.getApplication().isUnitTestMode() && LegacyBridgeProjectLifecycleListener.Companion.getCacheEnabled();
    private final WorkspaceModelCacheImpl cache;
    @NotNull
    private final VersionedEntityStorageImpl entityStorage;

    @Override
    @NotNull
    public VersionedEntityStorageImpl getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public <R> R updateProjectModel(@NotNull Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater2) {
        return this.doUpdateProject(updater2, true);
    }

    @Override
    public <R> R updateProjectModelSilent(@NotNull Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater2) {
        return this.doUpdateProject(updater2, false);
    }

    private final <R> R doUpdateProject(Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater2, boolean notify) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceEntityStorage before = this.projectEntities.toStorage();
        Object result2 = updater2.invoke((Object)this.projectEntities);
        Map<Class<?>, List<EntityChange<?>>> changes = this.projectEntities.collectChanges(before);
        this.projectEntities.resetChanges();
        if (notify) {
            this.getEntityStorage().replace(this.projectEntities.toStorage(), changes);
        } else {
            VersionedEntityStorageImpl versionedEntityStorageImpl = this.getEntityStorage();
            if (versionedEntityStorageImpl == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl.ProjectModelEntityStorage");
            }
            ((ProjectModelEntityStorage)versionedEntityStorageImpl).replaceSilent(this.projectEntities.toStorage(), changes);
        }
        return (R)result2;
    }

    public void dispose() {
    }

    public WorkspaceModelImpl(@NotNull Project project) {
        WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder;
        this.cache = this.cacheEnabled ? new WorkspaceModelCacheImpl(project, this) : null;
        this.entityStorage = new ProjectModelEntityStorage(project, WorkspaceEntityStorageBuilder.Companion.create().toStorage());
        WorkspaceEntityStorage initialContent = WorkspaceModelInitialTestContent.INSTANCE.pop$intellij_platform_workspaceModel_ide();
        if (initialContent != null) {
            WorkspaceEntityStorageBuilder testEntities = WorkspaceEntityStorageBuilder.Companion.from(initialContent);
            this.getEntityStorage().replace(testEntities.toStorage(), testEntities.collectChanges(WorkspaceEntityStorageBuilder.Companion.create()));
            workspaceEntityStorageBuilder = testEntities;
        } else if (this.cache != null) {
            Activity activity = StartUpMeasurer.startActivity((String)"(wm) Loading cache");
            WorkspaceEntityStorageBuilder workspaceEntityStorageBuilder2 = this.cache.loadCache();
            if (workspaceEntityStorageBuilder2 == null) {
                workspaceEntityStorageBuilder2 = WorkspaceEntityStorageBuilder.Companion.create();
            }
            WorkspaceEntityStorageBuilder cacheEntities = workspaceEntityStorageBuilder2;
            activity.end();
            this.getEntityStorage().replace(cacheEntities.toStorage(), cacheEntities.collectChanges(WorkspaceEntityStorageBuilder.Companion.create()));
            workspaceEntityStorageBuilder = cacheEntities;
        } else {
            workspaceEntityStorageBuilder = WorkspaceEntityStorageBuilder.Companion.create();
        }
        this.projectEntities = workspaceEntityStorageBuilder;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052 \u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00100\u000eH\u0014J:\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052 \u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00100\u000eH\u0014J0\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00052 \u0010\r\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00100\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl$ProjectModelEntityStorage;", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorageImpl;", "project", "Lcom/intellij/openapi/project/Project;", "initialStorage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;)V", "notificationsEnabled", "", "onBeforeChanged", "", "before", "after", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "onChanged", "replaceSilent", "newStorage", "intellij.platform.workspaceModel.ide"})
    private static final class ProjectModelEntityStorage
    extends VersionedEntityStorageImpl {
        private boolean notificationsEnabled;
        private final Project project;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void replaceSilent(@NotNull WorkspaceEntityStorage newStorage, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            this.notificationsEnabled = false;
            try {
                this.replace(newStorage, changes);
            }
            finally {
                this.notificationsEnabled = true;
            }
        }

        @Override
        protected void onBeforeChanged(@NotNull WorkspaceEntityStorage before, @NotNull WorkspaceEntityStorage after2, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            if (this.project.isDisposed() || Disposer.isDisposing((Disposable)((Disposable)this.project)) || !this.notificationsEnabled) {
                return;
            }
            WorkspaceModelTopics.Companion.getInstance(this.project).syncPublisher(this.project.getMessageBus()).beforeChanged(new VersionedStorageChangedImpl(this, before, after2, changes));
        }

        @Override
        protected void onChanged(@NotNull WorkspaceEntityStorage before, @NotNull WorkspaceEntityStorage after2, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            if (this.project.isDisposed() || Disposer.isDisposing((Disposable)((Disposable)this.project)) || !this.notificationsEnabled) {
                return;
            }
            WorkspaceModelTopics.Companion.getInstance(this.project).syncPublisher(this.project.getMessageBus()).changed(new VersionedStorageChangedImpl(this, before, after2, changes));
        }

        public ProjectModelEntityStorage(@NotNull Project project, @NotNull WorkspaceEntityStorage initialStorage) {
            super(initialStorage);
            this.project = project;
            this.notificationsEnabled = true;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011H\u0016J,\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u000b0\n\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\tH\u0016R(\u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl$VersionedStorageChangedImpl;", "Lcom/intellij/workspaceModel/storage/VersionedStorageChanged;", "entityStorage", "Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;", "storageBefore", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "storageAfter", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/workspaceModel/storage/EntityChange;", "(Lcom/intellij/workspaceModel/storage/VersionedEntityStorage;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;Ljava/util/Map;)V", "getStorageAfter", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "getStorageBefore", "getAllChanges", "Lkotlin/sequences/Sequence;", "getChanges", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityClass", "intellij.platform.workspaceModel.ide"})
    private static final class VersionedStorageChangedImpl
    extends VersionedStorageChanged {
        @NotNull
        private final WorkspaceEntityStorage storageBefore;
        @NotNull
        private final WorkspaceEntityStorage storageAfter;
        private final Map<Class<?>, List<EntityChange<?>>> changes;

        @Override
        @NotNull
        public <T extends WorkspaceEntity> List<EntityChange<T>> getChanges(@NotNull Class<T> entityClass) {
            List list2;
            List list3 = this.changes.get(entityClass);
            if (!(list3 instanceof List)) {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        @Override
        @NotNull
        public Sequence<EntityChange<?>> getAllChanges() {
            return SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.changes.values()));
        }

        @Override
        @NotNull
        public WorkspaceEntityStorage getStorageBefore() {
            return this.storageBefore;
        }

        @Override
        @NotNull
        public WorkspaceEntityStorage getStorageAfter() {
            return this.storageAfter;
        }

        public VersionedStorageChangedImpl(@NotNull VersionedEntityStorage entityStorage, @NotNull WorkspaceEntityStorage storageBefore, @NotNull WorkspaceEntityStorage storageAfter, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
            super(entityStorage);
            this.storageBefore = storageBefore;
            this.storageAfter = storageAfter;
            this.changes = changes;
        }
    }
}

