/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.CommonBundle;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.ManagePackagesDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.PackageManagementUsageCollector;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.intellij.webcore.packaging.RepoPackage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPackagesPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InstalledPackagesPanel.class);
    private final AnActionButton myUpgradeButton;
    protected final AnActionButton myInstallButton;
    private final AnActionButton myUninstallButton;
    protected final JBTable myPackagesTable;
    private final DefaultTableModel myPackagesTableModel;
    protected volatile PackageManagementService myPackageManagementService;
    protected final Project myProject;
    protected final PackagesNotificationPanel myNotificationArea;
    private final Set<String> myCurrentlyInstalling = new HashSet<String>();
    private final Map<InstalledPackage, String> myWaitingToUpgrade = new HashMap<InstalledPackage, String>();

    public InstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        super(new BorderLayout());
        this.myProject = project;
        this.myNotificationArea = area;
        Object[] names2 = new String[]{IdeBundle.message((String)"packages.settings.package", (Object[])new Object[0]), IdeBundle.message((String)"packages.settings.version", (Object[])new Object[0]), IdeBundle.message((String)"packages.settings.latest.version", (Object[])new Object[0])};
        this.myPackagesTableModel = new DefaultTableModel(names2, 0){

            @Override
            public boolean isCellEditable(int i2, int i1) {
                return false;
            }
        };
        final MyTableCellRenderer tableCellRenderer = new MyTableCellRenderer();
        this.myPackagesTable = new JBTable(this.myPackagesTableModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return tableCellRenderer;
            }
        };
        this.myPackagesTable.setStriped(true);
        this.myPackagesTable.getTableHeader().setReorderingAllowed(false);
        new TableSpeedSearch((JTable)this.myPackagesTable);
        this.myUpgradeButton = new DumbAwareActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.upgrade", (Object[])new Object[0]), IconUtil.getMoveUpIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PackageManagementUsageCollector.triggerUpgradePerformed(InstalledPackagesPanel.this.myProject, InstalledPackagesPanel.this.myPackageManagementService);
                InstalledPackagesPanel.this.upgradeAction();
            }
        };
        this.myInstallButton = new DumbAwareActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.install", (Object[])new Object[0]), IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PackageManagementUsageCollector.triggerBrowseAvailablePackagesPerformed(InstalledPackagesPanel.this.myProject, InstalledPackagesPanel.this.myPackageManagementService);
                if (InstalledPackagesPanel.this.myPackageManagementService != null) {
                    ManagePackagesDialog dialog2 = InstalledPackagesPanel.this.createManagePackagesDialog();
                    dialog2.show();
                }
            }
        };
        this.myInstallButton.setShortcut(CommonShortcuts.getNew());
        this.myUninstallButton = new DumbAwareActionButton(IdeBundle.messagePointer((String)"action.AnActionButton.text.uninstall", (Object[])new Object[0]), IconUtil.getRemoveIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PackageManagementUsageCollector.triggerUninstallPerformed(InstalledPackagesPanel.this.myProject, InstalledPackagesPanel.this.myPackageManagementService);
                InstalledPackagesPanel.this.uninstallAction();
            }
        };
        this.myUninstallButton.setShortcut(CommonShortcuts.getDelete());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myPackagesTable).disableUpDownActions().disableAddAction().disableRemoveAction().addExtraAction(this.myInstallButton).addExtraAction(this.myUninstallButton).addExtraAction(this.myUpgradeButton);
        decorator.addExtraActions(this.getExtraActions());
        this.add(decorator.createPanel());
        this.myInstallButton.setEnabled(false);
        this.myUninstallButton.setEnabled(false);
        this.myUpgradeButton.setEnabled(false);
        this.myPackagesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                InstalledPackagesPanel.this.updateUninstallUpgrade();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (InstalledPackagesPanel.this.myPackageManagementService != null && InstalledPackagesPanel.this.myInstallButton.isEnabled()) {
                    Object pkg;
                    ManagePackagesDialog dialog2 = InstalledPackagesPanel.this.createManagePackagesDialog();
                    Point p = e.getPoint();
                    int row = InstalledPackagesPanel.this.myPackagesTable.rowAtPoint(p);
                    int column = InstalledPackagesPanel.this.myPackagesTable.columnAtPoint(p);
                    if (row >= 0 && column >= 0 && (pkg = InstalledPackagesPanel.this.myPackagesTable.getValueAt(row, 0)) instanceof InstalledPackage) {
                        dialog2.selectPackage((InstalledPackage)pkg);
                    }
                    dialog2.show();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myPackagesTable);
    }

    protected AnActionButton[] getExtraActions() {
        return new AnActionButton[0];
    }

    @NotNull
    protected ManagePackagesDialog createManagePackagesDialog() {
        return new ManagePackagesDialog(this.myProject, this.myPackageManagementService, new PackageManagementService.Listener(){

            @Override
            public void operationStarted(String packageName) {
                InstalledPackagesPanel.this.myNotificationArea.hide();
                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
            }

            @Override
            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                InstalledPackagesPanel.this.myNotificationArea.showResult(packageName, errorDescription);
                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                InstalledPackagesPanel.this.doUpdatePackages(InstalledPackagesPanel.this.myPackageManagementService);
            }
        });
    }

    private void upgradeAction() {
        int[] rows = this.myPackagesTable.getSelectedRows();
        if (this.myPackageManagementService != null) {
            HashSet<String> upgradedPackages = new HashSet<String>();
            Set<String> packagesShouldBePostponed = this.getPackagesToPostpone();
            for (int row : rows) {
                Object packageObj = this.myPackagesTableModel.getValueAt(row, 0);
                if (!(packageObj instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)packageObj;
                String packageName = pkg.getName();
                String currentVersion = pkg.getVersion();
                String availableVersion = (String)this.myPackagesTableModel.getValueAt(row, 2);
                if (packagesShouldBePostponed.contains(packageName)) {
                    this.myWaitingToUpgrade.put(pkg, availableVersion);
                    continue;
                }
                if (!this.isUpdateAvailable(currentVersion, availableVersion)) continue;
                this.upgradePackage(pkg, availableVersion);
                upgradedPackages.add(packageName);
            }
            if (this.myCurrentlyInstalling.isEmpty() && upgradedPackages.isEmpty() && !this.myWaitingToUpgrade.isEmpty()) {
                this.upgradePostponedPackages();
            }
        }
    }

    private void upgradePostponedPackages() {
        Iterator<Map.Entry<InstalledPackage, String>> iterator2 = this.myWaitingToUpgrade.entrySet().iterator();
        Map.Entry<InstalledPackage, String> toUpgrade = iterator2.next();
        iterator2.remove();
        this.upgradePackage(toUpgrade.getKey(), toUpgrade.getValue());
    }

    protected Set<String> getPackagesToPostpone() {
        return Collections.emptySet();
    }

    private void upgradePackage(final @NotNull InstalledPackage pkg, final @Nullable String toVersion) {
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        this.myPackageManagementService.fetchPackageVersions(pkg.getName(), new CatchingConsumer<List<String>, Exception>(){

            public void consume(List<String> releases) {
                if (!releases.isEmpty() && !InstalledPackagesPanel.this.isUpdateAvailable(pkg.getVersion(), releases.get(0))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    final ModalityState modalityState = ModalityState.current();
                    PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                        @Override
                        public void operationStarted(String packageName) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                                InstalledPackagesPanel.this.myCurrentlyInstalling.add(packageName);
                            }, modalityState);
                        }

                        @Override
                        public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                                InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                                InstalledPackagesPanel.this.myCurrentlyInstalling.remove(packageName);
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(!InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty());
                                if (errorDescription == null) {
                                    InstalledPackagesPanel.this.myNotificationArea.showSuccess(IdeBundle.message((String)"package.successfully.upgraded", (Object[])new Object[]{packageName}));
                                } else {
                                    InstalledPackagesPanel.this.myNotificationArea.showError(IdeBundle.message((String)"upgrade.packages.failed", (Object[])new Object[0]) + " <a href=\"xxx\">" + IdeBundle.message((String)"upgrade.packages.failure.details", (Object[])new Object[0]) + "</a>", IdeBundle.message((String)"upgrade.packages.failed.dialog.title", (Object[])new Object[0]), errorDescription);
                                }
                                if (InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty() && !InstalledPackagesPanel.this.myWaitingToUpgrade.isEmpty()) {
                                    InstalledPackagesPanel.this.upgradePostponedPackages();
                                }
                            }, modalityState);
                        }
                    };
                    PackageManagementServiceEx serviceEx = InstalledPackagesPanel.this.getServiceEx();
                    if (serviceEx != null) {
                        serviceEx.updatePackage(pkg, toVersion, listener2);
                    } else {
                        InstalledPackagesPanel.this.myPackageManagementService.installPackage(new RepoPackage(pkg.getName(), null), null, true, null, listener2, false);
                    }
                    InstalledPackagesPanel.this.myUpgradeButton.setEnabled(false);
                }, ModalityState.any());
            }

            public void consume(Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)IdeBundle.message((String)"error.occurred.please.check.your.internet.connection", (Object[])new Object[0]), (String)IdeBundle.message((String)"upgrade.package.failed.title", (Object[])new Object[0])), ModalityState.any());
            }
        });
    }

    @Nullable
    private PackageManagementServiceEx getServiceEx() {
        return (PackageManagementServiceEx)ObjectUtils.tryCast((Object)this.myPackageManagementService, PackageManagementServiceEx.class);
    }

    protected void updateUninstallUpgrade() {
        int[] selected2 = this.myPackagesTable.getSelectedRows();
        boolean upgradeAvailable = false;
        boolean canUninstall = selected2.length != 0;
        boolean canInstall = this.installEnabled();
        boolean canUpgrade = true;
        if (this.myPackageManagementService != null && selected2.length != 0) {
            for (int i2 = 0; i2 != selected2.length; ++i2) {
                Object value2;
                int index = selected2[i2];
                if (index >= this.myPackagesTable.getRowCount() || !((value2 = this.myPackagesTable.getValueAt(index, 0)) instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)value2;
                if (!this.canUninstallPackage(pkg)) {
                    canUninstall = false;
                }
                canInstall = this.canInstallPackage(pkg);
                if (!this.canUpgradePackage(pkg)) {
                    canUpgrade = false;
                }
                String pyPackageName = pkg.getName();
                String availableVersion = (String)this.myPackagesTable.getValueAt(index, 2);
                if (!upgradeAvailable) {
                    boolean bl = upgradeAvailable = this.isUpdateAvailable(pkg.getVersion(), availableVersion) && !this.myCurrentlyInstalling.contains(pyPackageName);
                }
                if (!canUninstall && !canUpgrade) break;
            }
        }
        this.myUninstallButton.setEnabled(canUninstall);
        this.myInstallButton.setEnabled(canInstall);
        this.myUpgradeButton.setEnabled(upgradeAvailable && canUpgrade);
    }

    protected boolean canUninstallPackage(InstalledPackage pyPackage) {
        return true;
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        return true;
    }

    protected boolean installEnabled() {
        return true;
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        return true;
    }

    private void uninstallAction() {
        List<InstalledPackage> packages = this.getSelectedPackages();
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        if (selPackageManagementService != null) {
            final ModalityState modalityState = ModalityState.current();
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                @Override
                public void operationStarted(String packageName) {
                    ApplicationManager.getApplication().invokeLater(() -> InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true), modalityState);
                }

                @Override
                public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                        InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                        InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(!InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty());
                        if (errorDescription == null) {
                            if (packageName != null) {
                                InstalledPackagesPanel.this.myNotificationArea.showSuccess(IdeBundle.message((String)"package.successfully.uninstalled", (Object[])new Object[]{packageName}));
                            } else {
                                InstalledPackagesPanel.this.myNotificationArea.showSuccess(IdeBundle.message((String)"packages.successfully.uninstalled", (Object[])new Object[0]));
                            }
                        } else {
                            InstalledPackagesPanel.this.myNotificationArea.showError(IdeBundle.message((String)"uninstall.packages.failed", (Object[])new Object[0]) + " <a href=\"xxx\">" + IdeBundle.message((String)"uninstall.packages.failure.details", (Object[])new Object[0]) + "</a>", IdeBundle.message((String)"uninstall.packages.failed.dialog.title", (Object[])new Object[0]), errorDescription);
                        }
                    }, modalityState);
                }
            };
            this.myPackageManagementService.uninstallPackages(packages, listener2);
        }
    }

    @NotNull
    private List<InstalledPackage> getSelectedPackages() {
        int[] rows;
        ArrayList<InstalledPackage> results = new ArrayList<InstalledPackage>();
        for (int row : rows = this.myPackagesTable.getSelectedRows()) {
            Object packageName = this.myPackagesTableModel.getValueAt(row, 0);
            if (!(packageName instanceof InstalledPackage)) continue;
            results.add((InstalledPackage)packageName);
        }
        return results;
    }

    public void updatePackages(@Nullable PackageManagementService packageManagementService) {
        this.myPackageManagementService = packageManagementService;
        this.myPackagesTable.clearSelection();
        this.myPackagesTableModel.getDataVector().clear();
        this.myPackagesTableModel.fireTableDataChanged();
        if (packageManagementService != null) {
            this.doUpdatePackages(packageManagementService);
        }
    }

    private void onUpdateStarted() {
        this.myPackagesTable.setPaintBusy(true);
        this.myPackagesTable.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
    }

    private void onUpdateFinished() {
        this.myPackagesTable.setPaintBusy(!this.myCurrentlyInstalling.isEmpty());
        this.myPackagesTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
        this.updateUninstallUpgrade();
        ActivityTracker.getInstance().inc();
    }

    public void doUpdatePackages(final @NotNull PackageManagementService packageManagementService) {
        this.onUpdateStarted();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"packages.settings.loading", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Collection<Object> packages = new ArrayList();
                try {
                    packages = packageManagementService.getInstalledPackages();
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                }
                finally {
                    Collection<Object> finalPackages = packages;
                    Map cache = InstalledPackagesPanel.this.buildNameToPackageMap(packageManagementService.getAllPackagesCached());
                    boolean shouldFetchLatestVersionsForOnlyInstalledPackages = InstalledPackagesPanel.this.shouldFetchLatestVersionsForOnlyInstalledPackages();
                    if (cache.isEmpty() && !shouldFetchLatestVersionsForOnlyInstalledPackages) {
                        InstalledPackagesPanel.this.refreshLatestVersions(packageManagementService);
                    }
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (packageManagementService == InstalledPackagesPanel.this.myPackageManagementService) {
                            InstalledPackagesPanel.this.myPackagesTableModel.getDataVector().clear();
                            for (InstalledPackage pkg : finalPackages) {
                                RepoPackage repoPackage = (RepoPackage)cache.get(pkg.getName());
                                String version2 = repoPackage != null ? repoPackage.getLatestVersion() : null;
                                InstalledPackagesPanel.this.myPackagesTableModel.addRow(new Object[]{pkg, pkg.getVersion(), version2 == null ? "" : version2});
                            }
                            if (!cache.isEmpty()) {
                                InstalledPackagesPanel.this.onUpdateFinished();
                            }
                            if (shouldFetchLatestVersionsForOnlyInstalledPackages) {
                                InstalledPackagesPanel.this.setLatestVersionsForInstalledPackages();
                            }
                        }
                    });
                }
            }
        });
    }

    private InstalledPackage getInstalledPackageAt(int index) {
        return (InstalledPackage)this.myPackagesTableModel.getValueAt(index, 0);
    }

    private void setLatestVersionsForInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx == null) {
            return;
        }
        int packageCount = this.myPackagesTableModel.getRowCount();
        if (packageCount == 0) {
            this.onUpdateFinished();
        }
        final AtomicInteger inProgressPackageCount = new AtomicInteger(packageCount);
        int i2 = 0;
        while (i2 < packageCount) {
            final int finalIndex = i2++;
            final InstalledPackage pkg = this.getInstalledPackageAt(finalIndex);
            serviceEx.fetchLatestVersion(pkg, new CatchingConsumer<String, Exception>(){

                private void decrement() {
                    if (inProgressPackageCount.decrementAndGet() == 0) {
                        InstalledPackagesPanel.this.onUpdateFinished();
                    }
                }

                public void consume(Exception e) {
                    UIUtil.invokeLaterIfNeeded(() -> this.decrement());
                    LOG.warn("Cannot fetch the latest version of the installed package " + pkg, (Throwable)e);
                }

                public void consume(@Nullable String latestVersion) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        InstalledPackage p;
                        if (finalIndex < InstalledPackagesPanel.this.myPackagesTableModel.getRowCount() && pkg == (p = InstalledPackagesPanel.this.getInstalledPackageAt(finalIndex))) {
                            InstalledPackagesPanel.this.myPackagesTableModel.setValueAt(latestVersion, finalIndex, 2);
                        }
                        this.decrement();
                    });
                }
            });
        }
    }

    private boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx != null) {
            return serviceEx.shouldFetchLatestVersionsForOnlyInstalledPackages();
        }
        return false;
    }

    private boolean isUpdateAvailable(@Nullable String currentVersion, @Nullable String availableVersion) {
        if (availableVersion == null) {
            return false;
        }
        if (currentVersion == null) {
            return true;
        }
        PackageManagementService service = this.myPackageManagementService;
        if (service != null) {
            return service.compareVersions(currentVersion, availableVersion) < 0;
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(currentVersion, availableVersion) < 0;
    }

    private void refreshLatestVersions(@NotNull PackageManagementService packageManagementService) {
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (packageManagementService == this.myPackageManagementService) {
                try {
                    List<RepoPackage> packages = packageManagementService.reloadAllPackages();
                    Map<String, RepoPackage> packageMap = this.buildNameToPackageMap(packages);
                    application.invokeLater(() -> {
                        for (int i2 = 0; i2 != this.myPackagesTableModel.getRowCount(); ++i2) {
                            InstalledPackage pyPackage = (InstalledPackage)this.myPackagesTableModel.getValueAt(i2, 0);
                            RepoPackage repoPackage = (RepoPackage)packageMap.get(pyPackage.getName());
                            this.myPackagesTableModel.setValueAt(repoPackage == null ? null : repoPackage.getLatestVersion(), i2, 2);
                        }
                        this.myPackagesTable.setPaintBusy(!this.myCurrentlyInstalling.isEmpty());
                    }, ModalityState.stateForComponent((Component)this.myPackagesTable));
                }
                catch (IOException ignored) {
                    LOG.warn("Cannot refresh the list of available packages with their latest versions", (Throwable)ignored);
                    this.myPackagesTable.setPaintBusy(false);
                }
            }
        });
    }

    private Map<String, RepoPackage> buildNameToPackageMap(List<? extends RepoPackage> packages) {
        try {
            return InstalledPackagesPanel.doBuildNameToPackageMap(packages);
        }
        catch (Exception e) {
            PackageManagementService service = this.myPackageManagementService;
            LOG.error("Failure in " + this.getClass().getName() + ", service: " + (service != null ? service.getClass().getName() : null), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static Map<String, RepoPackage> doBuildNameToPackageMap(List<? extends RepoPackage> packages) {
        HashMap<String, RepoPackage> packageMap = new HashMap<String, RepoPackage>();
        for (RepoPackage repoPackage : packages) {
            packageMap.put(repoPackage.getName(), repoPackage);
        }
        return packageMap;
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            String version2 = (String)table.getValueAt(row, 1);
            String availableVersion = (String)table.getValueAt(row, 2);
            boolean update2 = column == 2 && StringUtil.isNotEmpty((String)availableVersion) && InstalledPackagesPanel.this.isUpdateAvailable(version2, availableVersion);
            cell.setIcon(update2 ? IconUtil.getMoveUpIcon() : null);
            Object pyPackage = table.getValueAt(row, 0);
            if (pyPackage instanceof InstalledPackage) {
                cell.setToolTipText(((InstalledPackage)pyPackage).getTooltipText());
            }
            return cell;
        }
    }
}

