/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TextCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        int offset;
        String text;
        String prefix;
        PsiFile file2 = parameters2.getOriginalFile();
        TextCompletionProvider provider = TextCompletionUtil.getProvider(file2);
        if (provider == null) {
            return;
        }
        if (parameters2.getInvocationCount() == 0 && !Boolean.TRUE.equals(file2.getUserData(TextCompletionUtil.AUTO_POPUP_KEY))) {
            return;
        }
        String advertisement = provider.getAdvertisement();
        if (advertisement != null) {
            result2.addLookupAdvertisement(advertisement);
        }
        if ((prefix = provider.getPrefix(text = file2.getText(), offset = Math.min(text.length(), parameters2.getOffset()))) == null) {
            return;
        }
        CompletionResultSet activeResult = provider.applyPrefixMatcher(result2, prefix);
        provider.fillCompletionVariants(parameters2, prefix, activeResult);
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        TextCompletionProvider provider = TextCompletionUtil.getProvider(position.getContainingFile());
        if (provider != null && Boolean.TRUE.equals(position.getContainingFile().getUserData(TextCompletionUtil.AUTO_POPUP_KEY))) {
            return Objects.equals((Object)CharFilter.Result.ADD_TO_PREFIX, (Object)provider.acceptChar(typeChar));
        }
        return super.invokeAutoPopup(position, typeChar);
    }
}

