/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import com.intellij.util.indexing.snapshot.HashedInputData;
import com.intellij.util.indexing.snapshot.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashIdForwardIndexAccessor<Key, Value, Input>
extends AbstractMapForwardIndexAccessor<Key, Value, Integer>
implements IntForwardIndexAccessor<Key, Value> {
    private final UpdatableSnapshotInputMappingIndex<Key, Value, Input> mySnapshotInputMappingIndex;
    private final AbstractMapForwardIndexAccessor<Key, Value, ?> myForwardIndexAccessor;

    HashIdForwardIndexAccessor(@NotNull UpdatableSnapshotInputMappingIndex<Key, Value, Input> snapshotInputMappingIndex, @NotNull AbstractMapForwardIndexAccessor<Key, Value, ?> forwardIndexAccessor) {
        super((DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE);
        this.mySnapshotInputMappingIndex = snapshotInputMappingIndex;
        this.myForwardIndexAccessor = forwardIndexAccessor;
    }

    @Nullable
    protected Map<Key, Value> convertToMap(int inputId, @Nullable Integer hashId) throws IOException {
        return hashId == null ? null : this.mySnapshotInputMappingIndex.readData(hashId);
    }

    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilderFromInt(int inputId, int hashId) throws IOException {
        Map map2 = ContainerUtil.notNullize(this.convertToMap(inputId, hashId));
        return this.createDiffBuilderByMap(inputId, map2);
    }

    @NotNull
    public InputDataDiffBuilder<Key, Value> createDiffBuilderByMap(int inputId, @Nullable Map<Key, Value> map2) throws IOException {
        return this.myForwardIndexAccessor.createDiffBuilderByMap(inputId, map2);
    }

    public int serializeIndexedDataToInt(@NotNull InputData<Key, Value> data2) {
        return data2 == InputData.empty() ? 0 : ((HashedInputData)data2).getHashId();
    }

    @Nullable
    public Integer convertToDataType(@NotNull InputData<Key, Value> data2) {
        return this.serializeIndexedDataToInt(data2);
    }
}

