/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.memory;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryIndexStorage<K, V>
implements VfsAwareIndexStorage<K, V> {
    private final Map<K, ValueContainerImpl<V>> myMap = new THashMap();

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor2, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        return this.myMap.keySet().stream().allMatch(arg_0 -> processor2.process(arg_0));
    }

    public void addValue(K k, int inputId, V v) {
        this.myMap.computeIfAbsent(k, __ -> new ValueContainerImpl()).addValue(inputId, v);
    }

    public void removeAllValues(@NotNull K k, int inputId) {
        ValueContainerImpl<V> container2 = this.myMap.get(k);
        if (container2 == null) {
            return;
        }
        container2.removeAssociatedValue(inputId);
        if (container2.size() == 0) {
            this.myMap.remove(k);
        }
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public ValueContainer<V> read(K k) throws StorageException {
        return (ValueContainer)ObjectUtils.notNull(this.myMap.get(k), (Object)new ValueContainerImpl());
    }

    public void clearCaches() {
    }

    public void close() {
    }

    public void flush() {
    }
}

