/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.perFileVersion;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerVersionEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import gnu.trove.THashMap;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentSubIndexerRetriever<SubIndexerType, SubIndexerVersion>
implements Closeable {
    private static final String INDEXED_VERSIONS = "indexed_versions";
    @NotNull
    private final PersistentSubIndexerVersionEnumerator<SubIndexerVersion> myPersistentVersionEnumerator;
    @NotNull
    private final FileAttribute myFileAttribute;
    @NotNull
    private final CompositeDataIndexer<?, ?, SubIndexerType, SubIndexerVersion> myIndexer;
    private static final Map<Pair<String, Integer>, FileAttribute> ourAttributes = new THashMap();

    public PersistentSubIndexerRetriever(@NotNull ID<?, ?> id2, int indexVersion, @NotNull CompositeDataIndexer<?, ?, SubIndexerType, SubIndexerVersion> indexer) throws IOException {
        this(IndexInfrastructure.getIndexRootDir(id2), id2.getName(), indexVersion, indexer);
    }

    PersistentSubIndexerRetriever(@NotNull File root, @NotNull String indexName, int indexVersion, @NotNull CompositeDataIndexer<?, ?, SubIndexerType, SubIndexerVersion> indexer) throws IOException {
        Path versionMapRoot = root.toPath().resolve(PersistentSubIndexerRetriever.versionMapRoot());
        this.myFileAttribute = PersistentSubIndexerRetriever.getFileAttribute(indexName, indexVersion);
        this.myIndexer = indexer;
        this.myPersistentVersionEnumerator = new PersistentSubIndexerVersionEnumerator(versionMapRoot.resolve(INDEXED_VERSIONS).toFile(), indexer.getSubIndexerVersionDescriptor());
    }

    public void clear() throws IOException {
        this.myPersistentVersionEnumerator.clear();
    }

    @Override
    public void close() throws IOException {
        this.myPersistentVersionEnumerator.close();
    }

    public void flush() throws IOException {
        this.myPersistentVersionEnumerator.flush();
    }

    private static Path versionMapRoot() {
        return Paths.get(".perFileVersion", INDEXED_VERSIONS);
    }

    public void setIndexedState(int fileId, @NotNull IndexedFile file2) throws IOException {
        try (DataOutputStream stream = FSRecords.writeAttribute(fileId, this.myFileAttribute);){
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)((Integer)ProgressManager.getInstance().computeInNonCancelableSection(() -> this.getFileIndexerId(file2))));
        }
    }

    public boolean isIndexed(int fileId, @NotNull IndexedFile file2) throws IOException {
        DataInputStream stream = FSRecords.readAttributeWithLock(fileId, this.myFileAttribute);
        if (stream != null) {
            int currentIndexedVersion = DataInputOutputUtil.readINT((DataInput)stream);
            int actualVersion = this.getFileIndexerId(file2);
            return actualVersion == currentIndexedVersion;
        }
        return false;
    }

    public int getFileIndexerId(@NotNull IndexedFile file2) throws IOException {
        SubIndexerVersion version2 = this.getVersion(file2);
        if (version2 == null) {
            return -1;
        }
        return this.myPersistentVersionEnumerator.enumerate(version2);
    }

    @Nullable
    public SubIndexerVersion getVersion(@NotNull IndexedFile file2) {
        Object type = this.myIndexer.calculateSubIndexer(file2);
        if (type == null) {
            return null;
        }
        return (SubIndexerVersion)this.myIndexer.getSubIndexerVersion(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileAttribute getFileAttribute(String name, int version2) {
        Map<Pair<String, Integer>, FileAttribute> map2 = ourAttributes;
        synchronized (map2) {
            return ourAttributes.computeIfAbsent((Pair<String, Integer>)Pair.create((Object)name, (Object)version2), __ -> new FileAttribute(name + ".index.version", version2, false));
        }
    }
}

