/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleEntryIndexForwardIndexAccessor<V>
extends AbstractMapForwardIndexAccessor<Integer, V, Void> {
    private static final Logger LOG = Logger.getInstance(SingleEntryIndexForwardIndexAccessor.class);
    private final VolatileNotNullLazyValue<UpdatableIndex<Integer, V, ?>> myIndex;

    public SingleEntryIndexForwardIndexAccessor(IndexExtension<Integer, V, ?> extension) {
        super((DataExternalizer)VoidDataExternalizer.INSTANCE);
        LOG.assertTrue(extension instanceof SingleEntryFileBasedIndexExtension);
        IndexId name = extension.getName();
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myIndex = VolatileNotNullLazyValue.createValue(() -> fileBasedIndex.getIndex((ID)name));
    }

    @NotNull
    public final InputDataDiffBuilder<Integer, V> getDiffBuilder(int inputId, @Nullable ByteArraySequence sequence) throws IOException {
        Map data2;
        try {
            data2 = (Map)ProgressManager.getInstance().computeInNonCancelableSection(() -> ((UpdatableIndex)this.myIndex.getValue()).getIndexedFileData(inputId));
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        return this.createDiffBuilderByMap(inputId, data2);
    }

    @Nullable
    public Void convertToDataType(@NotNull InputData<Integer, V> data2) {
        return null;
    }

    @NotNull
    public InputDataDiffBuilder<Integer, V> createDiffBuilderByMap(int inputId, @Nullable Map<Integer, V> map2) throws IOException {
        return new SingleValueDiffBuilder(inputId, ContainerUtil.notNullize(map2));
    }

    @Nullable
    public final ByteArraySequence serializeIndexedData(@NotNull InputData<Integer, V> data2) {
        return null;
    }

    @Nullable
    protected Map<Integer, V> convertToMap(int inputId, @Nullable Void inputData) throws IOException {
        try {
            return (Map)ProgressManager.getInstance().computeInNonCancelableSection(() -> ((UpdatableIndex)this.myIndex.getValue()).getIndexedFileData(inputId));
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    public static class SingleValueDiffBuilder<V>
    extends DirectInputDataDiffBuilder<Integer, V> {
        private final int myInputId;
        private final boolean myContainsValue;
        @Nullable
        private final V myCurrentValue;

        public SingleValueDiffBuilder(int inputId, @NotNull Map<Integer, V> currentData) {
            this(inputId, !currentData.isEmpty(), ContainerUtil.getFirstItem(currentData.values()));
        }

        private SingleValueDiffBuilder(int inputId, boolean containsValue, @Nullable V currentValue) {
            super(inputId);
            this.myInputId = inputId;
            this.myContainsValue = containsValue;
            this.myCurrentValue = currentValue;
        }

        @NotNull
        public Collection<Integer> getKeys() {
            return this.myContainsValue ? Collections.singleton(this.myInputId) : Collections.emptySet();
        }

        public boolean differentiate(@NotNull Map<Integer, V> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super V> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super V> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
            boolean newValueExists = !newData.isEmpty();
            Object newValue2 = ContainerUtil.getFirstItem(newData.values());
            if (this.myContainsValue) {
                if (!newValueExists) {
                    removeProcessor.process((Object)this.myInputId, this.myInputId);
                    return true;
                }
                if (Comparing.equal(this.myCurrentValue, (Object)newValue2)) {
                    return false;
                }
                updateProcessor.process((Object)this.myInputId, newValue2, this.myInputId);
                return true;
            }
            if (newValueExists) {
                addProcessor.process((Object)this.myInputId, newValue2, this.myInputId);
                return true;
            }
            return false;
        }
    }
}

