/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.contentQueue.CachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.CurrentProjectHintedCachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.FailedToLoadContentException;
import com.intellij.util.indexing.contentQueue.TooLargeContentException;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.TooLargeForIndexingFile;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexUpdateRunner {
    private static final long SOFT_MAX_TOTAL_BYTES_LOADED_INTO_MEMORY = 0x1400000L;
    private static final CopyOnWriteArrayList<IndexingJob> ourIndexingJobs = new CopyOnWriteArrayList();
    private final FileBasedIndexImpl myFileBasedIndex;
    private final ExecutorService myIndexingExecutor;
    private final int myNumberOfIndexingThreads;
    private static long ourTotalBytesLoadedIntoMemory = 0L;
    private static final Lock ourLoadedBytesLimitLock = new ReentrantLock();
    private static final Condition ourLoadedBytesAreReleasedCondition = ourLoadedBytesLimitLock.newCondition();

    public IndexUpdateRunner(@NotNull FileBasedIndexImpl fileBasedIndex, @NotNull ExecutorService indexingExecutor, int numberOfIndexingThreads) {
        this.myFileBasedIndex = fileBasedIndex;
        this.myIndexingExecutor = indexingExecutor;
        this.myNumberOfIndexingThreads = numberOfIndexingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public IndexingJobStatistics indexFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files2, @NotNull ProgressIndicator indicator) {
        indicator.checkCanceled();
        indicator.setIndeterminate(false);
        CurrentProjectHintedCachedFileContentLoader contentLoader = new CurrentProjectHintedCachedFileContentLoader(project);
        ProgressIndicator originalIndicator = IndexUpdateRunner.unwrapAll(indicator);
        ProgressSuspender originalSuspender = ProgressSuspender.getSuspender(originalIndicator);
        IndexingJob indexingJob = new IndexingJob(project, indicator, contentLoader, files2, originalIndicator, originalSuspender);
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            while (!indexingJob.areAllFilesProcessed()) {
                this.indexOneFileOfJob(indexingJob);
            }
        } else {
            ourIndexingJobs.add(indexingJob);
            try {
                Throwable error;
                AtomicInteger numberOfRunningWorkers = new AtomicInteger();
                Runnable worker = () -> {
                    try {
                        this.indexJobsFairly();
                    }
                    finally {
                        numberOfRunningWorkers.decrementAndGet();
                    }
                };
                for (int i2 = 0; i2 < this.myNumberOfIndexingThreads; ++i2) {
                    this.myIndexingExecutor.execute(worker);
                    numberOfRunningWorkers.incrementAndGet();
                }
                while (!project.isDisposed() && !indexingJob.areAllFilesProcessed() && indexingJob.myError.get() == null) {
                    indicator.checkCanceled();
                    int toAddWorkersNumber = this.myNumberOfIndexingThreads - numberOfRunningWorkers.get();
                    for (int i3 = 0; i3 < toAddWorkersNumber; ++i3) {
                        this.myIndexingExecutor.execute(worker);
                        numberOfRunningWorkers.incrementAndGet();
                    }
                    try {
                        if (!indexingJob.myAllFilesAreProcessedLatch.await(100L, TimeUnit.MILLISECONDS)) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new ProcessCanceledException((Throwable)e);
                    }
                }
                if ((error = indexingJob.myError.get()) instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)error;
                }
                if (error != null) {
                    throw new RuntimeException("Indexing of " + project.getName() + " has failed", error);
                }
            }
            finally {
                ourIndexingJobs.remove(indexingJob);
            }
        }
        return indexingJob.myStatistics;
    }

    private void indexJobsFairly() {
        while (!ourIndexingJobs.isEmpty()) {
            boolean allJobsAreSuspended = true;
            for (IndexingJob job2 : ourIndexingJobs) {
                ProgressIndicator jobIndicator = job2.myIndicator;
                if (job2.myProject.isDisposed() || job2.myNoMoreFilesInQueue.get() || jobIndicator.isCanceled() || job2.myError.get() != null) {
                    ourIndexingJobs.remove(job2);
                    allJobsAreSuspended = false;
                    continue;
                }
                ProgressSuspender suspender = job2.myOriginalProgressSuspender;
                if (suspender != null && suspender.isSuspended()) continue;
                allJobsAreSuspended = false;
                try {
                    Runnable work = () -> this.indexOneFileOfJob(job2);
                    if (suspender != null) {
                        suspender.executeNonSuspendableSection(job2.myOriginalProgressIndicator, work);
                        continue;
                    }
                    work.run();
                }
                catch (Throwable e) {
                    job2.myError.compareAndSet(null, e);
                    ourIndexingJobs.remove(job2);
                }
            }
            if (!allJobsAreSuspended) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexOneFileOfJob(@NotNull IndexingJob indexingJob) throws ProcessCanceledException {
        ContentLoadingResult loadingResult;
        long contentLoadingTime = System.nanoTime();
        try {
            loadingResult = this.loadNextContent(indexingJob, indexingJob.myIndicator);
        }
        catch (TooLargeContentException e) {
            indexingJob.oneMoreFileProcessed();
            indexingJob.myStatistics.getNumberOfTooLargeForIndexingFiles().incrementAndGet();
            indexingJob.myStatistics.getTooLargeForIndexingFiles().addElement(new TooLargeForIndexingFile(e.getFile().getName(), e.getFile().getLength()));
            FileBasedIndexImpl.LOG.info("File: " + e.getFile().getUrl() + " is too large for indexing");
            return;
        }
        catch (FailedToLoadContentException e) {
            indexingJob.oneMoreFileProcessed();
            IndexUpdateRunner.logFailedToLoadContentException(e);
            return;
        }
        finally {
            contentLoadingTime = System.nanoTime() - contentLoadingTime;
        }
        if (loadingResult == null) {
            return;
        }
        CachedFileContent fileContent = loadingResult.cachedFileContent;
        VirtualFile file2 = fileContent.getVirtualFile();
        try {
            indexingJob.setLocationBeingIndexed(file2);
            if (!file2.isDirectory()) {
                FileIndexingStatistics fileIndexingStatistics = (FileIndexingStatistics)ReadAction.nonBlocking(() -> this.myFileBasedIndex.indexFileContent(indexingJob.myProject, fileContent)).expireWith((Disposable)indexingJob.myProject).wrapProgress(indexingJob.myIndicator).executeSynchronously();
                indexingJob.myStatistics.addFileStatistics(fileIndexingStatistics, contentLoadingTime, loadingResult.fileLength);
            }
            indexingJob.oneMoreFileProcessed();
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (Throwable e) {
            indexingJob.oneMoreFileProcessed();
            FileBasedIndexImpl.LOG.error("Error while indexing " + file2.getPresentableUrl() + "\nTo reindex this file IDEA has to be restarted", e);
        }
        finally {
            IndexUpdateRunner.signalThatFileIsUnloaded(loadingResult.fileLength);
        }
    }

    @Nullable
    private ContentLoadingResult loadNextContent(@NotNull IndexingJob indexingJob, @NotNull ProgressIndicator indicator) throws FailedToLoadContentException, TooLargeContentException, ProcessCanceledException {
        long fileLength;
        VirtualFile file2 = (VirtualFile)indexingJob.myQueueOfFiles.poll();
        if (file2 == null) {
            indexingJob.myNoMoreFilesInQueue.set(true);
            return null;
        }
        if (this.myFileBasedIndex.isTooLarge(file2)) {
            throw new TooLargeContentException(file2);
        }
        try {
            fileLength = file2.getLength();
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (Throwable e) {
            throw new FailedToLoadContentException(file2, e);
        }
        try {
            IndexUpdateRunner.waitForFreeMemoryToLoadFileContent(indicator, fileLength);
        }
        catch (ProcessCanceledException e) {
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        try {
            CachedFileContent fileContent = indexingJob.myContentLoader.loadContent(file2);
            return new ContentLoadingResult(fileContent, fileLength);
        }
        catch (ProcessCanceledException e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            indexingJob.myQueueOfFiles.add(file2);
            throw e;
        }
        catch (FailedToLoadContentException | TooLargeContentException e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            throw e;
        }
        catch (Throwable e) {
            IndexUpdateRunner.signalThatFileIsUnloaded(fileLength);
            ExceptionUtil.rethrow((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForFreeMemoryToLoadFileContent(@NotNull ProgressIndicator indicator, long fileLength) throws ProcessCanceledException {
        ourLoadedBytesLimitLock.lock();
        try {
            while (ourTotalBytesLoadedIntoMemory >= 0x1400000L) {
                indicator.checkCanceled();
                try {
                    ourLoadedBytesAreReleasedCondition.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }
            ourTotalBytesLoadedIntoMemory += fileLength;
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void signalThatFileIsUnloaded(long fileLength) {
        ourLoadedBytesLimitLock.lock();
        try {
            assert (ourTotalBytesLoadedIntoMemory >= fileLength);
            if ((ourTotalBytesLoadedIntoMemory -= fileLength) < 0x1400000L) {
                ourLoadedBytesAreReleasedCondition.signalAll();
            }
        }
        finally {
            ourLoadedBytesLimitLock.unlock();
        }
    }

    private static void logFailedToLoadContentException(@NotNull FailedToLoadContentException e) {
        Throwable cause = e.getCause();
        VirtualFile file2 = e.getFile();
        String fileUrl = "File: " + file2.getUrl();
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            FileBasedIndexImpl.LOG.debug(fileUrl, (Throwable)e);
        } else if (cause instanceof IndexOutOfBoundsException || cause instanceof InvalidVirtualFileAccessException) {
            FileBasedIndexImpl.LOG.info(fileUrl, (Throwable)e);
        } else {
            FileBasedIndexImpl.LOG.error(fileUrl, (Throwable)e);
        }
    }

    @NotNull
    public static String getPresentableLocationBeingIndexed(@NotNull Project project, @NotNull VirtualFile file2) {
        VirtualFile actualFile = file2;
        if (actualFile.getFileSystem() instanceof ArchiveFileSystem) {
            actualFile = VfsUtil.getLocalFile((VirtualFile)actualFile);
        }
        return FileUtil.toSystemDependentName((String)IndexUpdateRunner.getProjectRelativeOrAbsolutePath(project, actualFile));
    }

    @NotNull
    private static String getProjectRelativeOrAbsolutePath(@NotNull Project project, @NotNull VirtualFile file2) {
        String filePath;
        String projectBase = project.getBasePath();
        if (StringUtil.isNotEmpty((String)projectBase) && FileUtil.isAncestor((String)projectBase, (String)(filePath = file2.getPath()), (boolean)true)) {
            String projectDirName = PathUtil.getFileName((String)projectBase);
            String relativePath = FileUtil.getRelativePath((String)projectBase, (String)filePath, (char)'/');
            if (StringUtil.isNotEmpty((String)projectDirName) && StringUtil.isNotEmpty((String)relativePath)) {
                return projectDirName + "/" + relativePath;
            }
        }
        return file2.getPath();
    }

    @NotNull
    private static ProgressIndicator unwrapAll(@NotNull ProgressIndicator indicator) {
        while (indicator instanceof WrappedProgressIndicator) {
            indicator = ((WrappedProgressIndicator)indicator).getOriginalProgressIndicator();
        }
        return indicator;
    }

    private static class IndexingJob {
        final Project myProject;
        final CachedFileContentLoader myContentLoader;
        final BlockingQueue<VirtualFile> myQueueOfFiles;
        final ProgressIndicator myIndicator;
        final int myTotalFiles;
        final AtomicBoolean myNoMoreFilesInQueue = new AtomicBoolean();
        final CountDownLatch myAllFilesAreProcessedLatch;
        final ProgressIndicator myOriginalProgressIndicator;
        @Nullable
        final ProgressSuspender myOriginalProgressSuspender;
        final IndexingJobStatistics myStatistics = new IndexingJobStatistics();
        final AtomicReference<Throwable> myError = new AtomicReference();

        IndexingJob(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull CachedFileContentLoader contentLoader, @NotNull Collection<VirtualFile> files2, @NotNull ProgressIndicator originalProgressIndicator, @Nullable ProgressSuspender originalProgressSuspender) {
            this.myProject = project;
            this.myIndicator = indicator;
            this.myTotalFiles = files2.size();
            this.myContentLoader = contentLoader;
            this.myQueueOfFiles = new ArrayBlockingQueue<VirtualFile>(files2.size(), false, files2);
            this.myAllFilesAreProcessedLatch = new CountDownLatch(files2.size());
            this.myOriginalProgressIndicator = originalProgressIndicator;
            this.myOriginalProgressSuspender = originalProgressSuspender;
        }

        public void oneMoreFileProcessed() {
            this.myAllFilesAreProcessedLatch.countDown();
            double newFraction = 1.0 - (double)this.myAllFilesAreProcessedLatch.getCount() / (double)this.myTotalFiles;
            try {
                this.myIndicator.setFraction(newFraction);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        boolean areAllFilesProcessed() {
            return this.myAllFilesAreProcessedLatch.getCount() == 0L;
        }

        public void setLocationBeingIndexed(@NotNull VirtualFile virtualFile) {
            String presentableLocation = IndexUpdateRunner.getPresentableLocationBeingIndexed(this.myProject, virtualFile);
            if (this.myIndicator instanceof SubTaskProgressIndicator) {
                this.myIndicator.setText(presentableLocation);
            } else {
                this.myIndicator.setText2(presentableLocation);
            }
        }
    }

    private static class ContentLoadingResult {
        @NotNull
        final CachedFileContent cachedFileContent;
        final long fileLength;

        private ContentLoadingResult(@NotNull CachedFileContent cachedFileContent, long fileLength) {
            this.cachedFileContent = cachedFileContent;
            this.fileLength = fileLength;
        }
    }
}

