/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import org.jetbrains.annotations.NotNull;

class StorageGuard {
    private int myHolds;
    private int myWaiters;
    private final StorageModeExitHandler myTrueStorageModeExitHandler = new StorageModeExitHandler(){

        @Override
        public void leave() {
            StorageGuard.this.leave(true);
        }
    };
    private final StorageModeExitHandler myFalseStorageModeExitHandler = new StorageModeExitHandler(){

        @Override
        public void leave() {
            StorageGuard.this.leave(false);
        }
    };

    StorageGuard() {
    }

    @NotNull
    synchronized StorageModeExitHandler enter(boolean mode) {
        if (mode) {
            while (this.myHolds < 0) {
                this.doWait();
            }
            ++this.myHolds;
            return this.myTrueStorageModeExitHandler;
        }
        while (this.myHolds > 0) {
            this.doWait();
        }
        --this.myHolds;
        return this.myFalseStorageModeExitHandler;
    }

    private void doWait() {
        try {
            ++this.myWaiters;
            this.wait();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            --this.myWaiters;
        }
    }

    private synchronized void leave(boolean mode) {
        this.myHolds += mode ? -1 : 1;
        if (this.myHolds == 0 && this.myWaiters > 0) {
            this.notifyAll();
        }
    }

    public static interface StorageModeExitHandler {
        public void leave();
    }
}

