/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Computable;
import com.intellij.util.indexing.StorageGuard;
import com.intellij.util.indexing.UpdatableIndex;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

abstract class StorageBufferingHandler {
    private final StorageGuard myStorageLock = new StorageGuard();
    private volatile boolean myPreviousDataBufferingState;
    private final Object myBufferingStateUpdateLock = new Object();

    StorageBufferingHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runUpdate(boolean transientInMemoryIndices, @NotNull Computable<Boolean> update2) {
        StorageGuard.StorageModeExitHandler storageModeExitHandler = this.myStorageLock.enter(transientInMemoryIndices);
        if (this.myPreviousDataBufferingState != transientInMemoryIndices) {
            Object object = this.myBufferingStateUpdateLock;
            synchronized (object) {
                if (this.myPreviousDataBufferingState != transientInMemoryIndices) {
                    this.getIndexes().forEach(index -> {
                        assert (index != null);
                        index.setBufferingEnabled(transientInMemoryIndices);
                    });
                    this.myPreviousDataBufferingState = transientInMemoryIndices;
                }
            }
        }
        try {
            boolean bl = (Boolean)update2.compute();
            return bl;
        }
        finally {
            storageModeExitHandler.leave();
        }
    }

    void resetState() {
        this.myPreviousDataBufferingState = false;
    }

    @NotNull
    protected abstract Stream<UpdatableIndex<?, ?, ?>> getIndexes();
}

