/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class MapDataExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> myKeysExternalizer;

    public MapDataExternalizer(@NotNull DataExternalizer<Value> valueExternalizer, @NotNull DataExternalizer<Collection<Key>> keysExternalizer) {
        this.myValueExternalizer = valueExternalizer;
        this.myKeysExternalizer = keysExternalizer;
    }

    public void save(@NotNull DataOutput stream, Map<Key, Value> data2) throws IOException {
        int size = data2.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
        if (size > 0) {
            THashMap values2 = new THashMap();
            List keysForNullValue = null;
            for (Map.Entry<Key, Value> e : data2.entrySet()) {
                List keys2;
                Value value2 = e.getValue();
                List list2 = keys2 = value2 != null ? (List)values2.get(value2) : keysForNullValue;
                if (keys2 == null) {
                    if (value2 != null) {
                        keys2 = new SmartList();
                        values2.put(value2, (Object)keys2);
                    } else {
                        keys2 = keysForNullValue = new SmartList();
                    }
                }
                keys2.add(e.getKey());
            }
            if (keysForNullValue != null) {
                this.myValueExternalizer.save(stream, null);
                this.myKeysExternalizer.save(stream, keysForNullValue);
            }
            for (Map.Entry<Object, Object> value3 : values2.keySet()) {
                this.myValueExternalizer.save(stream, value3);
                this.myKeysExternalizer.save(stream, values2.get(value3));
            }
        }
    }

    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs = DataInputOutputUtil.readINT((DataInput)in);
        if (pairs == 0) {
            return Collections.emptyMap();
        }
        THashMap result2 = new THashMap(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Object value2 = this.myValueExternalizer.read(in);
            Collection keys2 = (Collection)this.myKeysExternalizer.read(in);
            for (Object k : keys2) {
                result2.put(k, value2);
            }
        }
        return result2;
    }
}

