/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingStamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IndexVersionRegistrationSink {
    private final Map<ID<?, ?>, IndexingStamp.IndexVersionDiff> indexVersionDiffs = new ConcurrentHashMap();

    public boolean hasChangedIndexes() {
        return ContainerUtil.find(this.indexVersionDiffs.values(), diff -> IndexVersionRegistrationSink.isRebuildRequired(diff)) != null;
    }

    @NotNull
    public String changedIndices() {
        return this.buildString((Predicate<IndexingStamp.IndexVersionDiff>)((Predicate)diff -> IndexVersionRegistrationSink.isRebuildRequired(diff)));
    }

    public void logChangedAndFullyBuiltIndices(@NotNull Logger log, @NotNull String changedIndicesLogMessage, @NotNull String fullyBuiltIndicesLogMessage) {
        String fullyBuiltIndices;
        String changedIndices = this.changedIndices();
        if (!changedIndices.isEmpty()) {
            log.info(changedIndicesLogMessage + changedIndices);
        }
        if (!(fullyBuiltIndices = this.initiallyBuiltIndices()).isEmpty()) {
            log.info(fullyBuiltIndicesLogMessage + fullyBuiltIndices);
        }
    }

    @NotNull
    private String buildString(@NotNull Predicate<IndexingStamp.IndexVersionDiff> condition) {
        return this.indexVersionDiffs.entrySet().stream().filter(e -> condition.apply(e.getValue())).map(e -> ((ID)e.getKey()).getName() + ((IndexingStamp.IndexVersionDiff)e.getValue()).getLogText()).collect(Collectors.joining(","));
    }

    private String initiallyBuiltIndices() {
        return this.buildString((Predicate<IndexingStamp.IndexVersionDiff>)((Predicate)diff -> diff instanceof IndexingStamp.IndexVersionDiff.InitialBuild));
    }

    public <K, V> void setIndexVersionDiff(@NotNull ID<K, V> name, @NotNull IndexingStamp.IndexVersionDiff diff) {
        this.indexVersionDiffs.put(name, diff);
    }

    private static boolean isRebuildRequired(@NotNull IndexingStamp.IndexVersionDiff diff) {
        return diff instanceof IndexingStamp.IndexVersionDiff.CorruptedRebuild || diff instanceof IndexingStamp.IndexVersionDiff.VersionChanged;
    }
}

