/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import org.jetbrains.annotations.NotNull;

public final class FileBasedIndexSwitcher {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexSwitcher.class);
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final Semaphore myDumbModeSemaphore = new Semaphore();
    private int myNestedLevelCount = 0;

    public FileBasedIndexSwitcher() {
        this((FileBasedIndexImpl)FileBasedIndex.getInstance());
    }

    public FileBasedIndexSwitcher(@NotNull FileBasedIndexImpl index) {
        this.myFileBasedIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnOff() {
        Application app = ApplicationManager.getApplication();
        LOG.assertTrue(app.isDispatchThread());
        LOG.assertTrue(!app.isWriteAccessAllowed());
        try {
            if (this.myNestedLevelCount == 0) {
                boolean unitTestMode = app.isUnitTestMode();
                if (!unitTestMode) {
                    boolean wasUp = this.myDumbModeSemaphore.isUp();
                    this.myDumbModeSemaphore.down();
                    if (wasUp) {
                        for (Project project : ProjectUtil.getOpenProjects()) {
                            DumbService dumbService = DumbService.getInstance((Project)project);
                            dumbService.cancelAllTasksAndWait();
                            dumbService.queueTask(new DumbModeTask(this.myDumbModeSemaphore){

                                public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                                    indicator.setText(IndexingBundle.message((String)"indexes.reloading", (Object[])new Object[0]));
                                    FileBasedIndexSwitcher.this.myDumbModeSemaphore.waitFor();
                                }

                                public String toString() {
                                    return "Plugin loading/unloading";
                                }
                            });
                        }
                    }
                }
                this.myFileBasedIndex.performShutdown(true);
                this.myFileBasedIndex.dropRegisteredIndexes();
                IndexingStamp.flushCaches();
            }
        }
        finally {
            ++this.myNestedLevelCount;
        }
    }

    public void turnOn() {
        this.turnOn(() -> {});
    }

    public void turnOn(@NotNull Runnable beforeIndexTasksStarted) {
        LOG.assertTrue(ApplicationManager.getApplication().isWriteThread());
        --this.myNestedLevelCount;
        if (this.myNestedLevelCount == 0) {
            RebuildStatus.reset();
            this.myFileBasedIndex.initComponent();
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (unitTestMode) {
                this.myFileBasedIndex.waitUntilIndicesAreInitialized();
            }
            if (!unitTestMode) {
                this.myDumbModeSemaphore.up();
            }
            beforeIndexTasksStarted.run();
            FileBasedIndexImpl.cleanupProcessedFlag();
            for (Project project : ProjectUtil.getOpenProjects()) {
                DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
            }
        }
    }
}

