/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingStamp;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FileBasedIndexFileTypeListener
implements FileTypeListener {
    FileBasedIndexFileTypeListener() {
    }

    public void fileTypesChanged(@NotNull FileTypeEvent event) {
        THashSet indexesToRebuild = new THashSet();
        for (FileBasedIndexExtension extension : FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            if (IndexingStamp.versionDiffers(extension.getName(), FileBasedIndexImpl.getIndexExtensionVersion(extension)) == IndexingStamp.IndexVersionDiff.UP_TO_DATE) continue;
            indexesToRebuild.add(extension.getName());
        }
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        String rebuiltIndexesLog = indexesToRebuild.isEmpty() ? "" : "; indexes " + indexesToRebuild + " will be rebuild completely due to version change";
        fileBasedIndex.scheduleFullIndexesRescan((Collection<ID<?, ?>>)indexesToRebuild, "File type change" + rebuiltIndexesLog);
    }
}

