/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedFilesListener;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.VfsEventsMerger;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ChangedFilesCollector
extends IndexedFilesListener {
    private static final Logger LOG = Logger.getInstance(ChangedFilesCollector.class);
    private final IntObjectMap<VirtualFile> myFilesToUpdate = ContainerUtil.createConcurrentIntObjectMap();
    private final AtomicInteger myProcessedEventIndex = new AtomicInteger();
    private final Phaser myWorkersFinishedSync = new Phaser(){

        @Override
        protected boolean onAdvance(int phase, int registeredParties) {
            return false;
        }
    };
    private final Executor myVfsEventsExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FileBasedIndex Vfs Event Processor");
    private final AtomicInteger myScheduledVfsEventsWorkers = new AtomicInteger();
    private final FileBasedIndexImpl myManager = (FileBasedIndexImpl)FileBasedIndex.getInstance();
    private final AtomicInteger myUpdatingFiles = new AtomicInteger();

    @Override
    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        FileBasedIndexImpl.cleanProcessedFlag(file2);
        if (!contentChange) {
            this.myUpdatingFiles.incrementAndGet();
        }
        super.buildIndicesForFileRecursively(file2, contentChange);
        if (!contentChange && this.myUpdatingFiles.decrementAndGet() == 0) {
            this.myManager.incrementFilesModCount();
        }
    }

    @Override
    protected void iterateIndexableFiles(@NotNull VirtualFile file2, @NotNull ContentIterator iterator2) {
        for (IndexableFileSet set : this.myManager.getIndexableSets()) {
            if (!set.isInSet(file2)) continue;
            set.iterateIndexableFilesIn(file2, iterator2);
        }
    }

    boolean isUpdateInProgress() {
        return this.myUpdatingFiles.get() > 0;
    }

    void scheduleForUpdate(VirtualFile file2) {
        IndexableFileSet setForFile;
        if (!(file2 instanceof DeletedVirtualFileStub) && (setForFile = this.myManager.getIndexableSetForFile(file2)) == null) {
            return;
        }
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.put(fileId, (Object)file2);
        if (previousVirtualFile instanceof DeletedVirtualFileStub && !previousVirtualFile.equals(file2)) {
            assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
            ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(true);
            this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
        }
    }

    void removeScheduledFileFromUpdate(VirtualFile file2) {
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.remove(fileId);
        if (previousVirtualFile instanceof DeletedVirtualFileStub) {
            assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
            ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(false);
            this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
        }
    }

    void removeFileIdFromFilesScheduledForUpdate(int fileId) {
        this.myFilesToUpdate.remove(fileId);
    }

    public boolean containsFileId(int fileId) {
        return this.myFilesToUpdate.containsKey(fileId);
    }

    Stream<VirtualFile> getFilesToUpdate() {
        return this.myFilesToUpdate.values().stream();
    }

    Collection<VirtualFile> getAllFilesToUpdate() {
        this.ensureUpToDate();
        if (this.myFilesToUpdate.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
    }

    Collection<VirtualFile> getAllPossibleFilesToUpdate() {
        ReadAction.run(() -> this.processFilesInReadAction(info -> {
            this.myFilesToUpdate.put(info.getFileId(), (Object)(info.isFileRemoved() ? new DeletedVirtualFileStub((VirtualFileWithId)info.getFile()) : info.getFile()));
            return true;
        }));
        return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
    }

    void clearFilesToUpdate() {
        this.myFilesToUpdate.clear();
    }

    @Override
    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        final boolean shouldCleanup = ContainerUtil.exists(events, ChangedFilesCollector::memoryStorageCleaningNeeded);
        final AsyncFileListener.ChangeApplier superApplier = super.prepareChange(events);
        return new AsyncFileListener.ChangeApplier(){

            public void beforeVfsChange() {
                if (shouldCleanup) {
                    ChangedFilesCollector.this.myManager.cleanupMemoryStorage(false);
                }
                superApplier.beforeVfsChange();
            }

            public void afterVfsChange() {
                superApplier.afterVfsChange();
                RegisteredIndexes registeredIndexes = ChangedFilesCollector.this.myManager.getRegisteredIndexes();
                if (registeredIndexes != null && registeredIndexes.isInitialized()) {
                    ChangedFilesCollector.this.ensureUpToDateAsync();
                }
            }
        };
    }

    private static boolean memoryStorageCleaningNeeded(@NotNull VFileEvent event) {
        Object requestor = event.getRequestor();
        return requestor instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
    }

    boolean isScheduledForUpdate(VirtualFile file2) {
        return this.myFilesToUpdate.containsKey(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)));
    }

    void ensureUpToDate() {
        if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) {
            return;
        }
        this.myManager.waitUntilIndicesAreInitialized();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            this.processFilesToUpdateInReadAction();
        } else {
            this.processFilesInReadActionWithYieldingToWriteAction();
        }
    }

    void ensureUpToDateAsync() {
        if (this.getEventMerger().getApproximateChangesCount() >= 20 && this.myScheduledVfsEventsWorkers.compareAndSet(0, 1)) {
            this.myVfsEventsExecutor.execute(() -> {
                try {
                    this.processFilesInReadActionWithYieldingToWriteAction();
                }
                finally {
                    this.myScheduledVfsEventsWorkers.decrementAndGet();
                }
            });
            if (Registry.is((String)"try.starting.dumb.mode.where.many.files.changed")) {
                Runnable startDumbMode = () -> {
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(project);
                        DumbModeTask task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project);
                        if (task2 == null) continue;
                        dumbService.queueTask(task2);
                    }
                };
                Application app = ApplicationManager.getApplication();
                if (!app.isHeadlessEnvironment() && app.isDispatchThread() && !LaterInvocator.isInModalContext()) {
                    startDumbMode.run();
                } else {
                    app.invokeLater(startDumbMode, ModalityState.NON_MODAL);
                }
            }
        }
    }

    private void processFilesToUpdateInReadAction() {
        this.processFilesInReadAction(info -> {
            int fileId = info.getFileId();
            VirtualFile file2 = info.getFile();
            if (info.isTransientStateChanged()) {
                this.myManager.doTransientStateChangeForFile(fileId, file2);
            }
            if (info.isBeforeContentChanged()) {
                this.myManager.doInvalidateIndicesForFile(fileId, file2, true);
            }
            if (info.isContentChanged()) {
                this.myManager.scheduleFileForIndexing(fileId, file2, true);
            }
            if (info.isFileRemoved()) {
                this.myManager.doInvalidateIndicesForFile(fileId, file2, false);
            }
            if (info.isFileAdded()) {
                this.myManager.scheduleFileForIndexing(fileId, file2, false);
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilesInReadAction(@NotNull VfsEventsMerger.VfsEventProcessor processor2) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        int publishedEventIndex = this.getEventMerger().getPublishedEventIndex();
        int processedEventIndex = this.myProcessedEventIndex.get();
        if (processedEventIndex == publishedEventIndex) {
            return;
        }
        this.myWorkersFinishedSync.register();
        int phase = this.myWorkersFinishedSync.getPhase();
        try {
            this.getEventMerger().processChanges(info -> (Boolean)ConcurrencyUtil.withLock((Lock)this.myManager.myWriteLock, () -> {
                try {
                    ProgressManager.getInstance().executeNonCancelableSection(() -> processor2.process(info));
                }
                finally {
                    IndexingStamp.flushCache(info.getFileId());
                }
                return true;
            }));
        }
        finally {
            this.myWorkersFinishedSync.arriveAndDeregister();
        }
        try {
            this.myWorkersFinishedSync.awaitAdvance(phase);
        }
        catch (RejectedExecutionException e) {
            LOG.warn((Throwable)e);
            throw new ProcessCanceledException((Throwable)e);
        }
        if (this.getEventMerger().getPublishedEventIndex() == publishedEventIndex) {
            this.myProcessedEventIndex.compareAndSet(processedEventIndex, publishedEventIndex);
        }
    }

    private void processFilesInReadActionWithYieldingToWriteAction() {
        while (this.getEventMerger().hasChanges()) {
            ReadAction.nonBlocking(() -> this.processFilesToUpdateInReadAction()).executeSynchronously();
        }
    }

    public void waitForVfsEventsExecuted(long timeout, @NotNull TimeUnit unit) throws Exception {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (System.nanoTime() < deadline) {
            try {
                ((BoundedTaskExecutor)this.myVfsEventsExecutor).waitAllTasksExecuted(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }
}

