/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.IndexableSetContributorModificationTracker;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    @Nullable
    private final Project myProject;
    private final boolean myOnlyProjectPart;
    private final Supplier<IndexableSetContributor[]> myExtensions;
    private final CachedValue<AdditionalIndexableRoots> myAdditionalIndexableRoots;

    public AdditionalIndexableFileSet(@Nullable Project project, IndexableSetContributor ... extensions2) {
        this.myProject = project;
        this.myOnlyProjectPart = false;
        this.myExtensions = () -> extensions2;
        this.myAdditionalIndexableRoots = new CachedValueImpl<AdditionalIndexableRoots>(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
    }

    public AdditionalIndexableFileSet(@Nullable Project project, boolean onlyProjectPart) {
        this.myProject = project;
        this.myExtensions = () -> (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions();
        this.myAdditionalIndexableRoots = new CachedValueImpl<AdditionalIndexableRoots>(() -> new CachedValueProvider.Result((Object)this.collectFilesAndDirectories(), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, IndexableSetContributorModificationTracker.getInstance()}));
        this.myOnlyProjectPart = onlyProjectPart;
    }

    public AdditionalIndexableFileSet(@Nullable Project project) {
        this(project, false);
    }

    public AdditionalIndexableFileSet() {
        this(null);
    }

    @NotNull
    private AdditionalIndexableRoots collectFilesAndDirectories() {
        THashSet files2 = new THashSet();
        THashSet directories = new THashSet();
        for (IndexableSetContributor contributor : this.myExtensions.get()) {
            if (this.myProject == null || !this.myOnlyProjectPart) {
                for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                    (root.isDirectory() ? directories : files2).add(root);
                }
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                (root.isDirectory() ? directories : files2).add(root);
            }
        }
        return new AdditionalIndexableRoots((Set)files2, (Set)directories);
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        AdditionalIndexableRoots additionalIndexableRoots = (AdditionalIndexableRoots)this.myAdditionalIndexableRoots.getValue();
        return VfsUtilCore.isUnder((VirtualFile)file2, (Set)additionalIndexableRoots.directories) || additionalIndexableRoots.files.contains(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (!AdditionalIndexableFileSet.this.isInSet(file2)) {
                    return false;
                }
                if (!file2.isDirectory()) {
                    iterator2.processFile(file2);
                }
                return true;
            }
        });
    }

    private static class AdditionalIndexableRoots {
        @NotNull
        private final Set<VirtualFile> files;
        @NotNull
        private final Set<VirtualFile> directories;

        private AdditionalIndexableRoots(@NotNull Set<VirtualFile> files2, @NotNull Set<VirtualFile> directories) {
            this.files = files2;
            this.directories = directories;
        }
    }
}

