/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.GraphEdge;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

public class KShortestPathsFinder<Node> {
    private static final Logger LOG = Logger.getInstance(KShortestPathsFinder.class);
    private final InboundSemiGraph<Node> myGraph;
    private final Node myStart;
    private final Node myFinish;
    private final ProgressIndicator myProgressIndicator;
    private MultiMap<Node, GraphEdge<Node>> myNonTreeEdges;
    private List<Node> mySortedNodes;
    private Map<Node, Node> myNextNodes;
    private Map<Node, HeapNode<Node>> myOutRoots;
    private Map<Node, Heap<Node>> myHeaps;

    public KShortestPathsFinder(@NotNull Graph<Node> graph2, @NotNull Node start2, @NotNull Node finish, @NotNull ProgressIndicator progress2) {
        this((InboundSemiGraph<Node>)graph2, start2, finish, progress2);
    }

    public KShortestPathsFinder(@NotNull InboundSemiGraph<Node> graph2, @NotNull Node start2, @NotNull Node finish, @NotNull ProgressIndicator progress2) {
        this.myGraph = graph2;
        this.myStart = start2;
        this.myFinish = finish;
        this.myProgressIndicator = progress2;
    }

    private void computeDistancesToTarget() {
        this.myNonTreeEdges = new MultiMap();
        this.mySortedNodes = new ArrayList<Node>();
        this.myNextNodes = new HashMap<Node, Node>();
        TObjectIntHashMap distances = new TObjectIntHashMap();
        ArrayDeque<Object> nodes = new ArrayDeque<Object>();
        nodes.addLast(this.myFinish);
        distances.put(this.myFinish, 0);
        while (!nodes.isEmpty()) {
            this.myProgressIndicator.checkCanceled();
            Object node = nodes.removeFirst();
            this.mySortedNodes.add(node);
            int d = distances.get(node) + 1;
            Iterator iterator2 = this.myGraph.getIn(node);
            while (iterator2.hasNext()) {
                Object prev = iterator2.next();
                if (distances.containsKey(prev)) {
                    int dPrev = distances.get(prev);
                    this.myNonTreeEdges.putValue(prev, new GraphEdge(prev, node, d - dPrev));
                    continue;
                }
                distances.put(prev, d);
                this.myNextNodes.put(prev, node);
                nodes.addLast(prev);
            }
        }
    }

    private void buildOutHeaps() {
        this.myOutRoots = new HashMap<Node, HeapNode<Node>>();
        for (Node node : this.mySortedNodes) {
            int j;
            this.myProgressIndicator.checkCanceled();
            ArrayList heapNodes = new ArrayList();
            Collection edges = this.myNonTreeEdges.get(node);
            if (edges.isEmpty()) continue;
            HeapNode root = null;
            for (GraphEdge edge : edges) {
                HeapNode heapNode = new HeapNode(edge);
                heapNodes.add(heapNode);
                if (root != null && root.myEdge.getDelta() <= heapNode.myEdge.getDelta()) continue;
                root = heapNode;
            }
            LOG.assertTrue(root != null);
            heapNodes.remove(root);
            this.myOutRoots.put(node, root);
            if (heapNodes.isEmpty()) continue;
            for (j = 1; j < heapNodes.size(); ++j) {
                HeapNode heapNode = (HeapNode)heapNodes.get(j);
                HeapNode parent = (HeapNode)heapNodes.get((j + 1) / 2 - 1);
                parent.myChildren[(j + 1) % 2] = heapNode;
            }
            for (j = heapNodes.size() / 2 - 1; j >= 0; --j) {
                this.heapify((HeapNode)heapNodes.get(j));
            }
            root.myChildren[2] = (HeapNode)heapNodes.get(0);
        }
    }

    private void buildMainHeaps() {
        this.myHeaps = new HashMap<Node, Heap<Node>>();
        for (Node node : this.mySortedNodes) {
            this.myProgressIndicator.checkCanceled();
            HeapNode<Node> outRoot = this.myOutRoots.get(node);
            Node next = this.myNextNodes.get(node);
            if (outRoot == null) {
                if (next == null) continue;
                this.myHeaps.put(node, this.myHeaps.get(next));
                continue;
            }
            Heap<Node> nextHeap = this.myHeaps.get(next);
            if (nextHeap == null) {
                this.myHeaps.put(node, new Heap<Node>(outRoot));
                continue;
            }
            Heap<Node> tHeap = nextHeap.insert(outRoot);
            this.myHeaps.put(node, tHeap);
        }
    }

    private void heapify(HeapNode<Node> node) {
        while (true) {
            HeapNode<Node> min = node;
            for (int i2 = 0; i2 < 2; ++i2) {
                HeapNode child2 = node.myChildren[i2];
                if (child2 == null || child2.myEdge.getDelta() >= min.myEdge.getDelta()) continue;
                min = child2;
            }
            if (min == node) break;
            GraphEdge t = min.myEdge;
            min.myEdge = node.myEdge;
            node.myEdge = t;
            node = min;
        }
    }

    public List<List<Node>> findShortestPaths(int k) {
        try {
            if (this.myStart.equals(this.myFinish)) {
                return Collections.singletonList(Collections.singletonList(this.myStart));
            }
            this.computeDistancesToTarget();
            if (!this.myNextNodes.containsKey(this.myStart)) {
                return Collections.emptyList();
            }
            this.buildOutHeaps();
            this.buildMainHeaps();
            PriorityQueue queue = new PriorityQueue();
            ArrayList<FList<HeapNode<Node>>> sidetracks = new ArrayList<FList<HeapNode<Node>>>();
            sidetracks.add(FList.emptyList());
            Heap<Node> heap = this.myHeaps.get(this.myStart);
            if (heap != null) {
                queue.add(new Sidetracks(0, FList.emptyList().prepend(heap.getRoot())));
                for (int i2 = 2; i2 <= k && !queue.isEmpty(); ++i2) {
                    this.myProgressIndicator.checkCanceled();
                    Sidetracks current2 = (Sidetracks)queue.remove();
                    sidetracks.add(current2.myEdges);
                    HeapNode e = (HeapNode)current2.myEdges.getHead();
                    Heap<Node> next = this.myHeaps.get(e.myEdge.getFinish());
                    if (next != null) {
                        HeapNode<Node> f = next.getRoot();
                        queue.add(new Sidetracks(current2.myLength + f.myEdge.getDelta(), current2.myEdges.prepend(f)));
                    }
                    for (HeapNode child2 : e.myChildren) {
                        if (child2 == null) continue;
                        queue.add(new Sidetracks(current2.myLength - e.myEdge.getDelta() + child2.myEdge.getDelta(), current2.myEdges.getTail().prepend(child2)));
                    }
                }
            }
            return this.computePathsBySidetracks(sidetracks);
        }
        catch (ProcessCanceledException e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<List<Node>> computePathsBySidetracks(List<FList<HeapNode<Node>>> sidetracks) {
        ArrayList<List<Node>> result2 = new ArrayList<List<Node>>();
        for (FList<HeapNode<Node>> fList : sidetracks) {
            void var4_4;
            this.myProgressIndicator.checkCanceled();
            ArrayList edges = new ArrayList();
            while (!var4_4.isEmpty()) {
                edges.add(((HeapNode)var4_4.getHead()).myEdge);
                FList fList2 = var4_4.getTail();
            }
            Node current2 = this.myStart;
            ArrayList<Node> path = new ArrayList<Node>();
            path.add(current2);
            int i2 = edges.size() - 1;
            while (!current2.equals(this.myFinish) || i2 >= 0) {
                if (i2 >= 0 && ((GraphEdge)edges.get(i2)).getStart().equals(current2)) {
                    current2 = ((GraphEdge)edges.get(i2)).getFinish();
                    --i2;
                } else {
                    LOG.assertTrue((current2 = this.myNextNodes.get(current2)) != null);
                }
                path.add(current2);
            }
            result2.add(path);
        }
        return result2;
    }

    private static class HeapNode<Node> {
        public HeapNode<Node>[] myChildren;
        public GraphEdge<Node> myEdge;

        private HeapNode(GraphEdge<Node> edge) {
            this.myEdge = edge;
            this.myChildren = new HeapNode[3];
        }

        HeapNode(HeapNode<Node> node) {
            this.myEdge = node.myEdge;
            this.myChildren = (HeapNode[])node.myChildren.clone();
        }

        public HeapNode<Node> copy() {
            return new HeapNode<Node>(this);
        }
    }

    private static class Heap<Node> {
        private final int mySize;
        private final HeapNode<Node> myRoot;

        Heap(HeapNode<Node> root) {
            this.myRoot = root;
            this.mySize = 1;
        }

        private Heap(int size, HeapNode<Node> root) {
            this.mySize = size;
            this.myRoot = root;
        }

        public HeapNode<Node> getRoot() {
            return this.myRoot;
        }

        public Heap<Node> insert(HeapNode<Node> node) {
            HeapNode<Node> newRoot;
            int pos = this.mySize + 1;
            int pow = 1;
            while (pos >= pow << 2) {
                pow <<= 1;
            }
            HeapNode<Node> place = newRoot = this.myRoot.copy();
            ArrayList<HeapNode<Node>> parents2 = new ArrayList<HeapNode<Node>>();
            while (true) {
                int ind;
                parents2.add(place);
                int n = ind = (pos & pow) != 0 ? 1 : 0;
                if (pow == 1) break;
                HeapNode copy2 = place.myChildren[ind].copy();
                place.myChildren[ind] = copy2;
                place = copy2;
                pow >>= 1;
            }
            place.myChildren[ind] = node;
            for (int i2 = parents2.size() - 1; i2 >= 0; --i2) {
                HeapNode parent = (HeapNode)parents2.get(i2);
                if (parent.myEdge.getDelta() < node.myEdge.getDelta()) break;
                GraphEdge t = parent.myEdge;
                parent.myEdge = node.myEdge;
                node.myEdge = t;
                HeapNode t2 = parent.myChildren[2];
                parent.myChildren[2] = node.myChildren[2];
                node.myChildren[2] = t2;
                node = parent;
            }
            return new Heap<Node>(this.mySize + 1, newRoot);
        }
    }

    private static class Sidetracks<Node>
    implements Comparable<Sidetracks> {
        private final int myLength;
        private final FList<HeapNode<Node>> myEdges;

        private Sidetracks(int length, FList<HeapNode<Node>> edges) {
            this.myLength = length;
            this.myEdges = edges;
        }

        @Override
        public int compareTo(Sidetracks o) {
            return this.myLength - o.myLength;
        }
    }
}

