/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.download.impl.DownloadableFileDescriptionImpl;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.download.impl.FileDownloaderImpl;
import com.intellij.util.download.impl.FileSetVersionsFetcherBase;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DownloadableFileServiceImpl
extends DownloadableFileService {
    DownloadableFileServiceImpl() {
    }

    @NotNull
    public DownloadableFileDescription createFileDescription(@NotNull String downloadUrl, @NotNull String fileName) {
        return new DownloadableFileDescriptionImpl(downloadUrl, FileUtilRt.getNameWithoutExtension((String)fileName), FileUtilRt.getExtension((String)fileName));
    }

    @NotNull
    public DownloadableFileSetVersions<DownloadableFileSetDescription> createFileSetVersions(@Nullable String groupId2, URL ... localUrls) {
        return new FileSetVersionsFetcherBase<DownloadableFileSetDescription, DownloadableFileDescription>(groupId2, localUrls){

            @Override
            protected DownloadableFileSetDescription createVersion(Artifact version2, List<DownloadableFileDescription> files2) {
                return new DownloadableFileSetDescriptionImpl<DownloadableFileDescription>(version2.getName(), version2.getVersion(), files2);
            }

            @Override
            protected DownloadableFileDescription createFileDescription(ArtifactItem item, String url, String prefix) {
                return DownloadableFileService.getInstance().createFileDescription(url, item.getName());
            }
        };
    }

    @NotNull
    public FileDownloader createDownloader(@NotNull DownloadableFileSetDescription description) {
        return this.createDownloader(description.getFiles(), description.getName());
    }

    @NotNull
    public FileDownloader createDownloader(@NotNull List<? extends DownloadableFileDescription> fileDescriptions, @NotNull String presentableDownloadName) {
        return new FileDownloaderImpl(fileDescriptions, null, null, presentableDownloadName);
    }

    @NotNull
    public FileDownloader createDownloader(@NotNull DownloadableFileSetDescription description, @Nullable Project project, JComponent parent) {
        return this.createDownloader(description.getFiles(), project, parent, description.getName());
    }

    @NotNull
    public FileDownloader createDownloader(List<? extends DownloadableFileDescription> fileDescriptions, @Nullable Project project, JComponent parent, @NotNull String presentableDownloadName) {
        return new FileDownloaderImpl(fileDescriptions, project, parent, presentableDownloadName);
    }
}

