/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.awt.EventQueue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

public abstract class Invoker
implements Disposable {
    private static final int THRESHOLD = Integer.MAX_VALUE;
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final Map<AsyncPromise<?>, ProgressIndicatorBase> indicators = new ConcurrentHashMap();
    private final AtomicInteger count = new AtomicInteger();
    private final ThreeState useReadAction;
    private final String description;
    private volatile boolean disposed;

    private Invoker(@NotNull String prefix, @NotNull Disposable parent, @NotNull ThreeState useReadAction) {
        this.description = "Invoker." + UID.getAndIncrement() + "." + prefix + (useReadAction != ThreeState.UNSURE ? ".ReadAction=" + useReadAction : "") + ": " + parent;
        this.useReadAction = useReadAction;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
        while (!this.indicators.isEmpty()) {
            this.indicators.keySet().forEach(AsyncPromise::cancel);
        }
    }

    public boolean isValidThread() {
        if (this.useReadAction != ThreeState.NO) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        return application == null || !application.isReadAccessAllowed();
    }

    @NotNull
    public final <T> CancellablePromise<T> compute(@NotNull Supplier<? extends T> task2) {
        return this.promise(new Task<T>(task2));
    }

    @NotNull
    public final <T> CancellablePromise<T> computeLater(@NotNull Supplier<? extends T> task2) {
        return this.computeLater(task2, 0);
    }

    @NotNull
    public final <T> CancellablePromise<T> computeLater(@NotNull Supplier<? extends T> task2, int delay) {
        return this.promise(new Task<T>(task2), delay);
    }

    @NotNull
    public final CancellablePromise<?> invoke(@NotNull Runnable task2) {
        return this.compute(new Wrapper(task2));
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task2) {
        return this.invokeLater(task2, 0);
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task2, int delay) {
        return this.computeLater(new Wrapper(task2), delay);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public final CancellablePromise<?> runOrInvokeLater(@NotNull Runnable task2) {
        return this.invoke(task2);
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(@NotNull Runnable var1, int var2);

    private void offerSafely(@NotNull Task<?> task2, int attempt, int delay) {
        try {
            this.count.incrementAndGet();
            this.offer(() -> this.invokeSafely(task2, attempt), delay);
        }
        catch (RejectedExecutionException exception) {
            this.count.decrementAndGet();
            LOG.debug("Executor is shutdown");
            task2.promise.setError("shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSafely(@NotNull Task<?> task2, int attempt) {
        try {
            if (task2.canInvoke(this.disposed)) {
                if (ApplicationManager.getApplication() == null) {
                    task2.run();
                } else if (this.useReadAction != ThreeState.YES || EventQueue.isDispatchThread()) {
                    ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)this.indicator(task2.promise));
                } else if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(task2, this.indicator(task2.promise))) {
                    this.offerRestart(task2, attempt);
                    return;
                }
                task2.setResult();
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            this.offerRestart(task2, attempt);
        }
        catch (Throwable throwable) {
            try {
                LOG.error(throwable);
            }
            finally {
                task2.promise.setError(throwable);
            }
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    private void offerRestart(@NotNull Task<?> task2, int attempt) {
        if (task2.canRestart(this.disposed, attempt)) {
            this.offerSafely(task2, attempt + 1, 10);
            LOG.debug("Task is restarted");
        }
    }

    @NotNull
    private <T> CancellablePromise<T> promise(@NotNull Task<T> task2) {
        if (!this.isValidThread()) {
            return this.promise(task2, 0);
        }
        this.count.incrementAndGet();
        this.invokeSafely(task2, 0);
        return task2.promise;
    }

    @NotNull
    private <T> CancellablePromise<T> promise(@NotNull Task<T> task2, int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay must be non-negative: " + delay);
        }
        if (task2.canInvoke(this.disposed)) {
            this.offerSafely(task2, 0, delay);
        }
        return task2.promise;
    }

    @NotNull
    private ProgressIndicatorBase indicator(@NotNull AsyncPromise<?> promise) {
        ProgressIndicatorBase indicator = this.indicators.get(promise);
        if (indicator == null) {
            indicator = new ProgressIndicatorBase(true, false);
            ProgressIndicatorBase old = this.indicators.put(promise, indicator);
            if (old != null) {
                LOG.error("the same task is running in parallel");
            }
            promise.onProcessed(done -> this.indicators.remove(promise).cancel());
        }
        return indicator;
    }

    private static void schedule(ScheduledExecutorService executor, Runnable runnable2, int delay) {
        if (delay > 0) {
            executor.schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            executor.execute(runnable2);
        }
    }

    @NotNull
    public static Invoker forEventDispatchThread(@NotNull Disposable parent) {
        return new EDT(parent);
    }

    @NotNull
    public static Invoker forBackgroundPoolWithReadAction(@NotNull Disposable parent) {
        return new Background(parent, ThreeState.YES, 8);
    }

    @NotNull
    public static Invoker forBackgroundThreadWithReadAction(@NotNull Disposable parent) {
        return new Background(parent, ThreeState.YES, 1);
    }

    @NotNull
    public static Invoker forBackgroundThreadWithoutReadAction(@NotNull Disposable parent) {
        return new Background(parent, ThreeState.NO, 1);
    }

    public static final class Background
    extends Invoker {
        private final Set<Thread> threads = ContainerUtil.newConcurrentSet();
        private final ScheduledExecutorService executor;

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent) {
            this(parent, true);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, int maxThreads) {
            this(parent, ThreeState.YES, maxThreads);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, boolean useReadAction) {
            this(parent, ThreeState.fromBoolean((boolean)useReadAction));
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, @NotNull ThreeState useReadAction) {
            this(parent, useReadAction, 1);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, @NotNull ThreeState useReadAction, int maxThreads) {
            super(maxThreads != 1 ? "Pool(" + maxThreads + ")" : "Thread", parent, useReadAction);
            this.executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)maxThreads);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.threads.contains(Thread.currentThread()) && super.isValidThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            Invoker.schedule(this.executor, () -> {
                Thread thread = Thread.currentThread();
                if (!this.threads.add(thread)) {
                    LOG.error("current thread is already used");
                } else {
                    try {
                        runnable2.run();
                    }
                    finally {
                        if (!this.threads.remove(thread)) {
                            LOG.error("current thread is already removed");
                        }
                    }
                }
            }, delay);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static final class BackgroundThread
    extends Invoker {
        private final ScheduledExecutorService executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)1);
        private volatile Thread thread;

        public BackgroundThread(@NotNull Disposable parent) {
            super("Background.Thread", parent, ThreeState.YES);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.thread == Thread.currentThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            Invoker.schedule(this.executor, () -> {
                if (this.thread != null) {
                    LOG.error("unexpected thread: " + this.thread);
                }
                try {
                    this.thread = Thread.currentThread();
                    runnable2.run();
                }
                finally {
                    this.thread = null;
                }
            }, delay);
        }
    }

    public static final class EDT
    extends Invoker {
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public EDT(@NotNull Disposable parent) {
            super("EDT", parent, ThreeState.UNSURE);
        }

        @Override
        public boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (delay > 0) {
                EdtExecutorService.getScheduledExecutorInstance().schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                EdtExecutorService.getInstance().execute(runnable2);
            }
        }
    }

    private static final class Wrapper
    implements Obsolescent,
    Supplier<Void> {
        private final Runnable task;

        Wrapper(@NotNull Runnable task2) {
            this.task = task2;
        }

        @Override
        public Void get() {
            this.task.run();
            return null;
        }

        public boolean isObsolete() {
            return this.task instanceof Obsolescent && ((Obsolescent)this.task).isObsolete();
        }

        public String toString() {
            return this.task.toString();
        }
    }

    static final class Task<T>
    implements Runnable {
        final AsyncPromise<T> promise = new AsyncPromise();
        private final Supplier<? extends T> supplier;
        private volatile T result;

        Task(@NotNull Supplier<? extends T> supplier2) {
            this.supplier = supplier2;
        }

        boolean canRestart(boolean disposed, int attempt) {
            LOG.debug("Task is canceled");
            if (attempt < Integer.MAX_VALUE) {
                return this.canInvoke(disposed);
            }
            LOG.warn("Task is always canceled: " + this.supplier);
            this.promise.setError("timeout");
            return false;
        }

        boolean canInvoke(boolean disposed) {
            Obsolescent obsolescent;
            if (this.promise.isDone()) {
                LOG.debug("Promise is cancelled: ", new Object[]{this.promise.isCancelled()});
                return false;
            }
            if (disposed) {
                LOG.debug("Invoker is disposed");
                this.promise.setError("disposed");
                return false;
            }
            if (this.supplier instanceof Obsolescent && (obsolescent = (Obsolescent)this.supplier).isObsolete()) {
                LOG.debug("Task is obsolete");
                this.promise.setError("obsolete");
                return false;
            }
            return true;
        }

        void setResult() {
            this.promise.setResult(this.result);
        }

        @Override
        public void run() {
            this.result = this.supplier.get();
        }

        public String toString() {
            return "Invoker.Task: " + this.supplier;
        }
    }
}

