/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.Consumer;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldCompletionProvider
implements TextCompletionProvider {
    protected boolean myCaseInsensitivity;

    protected TextFieldCompletionProvider() {
        this(false);
    }

    protected TextFieldCompletionProvider(boolean caseInsensitivity) {
        this.myCaseInsensitivity = caseInsensitivity;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text, int offset) {
        return this.getPrefix(text.substring(0, offset));
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        CompletionResultSet activeResult = result2;
        if (!activeResult.getPrefixMatcher().getPrefix().equals(prefix)) {
            activeResult = activeResult.withPrefixMatcher(prefix);
        }
        if (this.isCaseInsensitivity()) {
            activeResult = activeResult.caseInsensitive();
        }
        return activeResult;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        this.addCompletionVariants(parameters2.getOriginalFile().getText(), parameters2.getOffset(), prefix, result2);
        result2.stopHere();
    }

    public void apply(@NotNull EditorTextField field, @NotNull String text) {
        Project project = field.getProject();
        if (project != null) {
            field.setDocument(this.createDocument(project, text));
        }
    }

    public void apply(@NotNull EditorTextField field) {
        this.apply(field, "");
    }

    private Document createDocument(Project project, @NotNull String text) {
        return LanguageTextField.createDocument(text, PlainTextLanguage.INSTANCE, project, new TextCompletionUtil.DocumentWithCompletionCreator(this, true));
    }

    public boolean isCaseInsensitivity() {
        return this.myCaseInsensitivity;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        return currentTextPrefix;
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return null;
    }

    protected abstract void addCompletionVariants(@NotNull String var1, int var2, @NotNull String var3, @NotNull CompletionResultSet var4);

    @NotNull
    public EditorTextField createEditor(Project project) {
        return this.createEditor(project, true, null);
    }

    @NotNull
    public EditorTextField createEditor(Project project, final boolean shouldHaveBorder, final @Nullable Consumer<Editor> editorConstructionCallback) {
        return new EditorTextField(this.createDocument(project, ""), project, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType()){

            @Override
            protected boolean shouldHaveBorder() {
                return shouldHaveBorder;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (shouldHaveBorder) {
                    super.updateBorder(editor);
                } else {
                    editor.setBorder(null);
                }
            }

            @Override
            protected EditorEx createEditor() {
                EditorEx result2 = super.createEditor();
                if (editorConstructionCallback != null) {
                    editorConstructionCallback.consume((Object)result2);
                }
                return result2;
            }
        };
    }
}

