/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PsiErrorElementUtil {
    private static final Key<CachedValue<Boolean>> CONTAINS_ERROR_ELEMENT = Key.create((String)"CONTAINS_ERROR_ELEMENT");

    private PsiErrorElementUtil() {
    }

    public static boolean hasErrors(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed() || !virtualFile.isValid()) {
                return false;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            return psiFile != null && PsiErrorElementUtil.hasErrors(psiFile);
        });
    }

    private static boolean hasErrors(@NotNull PsiFile psiFile) {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)psiFile.getProject());
        return (Boolean)cachedValuesManager.getCachedValue((UserDataHolder)psiFile, CONTAINS_ERROR_ELEMENT, () -> CachedValueProvider.Result.create((Object)PsiErrorElementUtil.hasErrorElements((PsiElement)psiFile), (Object[])new Object[]{psiFile}), false);
    }

    private static boolean hasErrorElements(@NotNull PsiElement element2) {
        List filters = null;
        for (PsiErrorElement error : SyntaxTraverser.psiTraverser((PsiElement)element2).traverse().filter(PsiErrorElement.class)) {
            if (filters == null) {
                filters = HighlightErrorFilter.EP_NAME.getExtensions((AreaInstance)element2.getProject());
            }
            if (!PsiErrorElementUtil.shouldHighlightErrorElement(error, filters)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldHighlightErrorElement(@NotNull PsiErrorElement error, @NotNull List<HighlightErrorFilter> filters) {
        for (HighlightErrorFilter filter2 : filters) {
            if (filter2.shouldHighlightErrorElement(error)) continue;
            return false;
        }
        return true;
    }
}

