/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IJSwingUtilities {
    public static boolean hasFocus(Component component2) {
        Component focusOwner = IJSwingUtilities.findFocusOwner(component2);
        return focusOwner != null;
    }

    private static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public static boolean hasFocus2(Component component2) {
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        Window activeWindow = null;
        if (windowManager != null) {
            activeWindow = windowManager.getMostRecentFocusedWindow();
        }
        if (activeWindow == null) {
            return false;
        }
        Component focusedComponent = windowManager.getFocusedComponent(activeWindow);
        if (focusedComponent == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(focusedComponent, component2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public static void adjustComponentsOnMac(@Nullable JLabel label2, @Nullable JComponent component2) {
    }

    public static HyperlinkEvent createHyperlinkEvent(@Nullable String href, @NotNull Object source) {
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new HyperlinkEvent(source, HyperlinkEvent.EventType.ACTIVATED, url, href);
    }

    public static void updateComponentTreeUI(@Nullable Component c) {
        JRootPane rootPane;
        if (c == null) {
            return;
        }
        if (c instanceof RootPaneContainer && (rootPane = ((RootPaneContainer)((Object)c)).getRootPane()) != null) {
            UIUtil.decorateWindowHeader((JRootPane)rootPane);
        }
        for (Component component2 : UIUtil.uiTraverser((Component)c).postOrderDfsTraversal()) {
            if (!(component2 instanceof JComponent)) continue;
            ((JComponent)component2).updateUI();
        }
        c.invalidate();
        c.validate();
        c.repaint();
    }

    public static void moveMousePointerOn(Component component2) {
        if (component2 != null && component2.isShowing() && Registry.is((String)"ide.settings.move.mouse.on.default.button", (boolean)false)) {
            Point point = component2.getLocationOnScreen();
            int dx = component2.getWidth() / 2;
            int dy = component2.getHeight() / 2;
            try {
                new Robot().mouseMove(point.x + dx, point.y + dy);
                component2.requestFocusInWindow();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
    }

    @ApiStatus.Internal
    public static void appendComponentClassNames(@NotNull StringBuilder sb, @Nullable Component root) {
        UIUtil.uiTraverser((Component)root).forEach(c -> IJSwingUtilities.appendComponentClassName(sb, root, c));
    }

    private static void appendComponentClassName(@NotNull StringBuilder sb, @Nullable Component root, @NotNull Component component2) {
        sb.append("\n    ");
        for (Component p = component2; root != p && p != null; p = p.getParent()) {
            sb.append("  ");
        }
        sb.append(component2.getClass().getName());
    }
}

