/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class DocumentUtil {
    private DocumentUtil() {
    }

    public static void executeInBulk(@NotNull Document document, boolean executeInBulk, @NotNull Runnable task2) {
        if (executeInBulk == document.isInBulkUpdate()) {
            task2.run();
            return;
        }
        document.setInBulkUpdate(executeInBulk);
        try {
            task2.run();
            document.setInBulkUpdate(!executeInBulk);
        }
        catch (Throwable throwable) {
            document.setInBulkUpdate(!executeInBulk);
            throw throwable;
        }
    }

    public static void writeInRunUndoTransparentAction(@NotNull Runnable runnable2) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(runnable2));
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int line) {
        int startOffset = document.getLineStartOffset(line);
        int endOffset = document.getLineEndOffset(line);
        return DocumentUtil.getFirstNonSpaceCharOffset(document, startOffset, endOffset);
    }

    public static int getFirstNonSpaceCharOffset(@NotNull Document document, int startOffset, int endOffset) {
        CharSequence text = document.getImmutableCharSequence();
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            char c = text.charAt(i2);
            if (c == ' ' || c == '\t') continue;
            return i2;
        }
        return startOffset;
    }

    public static boolean isValidOffset(int offset, @NotNull Document document) {
        return offset >= 0 && offset <= document.getTextLength();
    }

    public static int getLineStartOffset(int offset, @NotNull Document document) {
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineStartOffset(lineNumber);
    }

    public static int getLineEndOffset(int offset, @NotNull Document document) {
        if (offset < 0 || offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    @NotNull
    public static TextRange getLineTextRange(@NotNull Document document, int line) {
        return TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
    }

    public static boolean isAtLineStart(int offset, @NotNull Document document) {
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineStartOffset(document.getLineNumber(offset));
    }

    public static boolean isAtLineEnd(int offset, @NotNull Document document) {
        return offset >= 0 && offset <= document.getTextLength() && offset == document.getLineEndOffset(document.getLineNumber(offset));
    }

    public static int alignToCodePointBoundary(@NotNull Document document, int offset) {
        return DocumentUtil.isInsideSurrogatePair(document, offset) ? offset - 1 : offset;
    }

    public static boolean isSurrogatePair(@NotNull Document document, int offset) {
        CharSequence text = document.getImmutableCharSequence();
        return offset >= 0 && offset + 1 < text.length() && Character.isHighSurrogate(text.charAt(offset)) && Character.isLowSurrogate(text.charAt(offset + 1));
    }

    public static boolean isInsideSurrogatePair(@NotNull Document document, int offset) {
        return DocumentUtil.isSurrogatePair(document, offset - 1);
    }

    public static int getPreviousCodePointOffset(@NotNull Document document, int offset) {
        return offset - (DocumentUtil.isSurrogatePair(document, offset - 2) ? 2 : 1);
    }

    public static int getNextCodePointOffset(@NotNull Document document, int offset) {
        return offset + (DocumentUtil.isSurrogatePair(document, offset) ? 2 : 1);
    }

    public static boolean isInsideCharacterPair(@NotNull Document document, int offset) {
        if (offset <= 0 || offset >= document.getTextLength()) {
            return false;
        }
        CharSequence text = document.getImmutableCharSequence();
        char prev = text.charAt(offset - 1);
        return prev == '\r' ? text.charAt(offset) == '\n' : Character.isHighSurrogate(prev) && Character.isLowSurrogate(text.charAt(offset));
    }

    public static boolean isLineEmpty(@NotNull Document document, int line) {
        CharSequence chars = document.getCharsSequence();
        int start2 = document.getLineStartOffset(line);
        int end = Math.min(document.getLineEndOffset(line), document.getTextLength() - 1);
        for (int i2 = start2; i2 <= end; ++i2) {
            if (Character.isWhitespace(chars.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static CharSequence getIndent(@NotNull Document document, int offset) {
        int lineOffset = DocumentUtil.getLineStartOffset(offset, document);
        int result2 = 0;
        while (lineOffset + result2 < document.getTextLength() && Character.isWhitespace(document.getCharsSequence().charAt(lineOffset + result2))) {
            ++result2;
        }
        if (result2 + lineOffset > document.getTextLength()) {
            --result2;
        }
        return document.getCharsSequence().subSequence(lineOffset, lineOffset + Math.max(result2, 0));
    }
}

