/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.DebugReflectionUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class CachedValueLeakChecker {
    private static final Logger LOG = Logger.getInstance(CachedValueLeakChecker.class);
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    CachedValueLeakChecker() {
    }

    static void checkProvider(@NotNull CachedValueProvider<?> provider, @NotNull Key<?> key, @NotNull UserDataHolder userDataHolder) {
        if (!DO_CHECKS || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        CachedValueLeakChecker.findReferencedPsi(provider, key, userDataHolder);
    }

    private static synchronized void findReferencedPsi(@NotNull Object root, @NotNull Key<?> key, @NotNull UserDataHolder toIgnore) {
        Condition shouldExamineValue = value2 -> {
            if (value2 == toIgnore) {
                return false;
            }
            if (value2 instanceof ASTNode && (value2 = ((ASTNode)value2).getPsi()) == toIgnore) {
                return false;
            }
            if (value2 instanceof Project || value2 instanceof Module || value2 instanceof Application) {
                return false;
            }
            return !(value2 instanceof PsiElement) || !(toIgnore instanceof PsiElement) || ((PsiElement)toIgnore).getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value2), (PsiElement)((PsiElement)toIgnore), (boolean)true);
        };
        Map<Object, String> roots = Collections.singletonMap(root, "CachedValueProvider " + key);
        DebugReflectionUtil.walkObjects((int)5, roots, PsiElement.class, (Condition)shouldExamineValue, (value2, backLink) -> {
            if (value2 instanceof PsiElement) {
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + root + "\n" + backLink);
                return false;
            }
            return true;
        });
    }
}

