/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ProfilingInfo;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.NotNullList;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance(CachedValueImpl.class);
    private final boolean myTrackValue;
    private volatile SoftReference<Data<T>> myData;

    protected CachedValueBase(boolean trackValue) {
        this.myTrackValue = trackValue;
    }

    @NotNull
    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result2) {
        ProfilingInfo profilingInfo;
        if (result2 == null) {
            return new Data<Object>(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY, ArrayUtil.EMPTY_LONG_ARRAY);
        }
        Object value2 = result2.getValue();
        Object[] inferredDependencies = this.normalizeDependencies(result2);
        long[] inferredTimeStamps = new long[inferredDependencies.length];
        for (int i2 = 0; i2 < inferredDependencies.length; ++i2) {
            inferredTimeStamps[i2] = this.getTimeStamp(inferredDependencies[i2]);
        }
        if (CachedValueProfiler.canProfile() && (profilingInfo = CachedValueProfiler.getInstance().getTemporaryInfo(result2)) != null) {
            return new ProfilingData(value2, inferredDependencies, inferredTimeStamps, profilingInfo);
        }
        return new Data<Object>(value2, inferredDependencies, inferredTimeStamps);
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.setData(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data2) {
        this.myData = data2 == null ? null : new SoftReference(data2);
    }

    protected Object @NotNull [] normalizeDependencies(@NotNull CachedValueProvider.Result<T> result2) {
        Object[] items = result2.getDependencyItems();
        Object value2 = result2.getValue();
        Object[] rawDependencies = this.myTrackValue && value2 != null ? ArrayUtil.append((Object[])items, (Object)value2) : items;
        NotNullList flattened = new NotNullList(rawDependencies.length);
        CachedValueBase.collectDependencies((List<Object>)flattened, rawDependencies);
        return ArrayUtil.toObjectArray((Collection)flattened);
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data2 = this.getRawData();
        if (data2 != null) {
            if (this.isUpToDate(data2)) {
                return data2;
            }
            if (data2 instanceof ProfilingData) {
                ((ProfilingData)data2).myProfilingInfo.valueDisposed();
            }
        }
        return null;
    }

    @Nullable
    private Data<T> getRawData() {
        return (Data)SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data2) {
        for (int i2 = 0; i2 < data2.myDependencies.length; ++i2) {
            Object dependency = data2.myDependencies[i2];
            if (!this.isDependencyOutOfDate(dependency, data2.myTimeStamps[i2])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private static void collectDependencies(@NotNull List<Object> resultingDeps, Object @NotNull [] dependencies) {
        for (Object dependency : dependencies) {
            if (dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                CachedValueBase.collectDependencies(resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
        }
    }

    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency instanceof VirtualFile) {
            return ((VirtualFile)dependency).getModificationStamp();
        }
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(@NotNull CachedValueProvider.Result<T> result2) {
        Data<T> data2 = this.computeData(result2);
        this.setData(data2);
        return data2.getValue();
    }

    public abstract boolean isFromMyProject(@NotNull Project var1);

    public abstract Object getValueProvider();

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data2 = this.getUpToDateOrNull();
        if (data2 != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(data2, this.getValueProvider(), () -> this.computeData(this.doCompute(param)));
            }
            return data2.getValue();
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable calcData = () -> this.computeData(this.doCompute(param));
        data2 = (Data)RecursionManager.doPreventingRecursion((Object)this, (boolean)true, (Computable)calcData);
        if (data2 == null) {
            data2 = (Data)calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            do {
                boolean bl = reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed);
                if (!reuse) continue;
                IdempotenceChecker.checkEquivalence(alreadyComputed, data2, this.getValueProvider().getClass(), calcData);
            } while ((toReturn = this.cacheOrGetData(alreadyComputed, reuse ? null : data2)) == null);
            return toReturn.getValue();
        }
        return data2.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getValueProvider() + "}";
    }

    private static class ProfilingData<T>
    extends Data<T> {
        @NotNull
        private final ProfilingInfo myProfilingInfo;

        private ProfilingData(T value2, Object @NotNull [] dependencies, long @NotNull [] timeStamps, @NotNull ProfilingInfo profilingInfo) {
            super(value2, dependencies, timeStamps);
            this.myProfilingInfo = profilingInfo;
        }

        @Override
        public T getValue() {
            this.myProfilingInfo.valueUsed();
            return super.getValue();
        }
    }

    protected static class Data<T>
    implements Getter<T> {
        private final T myValue;
        private final Object @NotNull [] myDependencies;
        private final long @NotNull [] myTimeStamps;

        Data(T value2, Object @NotNull [] dependencies, long @NotNull [] timeStamps) {
            this.myValue = value2;
            this.myDependencies = dependencies;
            this.myTimeStamps = timeStamps;
        }

        public Object @NotNull [] getDependencies() {
            return this.myDependencies;
        }

        public long @NotNull [] getTimeStamps() {
            return this.myTimeStamps;
        }

        public final T get() {
            return this.getValue();
        }

        public T getValue() {
            return this.myValue;
        }
    }
}

