/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UsageViewContentManagerImpl
extends UsageViewContentManager {
    private final Key<Boolean> REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.REUSABLE_CONTENT_KEY");
    private final Key<Boolean> NOT_REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.NOT_REUSABLE_CONTENT_KEY");
    private final Key<UsageView> NEW_USAGE_VIEW_KEY = Key.create((String)"NEW_USAGE_VIEW_KEY");
    private final ContentManager myFindContentManager;

    public UsageViewContentManagerImpl(@NotNull Project project) {
        this(project, ToolWindowManager.getInstance((Project)project));
    }

    @NonInjectable
    public UsageViewContentManagerImpl(final @NotNull Project project, @NotNull ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable((String)"Find", (Icon)AllIcons.Toolwindows.ToolWindowFind));
        toolWindow.setHelpId("ideaInterface.find");
        toolWindow.setToHideOnEmptyContent(true);
        DumbAwareToggleAction toggleNewTabAction = new DumbAwareToggleAction(FindBundle.message("find.open.in.new.tab.action", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return FindSettings.getInstance().isShowResultsInSeparateView();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                FindSettings.getInstance().setShowResultsInSeparateView(state);
            }
        };
        DumbAwareToggleAction toggleSortAction = new DumbAwareToggleAction(UsageViewBundle.message((String)"sort.alphabetically.action.text", (Object[])new Object[0]), null, AllIcons.ObjectBrowser.Sorted){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return UsageViewSettings.getInstance().isSortAlphabetically();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                UsageViewSettings.getInstance().setSortAlphabetically(state);
                ((Runnable)project.getMessageBus().syncPublisher(UsageFilteringRuleProvider.RULES_CHANGED)).run();
            }
        };
        DumbAwareToggleAction toggleAutoscrollAction = new DumbAwareToggleAction(UIBundle.message((String)"autoscroll.to.source.action.name", (Object[])new Object[0]), UIBundle.message((String)"autoscroll.to.source.action.description", (Object[])new Object[0]), AllIcons.General.AutoscrollToSource){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return UsageViewSettings.getInstance().isAutoScrollToSource();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                UsageViewSettings.getInstance().setAutoScrollToSource(state);
            }
        };
        DefaultActionGroup gearActions = DefaultActionGroup.createPopupGroup((Supplier)IdeBundle.messagePointer((String)"group.view.options", (Object[])new Object[0]));
        gearActions.addAll(new AnAction[]{toggleAutoscrollAction, toggleSortAction, toggleNewTabAction});
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)gearActions);
        this.myFindContentManager = toolWindow.getContentManager();
        this.myFindContentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                event.getContent().release();
            }
        });
        ContentManagerWatcher.watchContentManager(toolWindow, this.myFindContentManager);
    }

    @NotNull
    public Content addContent(@NotNull String contentName, boolean reusable, @NotNull JComponent component2, boolean toOpenInNewTab, boolean isLockable) {
        return this.addContent(contentName, null, null, reusable, component2, toOpenInNewTab, isLockable);
    }

    @NotNull
    public Content addContent(@NotNull String contentName, String tabName, String toolwindowTitle, boolean reusable, @NotNull JComponent component2, boolean toOpenInNewTab, boolean isLockable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.getSelectedContent();
        boolean bl = selectedContent != null && selectedContent.isPinned();
        Content contentToDelete = null;
        int indexToAdd = -1;
        if (!(toOpenInNewTab |= bl) && reusable) {
            ArrayList contents = ContainerUtil.newArrayList((Object[])this.myFindContentManager.getContents());
            if (selectedContent != null) {
                contents.remove(selectedContent);
                contents.add(selectedContent);
            }
            for (Content content2 : contents) {
                UsageView usageView;
                if (content2.isPinned() || content2.getUserData(contentKey) == null || (usageView = (UsageView)content2.getUserData(this.NEW_USAGE_VIEW_KEY)) != null && usageView.isSearchInProgress()) continue;
                contentToDelete = content2;
                indexToAdd = this.myFindContentManager.getIndexOfContent(contentToDelete);
            }
        }
        Content content3 = ContentFactory.SERVICE.getInstance().createContent(component2, contentName, isLockable);
        content3.setTabName(tabName);
        content3.setToolwindowTitle(toolwindowTitle);
        content3.putUserData(contentKey, (Object)Boolean.TRUE);
        content3.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myFindContentManager.addContent(content3, indexToAdd);
        if (contentToDelete != null) {
            this.myFindContentManager.removeContent(contentToDelete, true);
        }
        this.myFindContentManager.setSelectedContent(content3);
        return content3;
    }

    public int getReusableContentsCount() {
        return this.getContentCount(true);
    }

    private int getContentCount(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content[] contents = this.myFindContentManager.getContents();
        return (int)Arrays.stream(contents).filter(content2 -> content2.getUserData(contentKey) != null).count();
    }

    public Content getSelectedContent(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.myFindContentManager.getSelectedContent();
        return selectedContent == null || selectedContent.getUserData(contentKey) == null ? null : selectedContent;
    }

    public Content getSelectedContent() {
        return this.myFindContentManager == null ? null : this.myFindContentManager.getSelectedContent();
    }

    public void closeContent(@NotNull Content content2) {
        this.myFindContentManager.removeContent(content2, true);
        content2.release();
    }
}

