/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ui.tree.ui.Control;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class DefaultControl
implements Control {
    private final Icon expandedDefault = UIUtil.getTreeExpandedIcon();
    private final Icon collapsedDefault = UIUtil.getTreeCollapsedIcon();
    private final Icon expandedSelected = UIUtil.getTreeSelectedExpandedIcon();
    private final Icon collapsedSelected = UIUtil.getTreeSelectedCollapsedIcon();

    @Override
    @NotNull
    public Icon getIcon(boolean expanded, boolean selected2) {
        return !selected2 ? (expanded ? this.expandedDefault : this.collapsedDefault) : (expanded ? this.expandedSelected : this.collapsedSelected);
    }

    @Override
    public int getWidth() {
        return Math.max(Math.max(this.expandedDefault.getIconWidth(), this.collapsedDefault.getIconWidth()), Math.max(this.expandedSelected.getIconWidth(), this.collapsedSelected.getIconWidth()));
    }

    @Override
    public int getHeight() {
        return Math.max(Math.max(this.expandedDefault.getIconHeight(), this.collapsedDefault.getIconHeight()), Math.max(this.expandedSelected.getIconHeight(), this.collapsedSelected.getIconHeight()));
    }

    @Override
    public void paint(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height, boolean expanded, boolean selected2) {
        Icon icon2 = this.getIcon(expanded, selected2);
        icon2.paintIcon(null, g, x + (width - icon2.getIconWidth()) / 2, y + (height - icon2.getIconHeight()) / 2);
    }
}

