/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TreePathUtil {
    @NotNull
    public static TreePath createTreePath(TreePath parent, @NotNull Object component2) {
        return parent != null ? parent.pathByAddingChild(component2) : new TreePath(component2);
    }

    public static String[] convertTreePathToStrings(@NotNull TreePath path) {
        return TreePathUtil.convertTreePathToArray(path, Object::toString, String.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path) {
        return TreePathUtil.convertTreePathToArray(path, object -> object, Object.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, Object> converter) {
        return TreePathUtil.convertTreePathToArray(path, converter, Object.class);
    }

    private static <T> T[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, ? extends T> converter, @NotNull Class<T> type) {
        int count = path.getPathCount();
        if (count <= 0) {
            return null;
        }
        Object[] array2 = ArrayUtil.newArray(type, (int)count);
        while (path != null && count > 0) {
            Object component2 = path.getLastPathComponent();
            if (component2 == null) {
                return null;
            }
            T object = TreePathUtil.convert(component2, converter);
            if (object == null) {
                return null;
            }
            array2[--count] = object;
            path = path.getParentPath();
        }
        return path != null || count > 0 ? null : array2;
    }

    @SafeVarargs
    public static <T> TreePath convertArrayToTreePath(T ... array2) {
        return TreePathUtil.convertArrayToTreePath(array2, object -> object);
    }

    public static <T> TreePath convertArrayToTreePath(T @NotNull [] array2, @NotNull Function<? super T, Object> converter) {
        return array2.length == 0 ? null : TreePathUtil.convertCollectionToTreePath(Arrays.asList(array2), converter);
    }

    public static <T> TreePath convertCollectionToTreePath(@NotNull Iterable<? extends T> collection) {
        return TreePathUtil.convertCollectionToTreePath(collection, object -> object);
    }

    public static <T> TreePath convertCollectionToTreePath(@NotNull Iterable<? extends T> collection, @NotNull Function<? super T, Object> converter) {
        TreePath path = null;
        for (T object : collection) {
            Object component2 = TreePathUtil.convert(object, converter);
            if (component2 == null) {
                return null;
            }
            path = TreePathUtil.createTreePath(path, component2);
        }
        return path;
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node) {
        return TreePathUtil.pathToTreeNode(node, object -> object);
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node, @NotNull Function<? super TreeNode, Object> converter) {
        return TreePathUtil.pathToCustomNode(node, TreeNode::getParent, converter);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node, @NotNull Function<? super T, ? extends T> getParent) {
        return TreePathUtil.pathToCustomNode(node, getParent, object -> object);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node, @NotNull Function<? super T, ? extends T> getParent, @NotNull Function<? super T, Object> converter) {
        ArrayDeque<T> deque = new ArrayDeque<T>();
        while (node != null) {
            deque.addFirst(node);
            node = getParent.apply(node);
        }
        return TreePathUtil.convertCollectionToTreePath(deque, converter);
    }

    private static <I, O> O convert(I object, @NotNull Function<? super I, ? extends O> converter) {
        return object == null ? null : (O)converter.apply((I)object);
    }

    public static TreePath @NotNull [] toTreePathArray(@NotNull Collection<TreePath> collection) {
        return collection.isEmpty() ? TreeUtil.EMPTY_TREE_PATH : collection.toArray(TreeUtil.EMPTY_TREE_PATH);
    }

    public static TreeNode toTreeNode(TreePath path) {
        Object component2 = path == null ? null : path.getLastPathComponent();
        return component2 instanceof TreeNode ? (TreeNode)component2 : null;
    }

    @Contract(value="!null->!null")
    public static TreeNode[] toTreeNodes(TreePath ... paths) {
        return paths == null ? null : (TreeNode[])Stream.of(paths).map(TreePathUtil::toTreeNode).filter(Objects::nonNull).toArray(TreeNode[]::new);
    }

    public static TreePath toTreePath(TreeNode node) {
        return node == null ? null : TreePathUtil.pathToTreeNode(node);
    }

    public static TreePath[] toTreePaths(TreeNode ... nodes) {
        return nodes == null ? null : (TreePath[])Stream.of(nodes).map(TreePathUtil::toTreePath).filter(Objects::nonNull).toArray(TreePath[]::new);
    }

    public static TreePath findAncestor(TreePath path, @NotNull Predicate<TreePath> predicate) {
        while (path != null) {
            if (predicate.test(path)) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public static TreePath findCommonAncestor(TreePath ... paths) {
        if (ArrayUtil.isEmpty((Object[])paths)) {
            return null;
        }
        if (paths.length == 1) {
            return paths[0];
        }
        return TreePathUtil.findCommonAncestor(Arrays.asList(paths));
    }

    /*
     * WARNING - void declaration
     */
    public static TreePath findCommonAncestor(@NotNull Iterable<? extends TreePath> paths) {
        TreePath ancestor = null;
        for (int i2 = 0; i2 < Integer.MAX_VALUE; ++i2) {
            TreePath first = null;
            for (TreePath treePath : paths) {
                void var5_5;
                int count = treePath.getPathCount();
                if (count <= i2) {
                    return ancestor;
                }
                while (--count > i2) {
                    TreePath treePath2 = var5_5.getParentPath();
                }
                if (var5_5 == null) {
                    throw new IllegalStateException("unexpected");
                }
                if (first == null) {
                    first = var5_5;
                }
                if (first == var5_5 || Objects.equals(first.getLastPathComponent(), var5_5.getLastPathComponent())) continue;
                return ancestor;
            }
            if (first == null) {
                return ancestor;
            }
            ancestor = TreePathUtil.createTreePath(ancestor, first.getLastPathComponent());
        }
        return ancestor;
    }
}

