/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AbstractTreeWalker<N> {
    private final AtomicReference<State> state = new AtomicReference();
    private final AsyncPromise<TreePath> promise = new AsyncPromise();
    private final ArrayDeque<ArrayDeque<N>> stack = new ArrayDeque();
    private final Function<? super N, Object> converter;
    private final TreeVisitor visitor;
    private volatile TreePath current;

    public AbstractTreeWalker(@NotNull TreeVisitor visitor) {
        this(visitor, node -> node);
    }

    public AbstractTreeWalker(@NotNull TreeVisitor visitor, Function<? super N, Object> converter) {
        this.converter = converter;
        this.visitor = visitor;
    }

    protected abstract Collection<N> getChildren(@NotNull N var1);

    public void setChildren(Collection<? extends N> children2) {
        boolean paused = this.state.compareAndSet(State.PAUSED, State.STARTED);
        if (!paused && !this.state.compareAndSet(State.REQUESTED, State.STARTED)) {
            throw new IllegalStateException();
        }
        this.stack.push(children2 == null ? new ArrayDeque() : new ArrayDeque<N>(children2));
        if (paused) {
            this.processNextPath();
        }
    }

    @NotNull
    public Promise<TreePath> promise() {
        return this.promise;
    }

    public void setError(@NotNull Throwable error) {
        this.state.set(State.FAILED);
        this.promise.setError(error);
    }

    public void start(N node) {
        this.start(null, node);
    }

    public void start(TreePath parent, N node) {
        TreePath result2 = null;
        if (node != null) {
            try {
                TreePath path = TreePathUtil.createTreePath(parent, this.converter.apply(node));
                switch (this.visitor.visit(path)) {
                    case CONTINUE: {
                        this.update(null, State.REQUESTED);
                        if (this.processChildren(path, node)) {
                            this.processNextPath();
                        }
                        return;
                    }
                    case INTERRUPT: {
                        result2 = path;
                        break;
                    }
                    case SKIP_CHILDREN: {
                        break;
                    }
                }
            }
            catch (Exception error) {
                this.setError(error);
                return;
            }
        }
        this.update(null, State.FINISHED);
        this.promise.setResult(result2);
    }

    private boolean processChildren(@NotNull TreePath path, @NotNull N node) {
        this.current = path;
        Collection<N> children2 = this.getChildren(node);
        if (children2 == null) {
            return !this.state.compareAndSet(State.REQUESTED, State.PAUSED);
        }
        this.update(State.REQUESTED, State.STARTED);
        this.stack.push(new ArrayDeque<N>(children2));
        return true;
    }

    private void processNextPath() {
        try {
            while (State.STARTED == this.state.get()) {
                TreePath path;
                ArrayDeque<N> siblings = this.stack.peek();
                if (siblings == null) {
                    this.update(State.STARTED, State.FINISHED);
                    this.current = null;
                    this.promise.setResult(null);
                    return;
                }
                N node = siblings.poll();
                if (node == null) {
                    path = this.current;
                    if (path == null) {
                        throw new IllegalStateException();
                    }
                    if (siblings != this.stack.poll()) {
                        throw new IllegalStateException();
                    }
                    this.current = path.getParentPath();
                    continue;
                }
                path = TreePathUtil.createTreePath(this.current, this.converter.apply(node));
                switch (this.visitor.visit(path)) {
                    case CONTINUE: {
                        this.update(State.STARTED, State.REQUESTED);
                        if (this.processChildren(path, node)) break;
                        return;
                    }
                    case INTERRUPT: {
                        this.update(State.STARTED, State.FINISHED);
                        this.current = null;
                        this.stack.clear();
                        this.promise.setResult((Object)path);
                        return;
                    }
                    case SKIP_SIBLINGS: {
                        siblings.clear();
                        break;
                    }
                }
            }
        }
        catch (Exception error) {
            this.setError(error);
        }
    }

    private void update(State expected, @NotNull State replacement) {
        if (!this.state.compareAndSet(expected, replacement)) {
            throw new IllegalStateException();
        }
    }

    private static enum State {
        STARTED,
        REQUESTED,
        PAUSED,
        FINISHED,
        FAILED;

    }
}

