/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreeVisitor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNodeVisitor<T>
implements TreeVisitor {
    protected static final Logger LOG = Logger.getInstance(AbstractTreeNodeVisitor.class);
    private final Supplier<? extends T> supplier;
    private final Predicate<? super TreePath> predicate;

    public AbstractTreeNodeVisitor(@NotNull Supplier<? extends T> supplier2, @Nullable Predicate<? super TreePath> predicate) {
        this.supplier = supplier2;
        this.predicate = predicate;
    }

    @Nullable
    public final T getElement() {
        return this.supplier.get();
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        T element2;
        if (LOG.isTraceEnabled()) {
            LOG.debug("process ", new Object[]{path});
        }
        if ((element2 = this.getElement()) == null) {
            return TreeVisitor.Action.SKIP_SIBLINGS;
        }
        Object component2 = path.getLastPathComponent();
        if (component2 instanceof AbstractTreeNode) {
            return this.visit(path, (AbstractTreeNode)component2, element2);
        }
        if (component2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component2;
            Object object = node.getUserObject();
            if (object instanceof AbstractTreeNode) {
                return this.visit(path, (AbstractTreeNode)object, element2);
            }
            if (object instanceof String) {
                LOG.debug("ignore children: ", new Object[]{object});
            } else {
                LOG.warn(object == null ? "no object" : "unexpected object " + object.getClass());
            }
        } else if (component2 instanceof String) {
            LOG.debug("ignore children: ", new Object[]{component2});
        } else {
            LOG.warn(component2 == null ? "no component" : "unexpected component " + component2.getClass());
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    @NotNull
    protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull T element2) {
        if (this.matches(node, element2)) {
            LOG.debug("found ", new Object[]{path});
            if (this.predicate == null) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (this.predicate.test(path)) {
                return TreeVisitor.Action.CONTINUE;
            }
        } else if (this.contains(node, element2)) {
            LOG.debug("visit ", new Object[]{path});
            return TreeVisitor.Action.CONTINUE;
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    protected boolean matches(@NotNull AbstractTreeNode node, @NotNull T element2) {
        return node.canRepresent(element2);
    }

    protected boolean contains(@NotNull AbstractTreeNode node, @NotNull T element2) {
        T content2 = this.getContent(node);
        return content2 != null && this.isAncestor(content2, element2);
    }

    protected T getContent(@NotNull AbstractTreeNode node) {
        return null;
    }

    protected boolean isAncestor(@NotNull T content2, @NotNull T element2) {
        return false;
    }
}

