/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout.singleRowLayout;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutCallback;
import com.intellij.ui.tabs.layout.TabsLayoutBase;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowLayoutStrategy;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowPassInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class SingleRowLayout
extends TabsLayoutBase
implements MorePopupAware {
    public SingleRowPassInfo myLastSingRowLayout;
    private final SingleRowLayoutStrategy myTop = new SingleRowLayoutStrategy.Top(this);
    private final SingleRowLayoutStrategy myLeft = new SingleRowLayoutStrategy.Left(this);
    private final SingleRowLayoutStrategy myBottom = new SingleRowLayoutStrategy.Bottom(this);
    private final SingleRowLayoutStrategy myRight = new SingleRowLayoutStrategy.Right(this);
    public final ActionToolbar myMoreToolbar;

    public SingleRowLayout() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction tabListAction = actionManager.getAction("TabList");
        this.myMoreToolbar = actionManager.createActionToolbar("TabsMoreToolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{tabListAction}), true);
        this.myMoreToolbar.getComponent().setBorder((Border)JBUI.Borders.empty());
        this.myMoreToolbar.getComponent().setOpaque(false);
        this.myMoreToolbar.setLayoutPolicy(0);
    }

    @Override
    public void init(@NotNull TabsLayoutCallback callback2) {
        super.init(callback2);
        this.myCallback.getComponent().add(this.myMoreToolbar.getComponent());
    }

    SingleRowLayoutStrategy getStrategy() {
        switch (this.myCallback.getTabsPosition()) {
            case top: {
                return this.myTop;
            }
            case left: {
                return this.myLeft;
            }
            case bottom: {
                return this.myBottom;
            }
            case right: {
                return this.myRight;
            }
        }
        return null;
    }

    protected boolean checkLayoutLabels(SingleRowPassInfo data2, boolean isForcedLayout) {
        boolean layoutLabels = true;
        if (!isForcedLayout && this.myLastSingRowLayout != null && this.myLastSingRowLayout.contentCount == this.myCallback.getAllTabsCount() && this.myLastSingRowLayout.layoutSize.equals(this.myCallback.getComponent().getSize()) && this.myLastSingRowLayout.scrollOffset == this.getScrollOffset()) {
            for (TabInfo each : data2.myVisibleInfos) {
                TabLabel eachLabel = this.myCallback.getTabLabel(each);
                if (!eachLabel.isValid()) {
                    layoutLabels = true;
                    break;
                }
                if (this.myCallback.getSelectedInfo() != each || eachLabel.getBounds().width == 0) continue;
                layoutLabels = false;
            }
        }
        return layoutLabels;
    }

    int getScrollOffset() {
        return 0;
    }

    public void scroll(int units) {
    }

    public int getScrollUnitIncrement() {
        return 0;
    }

    @Override
    public void dispose() {
        this.myCallback.getComponent().remove(this.myMoreToolbar.getComponent());
    }

    @Override
    protected Rectangle layoutComp(int componentX, int componentY, JComponent comp, int deltaWidth, int deltaHeight) {
        return super.layoutComp(componentX, componentY, comp, deltaWidth, deltaHeight);
    }

    @Override
    protected Rectangle layoutComp(Rectangle bounds2, JComponent comp, int deltaWidth, int deltaHeight) {
        return super.layoutComp(bounds2, comp, deltaWidth, deltaHeight);
    }

    @Override
    protected Rectangle layout(JComponent c, int x, int y, int width, int height) {
        return super.layout(c, x, y, width, height);
    }

    @Override
    protected Rectangle layout(JComponent component2, Rectangle bounds2) {
        return super.layout(component2, bounds2);
    }

    @Override
    protected double getDragOutMultiplier() {
        return super.getDragOutMultiplier();
    }

    @Override
    protected SingleRowPassInfo doLayout(List<TabInfo> infosToShow, boolean isForced) {
        SingleRowPassInfo data2 = new SingleRowPassInfo(infosToShow, this, this.myCallback);
        data2.headerToFitWidth = this.computeHeaderToFitWidth(data2);
        boolean shouldLayoutLabels = this.checkLayoutLabels(data2, isForced);
        if (!shouldLayoutLabels) {
            data2 = this.myLastSingRowLayout;
        }
        TabInfo selected2 = this.myCallback.getSelectedInfo();
        this.prepareLayoutPassInfo(data2, selected2);
        this.resetLayout(shouldLayoutLabels || this.myCallback.isHiddenTabs());
        if (shouldLayoutLabels && !this.myCallback.isHiddenTabs()) {
            this.recomputeToLayout(data2);
            data2.position = this.getStrategy().getStartPosition(data2) - this.getScrollOffset();
            this.layoutLabels(data2);
            this.layoutMoreButton(data2);
        }
        if (selected2 != null) {
            data2.comp = new WeakReference<JComponent>(selected2.getComponent());
            this.getStrategy().layoutComp(data2);
        }
        data2.tabRectangle = data2.toLayout.size() > 0 ? this.getStrategy().getTabRectangle(data2) : new Rectangle();
        this.layoutExtraBorderLines(data2);
        this.myLastSingRowLayout = data2;
        return data2;
    }

    private void layoutExtraBorderLines(SingleRowPassInfo data2) {
        data2.myExtraBorderLines = new ArrayList<LayoutPassInfo.LineCoordinates>();
        if (data2.toLayout.size() > 0) {
            LayoutPassInfo.LineCoordinates borderLine = this.getStrategy().computeExtraBorderLine(data2);
            data2.myExtraBorderLines.add(borderLine);
        }
        if (data2.vToolbar != null && data2.vToolbar.get() != null) {
            Rectangle bounds2 = ((JComponent)data2.vToolbar.get()).getBounds();
            data2.myExtraBorderLines.add(new LayoutPassInfo.LineCoordinates(bounds2.x + bounds2.width, bounds2.y, bounds2.x + bounds2.width, bounds2.y + bounds2.height));
        }
    }

    protected void prepareLayoutPassInfo(SingleRowPassInfo data2, TabInfo selected2) {
        JBTabsImpl.Toolbar selectedToolbar;
        data2.insets = this.myCallback.getLayoutInsets();
        if (this.myCallback.isHorizontalToolbar()) {
            data2.insets.left += this.myCallback.getFirstTabOffset();
        }
        data2.hToolbar = new WeakReference<Object>(((selectedToolbar = this.myCallback.getToolbar(selected2)) != null && this.myCallback.isHorizontalToolbar() && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data2.vToolbar = new WeakReference<Object>((selectedToolbar != null && !this.myCallback.isHorizontalToolbar() && !selectedToolbar.isEmpty() ? selectedToolbar : null));
        data2.toFitLength = this.getStrategy().getToFitLength(data2);
    }

    protected void layoutMoreButton(SingleRowPassInfo data2) {
        if (data2.toDrop.size() > 0) {
            data2.moreRect = this.getStrategy().getMoreRect(data2);
        }
    }

    protected void layoutLabels(SingleRowPassInfo data2) {
        boolean layoutStopped = false;
        for (TabInfo eachInfo : data2.toLayout) {
            TabLabel label2 = this.myCallback.getTabLabel(eachInfo);
            if (layoutStopped) {
                Rectangle rec = this.getStrategy().getLayoutRect(data2, 0, 0);
                this.layout((JComponent)label2, rec);
                continue;
            }
            Dimension eachSize = label2.getPreferredSize();
            int length = this.getStrategy().getLengthIncrement(eachSize);
            boolean continueLayout = this.applyTabLayout(data2, label2, length);
            data2.position = this.getStrategy().getMaxPosition(label2.getBounds());
            data2.position -= this.myCallback.getBorderThickness();
            if (continueLayout) continue;
            layoutStopped = true;
        }
        for (TabInfo eachInfo : data2.toDrop) {
            this.resetLayout((JComponent)this.myCallback.getTabLabel(eachInfo));
        }
    }

    protected boolean applyTabLayout(SingleRowPassInfo data2, TabLabel label2, int length) {
        Rectangle rec = this.getStrategy().getLayoutRect(data2, data2.position, length);
        this.layout((JComponent)label2, rec);
        label2.setAlignmentToCenter(this.myCallback.isEditorTabs() && this.getStrategy().isToCenterTextWhenStretched());
        return true;
    }

    protected abstract void recomputeToLayout(SingleRowPassInfo var1);

    protected void calculateRequiredLength(SingleRowPassInfo data2) {
        for (TabInfo eachInfo : data2.myVisibleInfos) {
            data2.requiredLength += this.getRequiredLength(eachInfo);
            if (this.myCallback.getTabsPosition().isSide()) {
                --data2.requiredLength;
            }
            data2.toLayout.add(eachInfo);
        }
    }

    protected int getRequiredLength(TabInfo eachInfo) {
        TabLabel label2 = this.myCallback.getTabLabel(eachInfo);
        return this.getStrategy().getLengthIncrement(label2 != null ? label2.getPreferredSize() : new Dimension()) - (this.myCallback.isEditorTabs() ? this.myCallback.getBorderThickness() : 0);
    }

    public boolean canShowMorePopup() {
        return this.myLastSingRowLayout != null && this.myLastSingRowLayout.moreRect != null;
    }

    public void showMorePopup() {
        if (this.myLastSingRowLayout == null || this.myLastSingRowLayout.moreRect == null) {
            return;
        }
        JBPopupMenu morePopupMenu = new JBPopupMenu();
        for (TabInfo each : this.myCallback.getVisibleTabsInfos()) {
            if (!this.isTabOutOfView(each)) continue;
            JBMenuItem item = new JBMenuItem(each.getText(), each.getIcon());
            item.setForeground(each.getDefaultForeground());
            item.setBackground(each.getTabColor());
            morePopupMenu.add((JMenuItem)item);
            item.addActionListener(__ -> this.myCallback.selectTab(each, true));
        }
        Rectangle rect = this.myLastSingRowLayout.moreRect;
        if (rect != null) {
            morePopupMenu.show((Component)this.myCallback.getComponent(), rect.x, rect.y + rect.height);
        }
    }

    public boolean isTabOutOfView(TabInfo tabInfo) {
        return this.myLastSingRowLayout != null && this.myLastSingRowLayout.toDrop.contains(tabInfo);
    }

    public int getDropIndexFor(Point point) {
        if (this.myLastSingRowLayout == null) {
            return -1;
        }
        int result2 = -1;
        Component c = this.myCallback.getComponent().getComponentAt(point);
        if (c == this.myCallback.getComponent()) {
            for (int i2 = 0; i2 < this.myLastSingRowLayout.myVisibleInfos.size() - 1; ++i2) {
                boolean between;
                TabLabel first = this.myCallback.getTabLabel((TabInfo)this.myLastSingRowLayout.myVisibleInfos.get(i2));
                TabLabel second = this.myCallback.getTabLabel((TabInfo)this.myLastSingRowLayout.myVisibleInfos.get(i2 + 1));
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean horizontal = this.getStrategy() instanceof SingleRowLayoutStrategy.Horizontal;
                if (horizontal) {
                    between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                } else {
                    boolean bl = between = firstBounds.getMaxY() < (double)point.y && secondBounds.getY() > (double)point.y && firstBounds.x < point.x && secondBounds.getMaxX() > (double)point.x;
                }
                if (!between) continue;
                c = first;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastSingRowLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myCallback.isDropTarget(info);
            if (!isDropTarget) {
                for (int i3 = 0; i3 <= index; ++i3) {
                    if (!this.myCallback.isDropTarget((TabInfo)this.myLastSingRowLayout.myVisibleInfos.get(i3))) continue;
                    --index;
                    break;
                }
                result2 = index;
            } else if (index < this.myLastSingRowLayout.myVisibleInfos.size()) {
                result2 = index;
            }
        }
        return result2;
    }

    @Override
    public boolean isToolbarOnTabs() {
        return this.getStrategy().isToolbarOnTabs();
    }

    public boolean isSingleRow() {
        return true;
    }

    @Override
    public boolean isDragOut(TabLabel tabLabel, int deltaX, int deltaY) {
        return this.getStrategy().isDragOut(tabLabel, deltaX, deltaY);
    }

    public TabsLayoutCallback getCallback() {
        return this.myCallback;
    }

    private int computeHeaderToFitWidth(SingleRowPassInfo data2) {
        if (!this.myCallback.getTabsPosition().isSide()) {
            return data2.layoutRectWithoutInsets.width;
        }
        int max = 0;
        for (TabInfo eachInfo : data2.myVisibleInfos) {
            TabLabel label2 = this.myCallback.getTabLabel(eachInfo);
            max = Math.max(max, label2.getPreferredSize().width);
        }
        int splitterSideTabsLimit = this.getSplitterSideTabsLimit();
        if (splitterSideTabsLimit > 0) {
            max = Math.min(max, splitterSideTabsLimit);
        }
        return max;
    }

    protected int getSplitterSideTabsLimit() {
        return 0;
    }
}

