/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.popup.WizardPopup;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PopupDispatcher
implements AWTEventListener,
KeyEventDispatcher,
IdePopupEventDispatcher {
    private static WizardPopup ourActiveWizardRoot;
    private static WizardPopup ourShowingStep;
    private static final PopupDispatcher ourInstance;

    private PopupDispatcher() {
    }

    public static PopupDispatcher getInstance() {
        return ourInstance;
    }

    static void setActiveRoot(@NotNull WizardPopup aRootPopup) {
        PopupDispatcher.disposeActiveWizard();
        ourActiveWizardRoot = aRootPopup;
        ourShowingStep = aRootPopup;
        if (ApplicationManager.getApplication() != null) {
            IdeEventQueue.getInstance().getPopupManager().push(ourInstance);
        }
    }

    static void clearRootIfNeeded(@NotNull WizardPopup aRootPopup) {
        if (ourActiveWizardRoot == aRootPopup) {
            ourActiveWizardRoot = null;
            ourShowingStep = null;
            if (ApplicationManager.getApplication() != null) {
                IdeEventQueue.getInstance().getPopupManager().remove(ourInstance);
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        PopupDispatcher.dispatchMouseEvent(event);
    }

    private static boolean dispatchMouseEvent(@NotNull AWTEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        if (ourShowingStep == null) {
            return false;
        }
        WizardPopup eachParent = ourShowingStep;
        MouseEvent mouseEvent = (MouseEvent)event;
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        do {
            if (eachParent.isDisposed() || !eachParent.getContent().isShowing()) {
                PopupDispatcher.getActiveRoot().cancel();
                return false;
            }
            if (!eachParent.getBounds().contains(point) && eachParent.canClose()) continue;
            return false;
        } while ((eachParent = eachParent.getParent()) != null);
        PopupDispatcher.getActiveRoot().cancel();
        return false;
    }

    private static boolean disposeActiveWizard() {
        if (ourActiveWizardRoot != null) {
            ourActiveWizardRoot.disposeChildren();
            Disposer.dispose((Disposable)ourActiveWizardRoot);
            return true;
        }
        return false;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (ourShowingStep == null) {
            return false;
        }
        return ourShowingStep.dispatch(e);
    }

    static void setShowing(@NotNull WizardPopup aBaseWizardPopup) {
        ourShowingStep = aBaseWizardPopup;
    }

    static void unsetShowing(@NotNull WizardPopup aBaseWizardPopup) {
        if (ourActiveWizardRoot != null) {
            for (WizardPopup wp = aBaseWizardPopup; wp != null; wp = wp.getParent()) {
                if (wp != ourActiveWizardRoot) continue;
                ourShowingStep = aBaseWizardPopup.getParent();
                return;
            }
        }
    }

    static WizardPopup getActiveRoot() {
        return ourActiveWizardRoot;
    }

    public Component getComponent() {
        return ourShowingStep != null && !ourShowingStep.isDisposed() ? ourShowingStep.getContent() : null;
    }

    @NotNull
    public Stream<JBPopup> getPopupStream() {
        return Stream.of(ourActiveWizardRoot);
    }

    public boolean dispatch(AWTEvent event) {
        if (event instanceof KeyEvent) {
            return this.dispatchKeyEvent((KeyEvent)event);
        }
        if (event instanceof MouseEvent) {
            return PopupDispatcher.dispatchMouseEvent(event);
        }
        return false;
    }

    public boolean requestFocus() {
        if (ourShowingStep != null) {
            ourShowingStep.requestFocus();
        }
        return true;
    }

    public boolean close() {
        return PopupDispatcher.disposeActiveWizard();
    }

    public void setRestoreFocusSilently() {
    }

    static {
        ourInstance = new PopupDispatcher();
        if (System.getProperty("is.popup.test") != null || ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(ourInstance, 501L);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(ourInstance);
        }
    }
}

