/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.ItemsContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.StatsCounters;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

final class TouchBar
implements NSTLibrary.ItemCreator {
    private static final boolean ourAsyncUpdate = Registry.is((String)"actionSystem.update.touchbar.actions.asynchronously");
    private static final boolean ourUseCached = Registry.is((String)"actionSystem.update.touchbar.actions.use.cached");
    private static final boolean ourCollectStats = Boolean.getBoolean("touchbar.collect.stats");
    private static final Logger LOG = Logger.getInstance(TouchBar.class);
    @Nullable
    private final TouchBarStats myStats;
    @NotNull
    private final ItemsContainer myItems;
    private final ItemListener myItemListener;
    private final PresentationFactory myFactory = new PresentationFactory();
    private final TBItemButton myCustomEsc;
    private final ActionGroup myActionGroup;
    @Nullable
    private final String mySkipSubgroupsPrefix;
    @NotNull
    private final Updater myUpdateTimer = new Updater(500);
    private CancellablePromise<List<AnAction>> myLastUpdate;
    private String[] myVisibleIds;
    private long myStartShowNs = 0L;
    private long myLastUpdateNs = 0L;
    private Timer myAutoCloseTimer = null;
    private long myLastActiveNs = 0L;
    private ID myNativePeer;
    private String myDefaultOptionalContextName;
    private BarContainer myBarContainer;
    private final Object myHideReleaseLock = new Object();
    private Future<?> myLastUpdateNativePeers;
    private boolean myAllowSkipSlowUpdates = false;
    @NotNull
    private final Map<AnAction, TBItemAnActionButton> myActionButtonPool = new HashMap<AnAction, TBItemAnActionButton>();
    @NotNull
    private final LinkedList<TBItemGroup> myGroupPool = new LinkedList();
    public static final TouchBar EMPTY = new TouchBar();

    private TouchBar() {
        this.myItems = new ItemsContainer("EMPTY_STUB_TOUCHBAR");
        this.myCustomEsc = null;
        this.myNativePeer = ID.NIL;
        this.myItemListener = null;
        this.myActionGroup = null;
        this.mySkipSubgroupsPrefix = null;
        this.myStats = null;
    }

    TouchBar(@NotNull String touchbarName, boolean replaceEsc) {
        this(touchbarName, replaceEsc, false, false, null, null);
    }

    TouchBar(@NotNull String touchbarName, boolean replaceEsc, boolean autoClose, boolean emulateESC, @Nullable ActionGroup actionGroup, @Nullable String skipSubgroupsPrefix) {
        this.myItemListener = autoClose ? (src, evcode) -> this._closeSelf() : null;
        this.myActionGroup = actionGroup;
        this.mySkipSubgroupsPrefix = skipSubgroupsPrefix;
        this.myStats = ourCollectStats ? TouchBarStats.getStats(touchbarName) : null;
        this.myItems = new ItemsContainer(touchbarName);
        if (replaceEsc) {
            Icon ic2 = IconLoader.getIcon((String)"/mac/touchbar/popoverClose_dark.svg");
            this.myCustomEsc = new TBItemButton(this.myItemListener, null).setIcon(ic2).setWidth(64).setTransparentBg(true).setAction(() -> {
                this._closeSelf();
                if (emulateESC) {
                    try {
                        Robot robot = new Robot();
                        robot.keyPress(27);
                        robot.keyRelease(27);
                    }
                    catch (AWTException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }, false, null);
            this.myCustomEsc.setUid(touchbarName + "_custom_esc_button");
        } else {
            this.myCustomEsc = null;
        }
        this.myNativePeer = NST.createTouchBar(touchbarName, this, this.myCustomEsc != null ? this.myCustomEsc.getUid() : null);
    }

    @NotNull
    PresentationFactory getFactory() {
        return this.myFactory;
    }

    void setAllowSkipSlowUpdates(boolean allowSkipSlowUpdates) {
        this.myAllowSkipSlowUpdates = allowSkipSlowUpdates;
    }

    @Nullable
    TouchBarStats getStats() {
        return this.myStats;
    }

    boolean isManualClose() {
        return this.myCustomEsc != null;
    }

    boolean isEmpty() {
        return this.isEmptyActionGroup() && (this.myItems.isEmpty() || !this.myItems.anyMatchDeep(item -> item != null && !(item instanceof SpacingItem)));
    }

    public String toString() {
        return this.myItems.toString() + "_" + this.myNativePeer;
    }

    @Override
    public ID createItem(@NotNull String uid) {
        long startNs = this.myStats != null ? System.nanoTime() : 0L;
        ID result2 = this.createItemImpl(uid);
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.itemsCreationDurationNs, System.nanoTime() - startNs);
        }
        return result2;
    }

    private ID createItemImpl(@NotNull String uid) {
        if (this.myCustomEsc != null && this.myCustomEsc.getUid().equals(uid)) {
            return this.myCustomEsc.getNativePeer();
        }
        TBItem item = this.myItems.findItem(uid);
        if (item == null) {
            LOG.error("can't find TBItem with uid '" + uid + "'");
            return ID.NIL;
        }
        return item.getNativePeer();
    }

    ID getNativePeer() {
        return this.myNativePeer;
    }

    @NotNull
    ItemsContainer getItemsContainer() {
        return this.myItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.myHideReleaseLock;
        synchronized (object) {
            long startNs = this.myStats != null ? System.nanoTime() : 0L;
            this.myItems.releaseAll();
            if (!this.myNativePeer.equals((Object)ID.NIL)) {
                NST.releaseTouchBar(this.myNativePeer);
                this.myNativePeer = ID.NIL;
            }
            this.myUpdateTimer.stop();
            this.myActionButtonPool.forEach((act, item) -> item.releaseNativePeer());
            this.myActionButtonPool.clear();
            this.myGroupPool.forEach(item -> item.releaseNativePeer());
            this.myGroupPool.clear();
            if (this.myStats != null) {
                this.myStats.incrementCounter(StatsCounters.touchbarReleaseDurationNs, System.nanoTime() - startNs);
            }
        }
    }

    void softClear() {
        this.myItems.softClear(this.myActionButtonPool, this.myGroupPool);
    }

    @NotNull
    TBItemButton addButton() {
        @NotNull TBItemButton butt = new TBItemButton(this.myItemListener, this.myStats != null ? this.myStats.getActionStats("simple_button") : null);
        this.myItems.addItem(butt);
        return butt;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act) {
        return this.addAnActionButton(act, null);
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act, @Nullable TBItem positionAnchor) {
        @NotNull TBItemAnActionButton butt = this.createActionButton(act);
        this.myItems.addItem((TBItem)butt, positionAnchor);
        return butt;
    }

    @NotNull
    TBItemGroup addGroup() {
        @NotNull TBItemGroup group = this.createGroup();
        this.myItems.addItem(group);
        return group;
    }

    @NotNull
    TBItemScrubber addScrubber() {
        int defaultScrubberWidth = 500;
        @NotNull TBItemScrubber scrub = new TBItemScrubber(this.myItemListener, this.myStats, 500);
        this.myItems.addItem(scrub);
        return scrub;
    }

    void addSpacing(boolean large) {
        this.myItems.addSpacing(large);
    }

    void addFlexibleSpacing() {
        this.myItems.addFlexibleSpacing();
    }

    void setBarContainer(BarContainer barContainer) {
        this.myBarContainer = barContainer;
    }

    void setDefaultOptionalContextName(@NotNull String defaultCtxName) {
        this.myDefaultOptionalContextName = defaultCtxName;
    }

    void setOptionalContextItems(@NotNull ActionGroup actions, final @NotNull String contextName) {
        this.myItems.releaseItems(tbi -> contextName.equals(tbi.myOptionalContextName));
        BuildUtils.addActionGroupButtons(this, actions, null, new BuildUtils.Customizer(){

            @Override
            public void process(@NotNull BuildUtils.INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                super.process(ni, butt);
                butt.myOptionalContextName = contextName;
            }
        });
        this.selectVisibleItemsToShow();
    }

    void removeOptionalContextItems(@NotNull String contextName) {
        this.myItems.releaseItems(tbi -> contextName.equals(tbi.myOptionalContextName));
        this.selectVisibleItemsToShow();
    }

    void setOptionalContextVisible(@Nullable String contextName) {
        @Nullable String ctx = contextName == null ? this.myDefaultOptionalContextName : contextName;
        boolean[] visibilityChanged = new boolean[]{false};
        this.myItems.forEachDeep(tbi -> {
            if (tbi.myOptionalContextName == null) {
                return;
            }
            boolean newVisible = tbi.myOptionalContextName.equals(ctx);
            if (tbi.myIsVisible != newVisible) {
                if (tbi instanceof TBItemAnActionButton) {
                    ((TBItemAnActionButton)tbi).setAutoVisibility(newVisible);
                }
                tbi.myIsVisible = newVisible;
                visibilityChanged[0] = true;
            }
        });
        if (visibilityChanged[0]) {
            this.selectVisibleItemsToShow();
        }
    }

    void selectVisibleItemsToShow() {
        if (this.myItems.isEmpty()) {
            if (this.myVisibleIds != null && this.myVisibleIds.length > 0) {
                NST.selectItemsToShow(this.myNativePeer, null, 0);
            }
            this.myVisibleIds = null;
            return;
        }
        Object[] ids = this.myItems.getVisibleIds();
        if (Arrays.equals(ids, this.myVisibleIds)) {
            return;
        }
        this.myVisibleIds = ids;
        NST.selectItemsToShow(this.myNativePeer, (String[])ids, ids.length);
    }

    void setPrincipal(@NotNull TBItem item) {
        NST.setPrincipal(this.myNativePeer, item.getUid());
    }

    void onBeforeShow() {
        this.myStartShowNs = System.nanoTime();
        this.myUpdateTimer.start();
        this.myAutoCloseTimer = null;
        this.myLastActiveNs = 0L;
        this.updateActionItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHide() {
        Object object = this.myHideReleaseLock;
        synchronized (object) {
            if (this.myLastUpdate != null) {
                this.myLastUpdate.cancel();
                this.myLastUpdate = null;
            }
            this.myUpdateTimer.stop();
        }
    }

    void forEachDeep(Consumer<? super TBItem> proc) {
        this.myItems.forEachDeep(proc);
    }

    private void _applyPresentationChanges(List<AnAction> actions) {
        boolean[] blArray;
        long startNs = System.nanoTime();
        if (this.myLastUpdateNativePeers != null && !this.myLastUpdateNativePeers.isDone()) {
            this.myLastUpdateNativePeers.cancel(false);
        }
        ArrayList toUpdate = new ArrayList();
        if (this.myBarContainer != null && this.myBarContainer.getType() == BarType.DEBUGGER) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = false;
        } else {
            blArray = null;
        }
        boolean[] checks = blArray;
        this.forEachDeep(tbitem -> {
            if (!(tbitem instanceof TBItemAnActionButton)) {
                return;
            }
            TBItemAnActionButton item = (TBItemAnActionButton)tbitem;
            @NotNull Presentation presentation2 = this.myFactory.getPresentation(item.getAnAction());
            item.updateVisibility(presentation2);
            item.updateView(presentation2);
            @Nullable TBItemButton.Updater updater2 = item.getNativePeerUpdater();
            if (updater2 != null) {
                toUpdate.add(updater2);
            }
            if (checks != null) {
                String actId = ActionManager.getInstance().getId(item.getAnAction());
                if ("Resume".equals(actId)) {
                    checks[0] = !presentation2.isEnabled();
                } else if ("Pause".equals(actId)) {
                    checks[1] = !presentation2.isEnabled();
                }
            }
        });
        Runnable updateAllNativePeers = () -> {
            toUpdate.forEach(item -> item.prepareUpdateData());
            Object object = this.myHideReleaseLock;
            synchronized (object) {
                if (!this.myUpdateTimer.isRunning() || this.myNativePeer.equals((Object)ID.NIL)) {
                    return;
                }
                toUpdate.forEach(item -> item.updateNativePeer());
            }
        };
        @NotNull Application app = ApplicationManager.getApplication();
        this.myLastUpdateNativePeers = app.executeOnPooledThread(() -> app.runReadAction(updateAllNativePeers));
        this.selectVisibleItemsToShow();
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.applyPresentaionChangesDurationNs, System.nanoTime() - startNs);
        }
        if (checks != null) {
            boolean isNonActive;
            boolean bl = isNonActive = checks[0] && checks[1];
            if (!isNonActive) {
                this.myLastActiveNs = startNs;
            }
            if (isNonActive && this.myLastActiveNs > 0L) {
                if (this.myAutoCloseTimer == null) {
                    this.myAutoCloseTimer = new Timer(1500, __ -> this._closeSelf());
                    this.myAutoCloseTimer.setRepeats(false);
                    this.myAutoCloseTimer.start();
                }
            } else if (this.myAutoCloseTimer != null) {
                this.myAutoCloseTimer.stop();
                this.myAutoCloseTimer = null;
            }
        }
    }

    void updateActionItems() {
        if (!this.myUpdateTimer.isRunning()) {
            return;
        }
        long timeNs = System.nanoTime();
        long elapsedFromStartShowNs = timeNs - this.myStartShowNs;
        this.myLastUpdateNs = timeNs;
        int delayMillis = 500;
        long delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMillis);
        if (ourUseCached && elapsedFromStartShowNs < delayNanos) {
            if (this.myStats != null) {
                this.myStats.incrementCounter(StatsCounters.forceUseCached);
            }
            Timer t = new Timer(delayMillis, e -> {
                if (System.nanoTime() - this.myLastUpdateNs > delayNanos) {
                    if (this.myStats != null) {
                        this.myStats.incrementCounter(StatsCounters.forceCachedDelayedUpdateCount);
                    }
                    this.updateActionItems();
                }
            });
            t.setRepeats(false);
            t.start();
            return;
        }
        if (this.myActionGroup != null) {
            DataContext dctx = DataManager.getInstance().getDataContext(BuildUtils.getCurrentFocusComponent());
            BuildUtils.GroupVisitor visitor = new BuildUtils.GroupVisitor(this, this.mySkipSubgroupsPrefix, null, this.myStats, this.myAllowSkipSlowUpdates);
            if (ourAsyncUpdate) {
                if (this.myLastUpdate != null) {
                    this.myLastUpdate.cancel();
                }
                this.myLastUpdate = Utils.expandActionGroupAsync(LaterInvocator.isInModalContext(), this.myActionGroup, this.myFactory, dctx, "TouchBarGeneral", visitor);
                this.myLastUpdate.onSuccess(actions -> this._applyPresentationChanges((List<AnAction>)actions)).onProcessed(__ -> {
                    this.myLastUpdate = null;
                });
            } else {
                List<AnAction> actions2 = Utils.expandActionGroupWithTimeout(LaterInvocator.isInModalContext(), this.myActionGroup, this.myFactory, dctx, "TouchBarGeneral", visitor, Registry.intValue((String)"actionSystem.update.touchbar.timeout.ms"));
                this._applyPresentationChanges(actions2);
            }
        } else {
            this.forEachDeep(tbitem -> {
                if (!(tbitem instanceof TBItemAnActionButton)) {
                    return;
                }
                long startNs = this.myStats != null ? System.nanoTime() : 0L;
                @NotNull TBItemAnActionButton item = (TBItemAnActionButton)tbitem;
                @NotNull Presentation presentation2 = this.myFactory.getPresentation(item.getAnAction());
                Component component2 = item.getComponent();
                DataContext dctx = DataManager.getInstance().getDataContext(component2);
                ActionManagerEx am = ActionManagerEx.getInstanceEx();
                AnActionEvent e = new AnActionEvent(null, dctx, "TouchBarGeneral", presentation2, (ActionManager)am, 0);
                try {
                    ActionUtil.performFastUpdate((boolean)false, (AnAction)item.getAnAction(), (AnActionEvent)e, (boolean)false);
                }
                catch (IndexNotReadyException e1) {
                    presentation2.setEnabledAndVisible(false);
                }
                if (this.myStats != null) {
                    this.myStats.getActionStats(item.getActionId()).onUpdate(System.nanoTime() - startNs);
                }
            });
            this._applyPresentationChanges(null);
        }
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.totalUpdateDurationNs, System.nanoTime() - timeNs);
        }
    }

    private void _closeSelf() {
        if (this.myBarContainer == null) {
            LOG.error("can't perform _closeSelf for touchbar '" + this.toString() + "' because parent container wasn't set");
            return;
        }
        TouchBarsManager.hideContainer(this.myBarContainer);
    }

    @NotNull
    TBItemAnActionButton createActionButton(@NotNull AnAction acaction) {
        TouchBarStats.AnActionStats stats = this.myStats == null ? null : this.myStats.getActionStats(BuildUtils.getActionId(acaction));
        TBItemAnActionButton cached = this.myActionButtonPool.remove(acaction);
        return cached != null ? cached : new TBItemAnActionButton(this.myItemListener, acaction, stats);
    }

    @NotNull
    TBItemGroup createGroup() {
        return this.myGroupPool.isEmpty() ? new TBItemGroup(this.myItems.toString(), this.myItemListener) : this.myGroupPool.poll();
    }

    private boolean isEmptyActionGroup() {
        if (this.myActionGroup == null) {
            return true;
        }
        AnAction[] actions = this.myActionGroup.getChildren(null);
        if (actions.length == 0) {
            return true;
        }
        for (AnAction act : actions) {
            if (act instanceof Separator) continue;
            return false;
        }
        return true;
    }

    private final class Updater {
        private final int myDelay;
        @Nullable
        private TimerListener myTimerImpl;

        Updater(int delay) {
            this.myDelay = delay;
        }

        void start() {
            if (this.myTimerImpl != null) {
                this.stop();
            }
            this.myTimerImpl = new TimerListener(){

                public ModalityState getModalityState() {
                    return ModalityState.current();
                }

                public void run() {
                    TouchBar.this.updateActionItems();
                }
            };
            ActionManager.getInstance().addTransparentTimerListener(this.myDelay, this.myTimerImpl);
        }

        void stop() {
            if (this.myTimerImpl == null) {
                return;
            }
            ActionManager.getInstance().removeTransparentTimerListener(this.myTimerImpl);
            this.myTimerImpl = null;
        }

        boolean isRunning() {
            return this.myTimerImpl != null;
        }
    }
}

