/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.XDebugSessionService;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectData {
    private static final Logger LOG = Logger.getInstance(ProjectData.class);
    @NotNull
    private final Project myProject;
    private final Map<BarType, BarContainer> myPermanentBars = new HashMap<BarType, BarContainer>();
    private final Map<Editor, EditorData> myEditors = new HashMap<Editor, EditorData>();
    private final Map<ToolWindow, ToolWindowData> myToolWindows = new HashMap<ToolWindow, ToolWindowData>();

    ProjectData(final @NotNull Project project) {
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                BarContainer bc = (BarContainer)ProjectData.this.myPermanentBars.get((Object)BarType.DEBUGGER);
                if (bc != null) {
                    this.handleDebugBar(toolWindowManager, bc);
                }
            }

            private void handleDebugBar(@NotNull ToolWindowManager toolWindowManager, @NotNull BarContainer debugBar) {
                boolean hasActiveDebugSession = XDebugSessionService.getInstance(project).hasActiveDebugSession(project);
                if (this.isRelatesToDebug(toolWindowManager.getActiveToolWindowId()) && hasActiveDebugSession) {
                    debugBar.show();
                } else if (!hasActiveDebugSession) {
                    debugBar.hide();
                    BarContainer defaultBar = (BarContainer)ProjectData.this.myPermanentBars.get((Object)BarType.DEFAULT);
                    if (defaultBar != null) {
                        defaultBar.show();
                    }
                }
            }

            private boolean isRelatesToDebug(@Nullable String toolWindowId) {
                return toolWindowId != null && (toolWindowId.equals("Debug") || toolWindowId.equals("Run Dashboard") || toolWindowId.equals("Services"));
            }

            @Override
            public void toolWindowsRegistered(@NotNull List<String> ids) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ProjectData.this.myProject);
                for (String id2 : ids) {
                    ToolWindow toolWindow = toolWindowManager.getToolWindow(id2);
                    ToolWindowData toolWindowData = new ToolWindowData(toolWindow, id2);
                    ProjectData.this.myToolWindows.put(toolWindow, toolWindowData);
                    toolWindow.addContentManagerListener((ContentManagerListener)toolWindowData);
                }
            }

            @Override
            public void toolWindowUnregistered(@NotNull String id2, @NotNull ToolWindow toolWindow) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (ProjectData.this.myToolWindows.isEmpty()) {
                    return;
                }
                ToolWindowData removed = (ToolWindowData)ProjectData.this.myToolWindows.remove(toolWindow);
                if (removed == null) {
                    LOG.error("try to remove unregistered tool-window: " + id2 + ", tw=" + toolWindow);
                    return;
                }
                removed.release();
            }
        });
    }

    boolean isDisposed() {
        return this.myProject.isDisposed();
    }

    @NotNull
    BarContainer get(BarType type) {
        BarContainer result2 = this.myPermanentBars.get((Object)type);
        if (result2 == null) {
            result2 = new BarContainer(type, TouchBar.EMPTY, null, null);
            ProjectData._fillBarContainer(result2, this.myProject);
            this.myPermanentBars.put(type, result2);
        }
        return result2;
    }

    boolean checkToolWindowContents(Component child2) {
        for (ToolWindowData twd : this.myToolWindows.values()) {
            ToolWindowData.ContentData cnt = twd.findParentContent(child2);
            if (cnt == null) continue;
            cnt.setContextActionsVisible(true);
            return true;
        }
        return false;
    }

    @Nullable
    EditorData findEditorDataByComponent(Component child2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (EditorData editorData : this.myEditors.values()) {
            JComponent ecmp = editorData.editorHeader;
            if (child2 != ecmp && !SwingUtilities.isDescendingFrom(child2, ecmp) || editorData.containerSearch == null) continue;
            return editorData;
        }
        return null;
    }

    @Nullable
    BarContainer findDebugToolWindowByComponent(Component child2) {
        JComponent compR;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow dtw = toolWindowManager.getToolWindow("Debug");
        ToolWindow rtw = toolWindowManager.getToolWindow(RunDashboardManager.getInstance((Project)this.myProject).getToolWindowId());
        JComponent compD = dtw != null ? dtw.getComponent() : null;
        JComponent jComponent = compR = rtw != null ? rtw.getComponent() : null;
        if (compD == null && compR == null) {
            return null;
        }
        if (child2 == compD || child2 == compR || compD != null && SwingUtilities.isDescendingFrom(child2, compD) || compR != null && SwingUtilities.isDescendingFrom(child2, compR)) {
            return this.get(BarType.DEBUGGER);
        }
        return null;
    }

    void registerEditor(@NotNull Editor editor) {
        this.myEditors.put(editor, new EditorData(editor));
    }

    EditorData getEditorData(@NotNull Editor editor) {
        return this.myEditors.get(editor);
    }

    void removeEditor(@NotNull Editor editor) {
        if (this.myEditors.isEmpty()) {
            return;
        }
        EditorData removed = this.myEditors.remove(editor);
        if (removed == null) {
            return;
        }
        removed.release();
    }

    private static void _fillBarContainer(@NotNull BarContainer container2, @NotNull Project project) {
        boolean replaceEsc;
        String barId;
        ApplicationManager.getApplication().assertIsDispatchThread();
        @NotNull BarType type = container2.getType();
        if (type == BarType.DEFAULT) {
            barId = "Default";
            replaceEsc = false;
        } else if (type == BarType.DEBUGGER) {
            barId = "Debug";
            replaceEsc = true;
        } else {
            LOG.error("can't create touchbar, unknown context: " + (Object)((Object)type));
            return;
        }
        ActionGroup mainLayout = BuildUtils.getCustomizedGroup(barId);
        if (mainLayout == null) {
            LOG.info("can't create touchbar because corresponding ActionGroup isn't defined (seems that user deleted it), context: " + barId);
            return;
        }
        Map<String, ActionGroup> strmod2alt = BuildUtils.getAltLayouts(mainLayout);
        HashMap<Long, TouchBar> alts = new HashMap<Long, TouchBar>();
        if (!strmod2alt.isEmpty()) {
            for (String modId : strmod2alt.keySet()) {
                long mask = ProjectData._str2mask(modId);
                if (mask == 0L) continue;
                @NotNull TouchBar altTouchbar = BuildUtils.buildFromCustomizedGroup(type.name() + "_" + modId, strmod2alt.get(modId), replaceEsc);
                alts.put(mask, altTouchbar);
                altTouchbar.setAllowSkipSlowUpdates(true);
            }
        }
        container2.set(BuildUtils.buildFromCustomizedGroup(type.name(), mainLayout, replaceEsc), alts);
        container2.setProject(project);
    }

    void releaseAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPermanentBars.forEach((t, bc) -> bc.release());
        this.myPermanentBars.clear();
        this.myEditors.forEach((e, ed) -> ed.release());
        this.myEditors.clear();
        this.myToolWindows.forEach((tw, twd) -> twd.release());
        this.myToolWindows.clear();
    }

    void reloadAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPermanentBars.forEach((t, bc) -> {
            bc.release();
            ProjectData._fillBarContainer(bc, this.myProject);
        });
    }

    Collection<BarContainer> getAllContainers() {
        return this.myPermanentBars.values();
    }

    static long getUsedKeyMask() {
        return 960L;
    }

    private static long _str2mask(@NotNull String modifierId) {
        if (!modifierId.contains(".")) {
            if (modifierId.equalsIgnoreCase("alt")) {
                return 512L;
            }
            if (modifierId.equalsIgnoreCase("cmd")) {
                return 256L;
            }
            if (modifierId.equalsIgnoreCase("ctrl")) {
                return 128L;
            }
            if (modifierId.equalsIgnoreCase("shift")) {
                return 64L;
            }
            return 0L;
        }
        String[] spl = modifierId.split("\\.");
        long mask = 0L;
        for (String sub : spl) {
            mask |= ProjectData._str2mask(sub);
        }
        return mask;
    }

    private static ActionGroup _getTouchbarActions(Content content2) {
        JComponent component2 = content2.getComponent();
        return ProjectData._getTouchbarActions(component2);
    }

    private static ActionGroup _getTouchbarActions(Component component2) {
        return component2 instanceof DataProvider ? (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData((DataProvider)component2) : null;
    }

    class ToolWindowData
    implements ContentManagerListener {
        @NotNull
        final ToolWindow toolWindow;
        @NotNull
        final String toolWindowId;
        @NotNull
        final Map<Content, ContentData> contents = new HashMap<Content, ContentData>();

        ToolWindowData(@NotNull ToolWindow toolWindow, String toolWindowId) {
            this.toolWindow = toolWindow;
            this.toolWindowId = toolWindowId;
        }

        void release() {
        }

        @Nullable
        ContentData findParentContent(@NotNull Component childOfToolWindow) {
            if (this.contents.isEmpty()) {
                return null;
            }
            for (ContentData cd : this.contents.values()) {
                if (!SwingUtilities.isDescendingFrom(childOfToolWindow, cd.content.getComponent())) continue;
                return cd;
            }
            return null;
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            Content content2 = event.getContent();
            ContentData cd = this.contents.get(content2);
            if (cd != null) {
                LOG.error("try to register existing content '" + content2 + "', will be skipped");
                return;
            }
            ActionGroup optAction = ProjectData._getTouchbarActions(content2);
            if (optAction == null) {
                return;
            }
            this._registerContent(content2, optAction);
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            this._removeContent(event.getContent());
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
        }

        private void _registerContent(@NotNull Content content2, @NotNull ActionGroup optActions) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ContentData cd = this.contents.get(content2);
            if (cd != null) {
                LOG.error("try to register existing content '" + content2 + "' of ToolWindow " + this.toolWindowId + ", will be skipped");
                return;
            }
            cd = new ContentData(content2, ProjectData.this.get(BarType.DEFAULT));
            this.contents.put(content2, cd);
            cd.setOptionalContextActions(optActions);
        }

        private void _removeContent(@NotNull Content content2) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ContentData cd = this.contents.get(content2);
            if (cd == null) {
                return;
            }
            this.contents.remove(content2);
            cd.setOptionalContextActions(null);
        }

        private final class ContentData {
            @NotNull
            final Content content;
            @NotNull
            final BarContainer barContainer;
            @NotNull
            final String contextName;

            ContentData(@NotNull Content content2, BarContainer barContainer) {
                this.content = content2;
                this.barContainer = barContainer;
                this.contextName = ToolWindowData.this.toolWindowId + "_" + content2.toString();
            }

            void setOptionalContextActions(ActionGroup group) {
                this.barContainer.setOptionalContextActions(group, this.contextName);
            }

            void setContextActionsVisible(boolean visible) {
                this.barContainer.setOptionalContextVisible(visible ? this.contextName : null);
            }
        }
    }

    static final class EditorData {
        @NotNull
        final Editor editor;
        JComponent editorHeader;
        ActionGroup actionsSearch;
        BarContainer containerSearch;

        EditorData(@NotNull Editor editor) {
            this.editor = editor;
        }

        void release() {
            if (this.containerSearch != null) {
                this.containerSearch.release();
            }
            this.containerSearch = null;
        }
    }
}

