/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.layout.migLayout;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.SpacingConfiguration;
import com.intellij.ui.layout.migLayout.ComponentConstraintsKt;
import com.intellij.ui.layout.migLayout.DefaultComponentConstraintCreator$WhenMappings;
import com.intellij.ui.layout.migLayout.MigLayoutUtilKt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/layout/migLayout/DefaultComponentConstraintCreator;", "", "spacing", "Lcom/intellij/ui/layout/SpacingConfiguration;", "(Lcom/intellij/ui/layout/SpacingConfiguration;)V", "horizontalUnitSizeGap", "Lnet/miginfocom/layout/BoundSize;", "getHorizontalUnitSizeGap", "()Lnet/miginfocom/layout/BoundSize;", "mediumTextSizeSpec", "kotlin.jvm.PlatformType", "shortTextSizeSpec", "vertical1pxGap", "getVertical1pxGap", "addGrowIfNeeded", "", "cc", "Lnet/miginfocom/layout/CC;", "component", "Ljava/awt/Component;", "applyGrowPolicy", "growPolicy", "Lcom/intellij/ui/layout/GrowPolicy;", "intellij.platform.ide.impl"})
public final class DefaultComponentConstraintCreator {
    private final BoundSize shortTextSizeSpec;
    private final BoundSize mediumTextSizeSpec;
    @NotNull
    private final BoundSize vertical1pxGap;
    @NotNull
    private final BoundSize horizontalUnitSizeGap;
    private final SpacingConfiguration spacing;

    @NotNull
    public final BoundSize getVertical1pxGap() {
        return this.vertical1pxGap;
    }

    @NotNull
    public final BoundSize getHorizontalUnitSizeGap() {
        return this.horizontalUnitSizeGap;
    }

    public final void addGrowIfNeeded(@NotNull CC cc, @NotNull Component component2, @NotNull SpacingConfiguration spacing) {
        block2: {
            Component view;
            block4: {
                block3: {
                    block1: {
                        if (!(component2 instanceof ComponentWithBrowseButton)) break block1;
                        cc.minWidth(spacing.getMaxShortTextWidth() + "px");
                        cc.growX();
                        break block2;
                    }
                    if (component2 instanceof JTextField && ((JTextField)component2).getColumns() != 0) {
                        return;
                    }
                    if (!(component2 instanceof JTextComponent) && !(component2 instanceof SeparatorComponent) && !(component2 instanceof ComponentWithBrowseButton)) break block3;
                    cc.growX();
                    break block2;
                }
                if (!(component2 instanceof JScrollPane) && !ComponentConstraintsKt.access$isPanelWithToolbar(component2)) break block4;
                cc.grow().pushY();
                break block2;
            }
            if (!(component2 instanceof JScrollPane) || !((view = ((JScrollPane)component2).getViewport().getView()) instanceof JTextArea) || ((JTextArea)view).getRows() != 0) break block2;
            ((JTextArea)view).setRows(3);
        }
    }

    public final void applyGrowPolicy(@NotNull CC cc, @NotNull GrowPolicy growPolicy2) {
        BoundSize boundSize;
        DimConstraint dimConstraint = cc.getHorizontal();
        switch (DefaultComponentConstraintCreator$WhenMappings.$EnumSwitchMapping$0[growPolicy2.ordinal()]) {
            case 1: {
                boundSize = this.shortTextSizeSpec;
                break;
            }
            case 2: {
                boundSize = this.mediumTextSizeSpec;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dimConstraint.setSize(boundSize);
    }

    public DefaultComponentConstraintCreator(@NotNull SpacingConfiguration spacing) {
        this.spacing = spacing;
        this.shortTextSizeSpec = ConstraintParser.parseBoundSize((String)(this.spacing.getShortTextWidth() + "px!"), (boolean)false, (boolean)true);
        this.mediumTextSizeSpec = ConstraintParser.parseBoundSize((String)(this.spacing.getShortTextWidth() + "px::" + this.spacing.getMaxShortTextWidth() + "px"), (boolean)false, (boolean)true);
        this.vertical1pxGap = ConstraintParser.parseBoundSize((String)(JBUI.scale((int)1) + "px!"), (boolean)true, (boolean)false);
        this.horizontalUnitSizeGap = MigLayoutUtilKt.gapToBoundSize(this.spacing.getUnitSize(), true);
    }
}

